/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl;

import com.koloboke.collect.impl.Containers;
import com.koloboke.collect.impl.InternalIntFloatMapOps;
import com.koloboke.collect.map.IntFloatMap;
import com.koloboke.function.IntFloatConsumer;
import com.koloboke.function.IntFloatPredicate;
import java.util.Map;

public final class CommonIntFloatMapOps {
    public static boolean containsAllEntries(final InternalIntFloatMapOps map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof IntFloatMap) {
            IntFloatMap m2 = (IntFloatMap)another;
            if (map.size() < m2.size()) {
                return false;
            }
            if (m2 instanceof InternalIntFloatMapOps) {
                return ((InternalIntFloatMapOps)m2).allEntriesContainingIn(map);
            }
            return m2.forEachWhile(new IntFloatPredicate(){

                public boolean test(int a, float b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry((int)((Integer)e.getKey()), ((Float)e.getValue()).floatValue())) continue;
            return false;
        }
        return true;
    }

    public static void putAll(final InternalIntFloatMapOps map, Map<? extends Integer, ? extends Float> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof IntFloatMap) {
            if (another instanceof InternalIntFloatMapOps) {
                ((InternalIntFloatMapOps)another).reversePutAllTo(map);
            } else {
                ((IntFloatMap)another).forEach(new IntFloatConsumer(){

                    public void accept(int key, float value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<? extends Integer, ? extends Float> e : another.entrySet()) {
                map.justPut((int)e.getKey(), e.getValue().floatValue());
            }
        }
    }

    private CommonIntFloatMapOps() {
    }
}

