/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl;

import com.koloboke.collect.impl.Containers;
import com.koloboke.collect.impl.InternalLongByteMapOps;
import com.koloboke.collect.map.LongByteMap;
import com.koloboke.function.LongByteConsumer;
import com.koloboke.function.LongBytePredicate;
import java.util.Map;

public final class CommonLongByteMapOps {
    public static boolean containsAllEntries(final InternalLongByteMapOps map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof LongByteMap) {
            LongByteMap m2 = (LongByteMap)another;
            if (map.size() < m2.size()) {
                return false;
            }
            if (m2 instanceof InternalLongByteMapOps) {
                return ((InternalLongByteMapOps)m2).allEntriesContainingIn(map);
            }
            return m2.forEachWhile(new LongBytePredicate(){

                public boolean test(long a, byte b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry((Long)e.getKey(), (Byte)e.getValue())) continue;
            return false;
        }
        return true;
    }

    public static void putAll(final InternalLongByteMapOps map, Map<? extends Long, ? extends Byte> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof LongByteMap) {
            if (another instanceof InternalLongByteMapOps) {
                ((InternalLongByteMapOps)another).reversePutAllTo(map);
            } else {
                ((LongByteMap)another).forEach(new LongByteConsumer(){

                    public void accept(long key, byte value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<? extends Long, ? extends Byte> e : another.entrySet()) {
                map.justPut(e.getKey(), e.getValue());
            }
        }
    }

    private CommonLongByteMapOps() {
    }
}

