/*
 * Decompiled with CFR 0.152.
 */
package pw.prok.imagine.object.nbt;

import io.netty.buffer.Unpooled;
import java.util.BitSet;
import net.minecraft.nbt.NBTTagByteArray;
import pw.prok.imagine.object.nbt.INBTHandler;
import pw.prok.imagine.object.nbt.RegisterHandler;
import pw.prok.imagine.writer.WritableBuf;

@RegisterHandler(from=boolean[].class, to=NBTTagByteArray.class)
public class BooleanArrayHandler
implements INBTHandler<boolean[], NBTTagByteArray> {
    private static final boolean[] EMPTY = new boolean[0];

    private static byte[] booleanToBytes(boolean[] value) {
        int length = value.length;
        BitSet set = new BitSet();
        for (int i = 0; i < length; ++i) {
            set.set(i, value[i]);
        }
        return set.toByteArray();
    }

    private static boolean[] bytesToBoolean(byte[] value, int length) {
        boolean[] array = new boolean[length];
        BitSet set = BitSet.valueOf(value);
        for (int i = 0; i < length; ++i) {
            array[i] = set.get(i);
        }
        return array;
    }

    @Override
    public boolean[] read(NBTTagByteArray nbt) {
        byte[] bytes = nbt.func_150292_c();
        WritableBuf buf = new WritableBuf(bytes);
        int length = buf.readInt();
        if (length == 0) {
            return EMPTY;
        }
        int bytesLength = buf.readInt();
        byte[] z = new byte[bytesLength];
        buf.readBytes(z, 0, bytesLength);
        return BooleanArrayHandler.bytesToBoolean(z, length);
    }

    @Override
    public NBTTagByteArray write(boolean[] value) {
        int length = value.length;
        byte[] bytes = BooleanArrayHandler.booleanToBytes(value);
        int byteLength = 4 + bytes.length;
        WritableBuf buf = new WritableBuf(Unpooled.buffer((int)byteLength, (int)byteLength));
        buf.writeInt(length);
        if (length != 0) {
            buf.writeInt(bytes.length);
            buf.writeBytes(bytes);
        }
        return new NBTTagByteArray(buf.array());
    }
}

