/*
 * Decompiled with CFR 0.152.
 */
package pw.prok.imagine.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class Array {
    public static <T> T[] newArray(Class<T> clazz, int length) {
        return (Object[])java.lang.reflect.Array.newInstance(clazz, length);
    }

    public static <T> T[] newArrayUnchecked(Class<?> clazz, int length) {
        return Array.newArray(clazz, length);
    }

    public static <T> T[] appendToArray(T[] array, T ... objects) {
        if (array == null || array.length == 0) {
            return objects;
        }
        if (objects == null || objects.length == 0) {
            return array;
        }
        int i1 = array.length;
        int i2 = objects.length;
        T[] newArray = Array.newArrayUnchecked(array.getClass().getComponentType(), i1 + i2);
        System.arraycopy(array, 0, newArray, 0, i1);
        System.arraycopy(objects, 0, newArray, i1, i2);
        return newArray;
    }

    public static <T> T[] mergeArrays(T[] ... arrays) {
        if (arrays == null) {
            return null;
        }
        int length = 0;
        Class<?> componentClass = null;
        for (T[] array : arrays) {
            if (array == null) continue;
            if (componentClass == null) {
                componentClass = array.getClass().getComponentType();
            }
            length += array.length;
        }
        if (componentClass == null) {
            return null;
        }
        T[] newArray = Array.newArray(componentClass, length);
        int index = 0;
        for (T[] array : arrays) {
            if (array == null) continue;
            System.arraycopy(array, 0, newArray, index, array.length);
            index += array.length;
        }
        return newArray;
    }

    public static <T> T[] asArray(Collection<T> collection) {
        return Array.asArray(collection, null);
    }

    public static <T> T[] asArray(Collection<T> collection, Class<T> clazz) {
        int size = collection.size();
        Class<Object> component = clazz;
        if (clazz == null) {
            if (size == 0) {
                return null;
            }
            T t = collection.iterator().next();
            component = t.getClass();
        }
        T[] array = Array.newArray(component, size);
        collection.toArray(array);
        return array;
    }

    public static <T> T[] keys(Map<T, ?> map) {
        return Array.keys(map, null);
    }

    public static <T> T[] keys(Map<T, ?> map, Class<T> clazz) {
        return Array.asArray(map.keySet(), clazz);
    }

    public static <T> T[] values(Map<?, T> map) {
        return Array.values(map, null);
    }

    public static <T> T[] values(Map<?, T> map, Class<T> clazz) {
        return Array.asArray(map.values(), clazz);
    }

    public static <T> List<T> asList(T ... values) {
        ArrayList list = new ArrayList(values.length);
        Collections.addAll(list, values);
        return list;
    }
}

