/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_7_R4;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Date;
import java.util.Set;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.bukkit.BanEntry;
import org.bukkit.BanList;
import org.bukkit.craftbukkit.v1_7_R4.CraftIpBanEntry;

public class CraftIpBanList
implements BanList {
    private final nx list;

    public CraftIpBanList(nx list) {
        this.list = list;
    }

    @Override
    public BanEntry getBanEntry(String target) {
        Validate.notNull((Object)target, (String)"Target cannot be null");
        ny entry = (ny)this.list.b((Object)target);
        if (entry == null) {
            return null;
        }
        return new CraftIpBanEntry(target, entry, this.list);
    }

    @Override
    public BanEntry addBan(String target, String reason, Date expires, String source) {
        Validate.notNull((Object)target, (String)"Ban target cannot be null");
        ny entry = new ny(target, new Date(), StringUtils.isBlank((String)source) ? null : source, expires, StringUtils.isBlank((String)reason) ? null : reason);
        this.list.a((ol)entry);
        try {
            this.list.f();
        }
        catch (IOException ex) {
            MinecraftServer.getLogger().error("Failed to save banned-ips.json, " + ex.getMessage());
        }
        return new CraftIpBanEntry(target, entry, this.list);
    }

    @Override
    public Set<BanEntry> getBanEntries() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String target : this.list.a()) {
            builder.add((Object)new CraftIpBanEntry(target, (ny)this.list.b((Object)target), this.list));
        }
        return builder.build();
    }

    @Override
    public boolean isBanned(String target) {
        Validate.notNull((Object)target, (String)"Target cannot be null");
        return this.list.a((SocketAddress)InetSocketAddress.createUnresolved(target, 0));
    }

    @Override
    public void pardon(String target) {
        Validate.notNull((Object)target, (String)"Target cannot be null");
        this.list.c((Object)target);
    }
}

