/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_7_R4;

import com.mojang.authlib.GameProfile;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraftforge.common.util.FakePlayerFactory;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.craftbukkit.v1_7_R4.CraftServer;
import org.bukkit.entity.Player;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

@SerializableAs(value="Player")
public class CraftOfflinePlayer
implements OfflinePlayer,
ConfigurationSerializable {
    private final GameProfile profile;
    private final CraftServer server;
    private final ayq storage;

    protected CraftOfflinePlayer(CraftServer server, GameProfile profile) {
        this.server = server;
        this.profile = profile;
        this.storage = (ayq)((mt)server.console.worlds.get(0)).M();
    }

    public GameProfile getProfile() {
        return this.profile;
    }

    @Override
    public boolean isOnline() {
        return this.getPlayer() != null;
    }

    @Override
    public String getName() {
        Player player = this.getPlayer();
        if (player != null) {
            return player.getName();
        }
        if (this.profile.getName() != null) {
            return this.profile.getName();
        }
        dh data = this.getBukkitData();
        if (data != null && data.c("lastKnownName")) {
            return data.j("lastKnownName");
        }
        return null;
    }

    @Override
    public UUID getUniqueId() {
        return this.profile.getId();
    }

    public Server getServer() {
        return this.server;
    }

    @Override
    public boolean isOp() {
        return this.server.getHandle().g(this.profile);
    }

    @Override
    public void setOp(boolean value) {
        if (value == this.isOp()) {
            return;
        }
        if (value) {
            this.server.getHandle().a(this.profile);
        } else {
            this.server.getHandle().b(this.profile);
        }
    }

    @Override
    public boolean isBanned() {
        if (this.getName() == null) {
            return false;
        }
        return this.server.getBanList(BanList.Type.NAME).isBanned(this.getName());
    }

    @Override
    public void setBanned(boolean value) {
        if (this.getName() == null) {
            return;
        }
        if (value) {
            this.server.getBanList(BanList.Type.NAME).addBan(this.getName(), null, null, null);
        } else {
            this.server.getBanList(BanList.Type.NAME).pardon(this.getName());
        }
    }

    @Override
    public boolean isWhitelisted() {
        return this.server.getHandle().e(this.profile);
    }

    @Override
    public void setWhitelisted(boolean value) {
        if (value) {
            this.server.getHandle().d(this.profile);
        } else {
            this.server.getHandle().c(this.profile);
        }
    }

    @Override
    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("UUID", this.profile.getId().toString());
        return result;
    }

    public static OfflinePlayer deserialize(Map<String, Object> args) {
        if (args.get("name") != null) {
            return Bukkit.getServer().getOfflinePlayer((String)args.get("name"));
        }
        return Bukkit.getServer().getOfflinePlayer(UUID.fromString((String)args.get("UUID")));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[UUID=" + this.profile.getId() + "]";
    }

    @Override
    public Player getPlayer() {
        for (Object obj : this.server.getHandle().e) {
            mw player = (mw)obj;
            if (!player.aB().equals(this.getUniqueId())) continue;
            return player.a != null ? player.a.getPlayerB() : null;
        }
        yz player = (yz)FakePlayerFactory.fakePlayers.get(this.profile);
        return player != null ? (Player)((Object)player.getBukkitEntity()) : null;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof OfflinePlayer)) {
            return false;
        }
        OfflinePlayer other = (OfflinePlayer)obj;
        if (this.getUniqueId() == null || other.getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(other.getUniqueId());
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + (this.getUniqueId() != null ? this.getUniqueId().hashCode() : 0);
        return hash;
    }

    private dh getData() {
        return this.storage.getPlayerData(this.getUniqueId().toString());
    }

    private dh getBukkitData() {
        dh result = this.getData();
        if (result != null) {
            if (!result.c("bukkit")) {
                result.a("bukkit", (dy)new dh());
            }
            result = result.m("bukkit");
        }
        return result;
    }

    private File getDataFile() {
        return new File(this.storage.getPlayerDir(), this.getUniqueId() + ".dat");
    }

    @Override
    public long getFirstPlayed() {
        Player player = this.getPlayer();
        if (player != null) {
            return player.getFirstPlayed();
        }
        dh data = this.getBukkitData();
        if (data != null) {
            if (data.c("firstPlayed")) {
                return data.g("firstPlayed");
            }
            File file = this.getDataFile();
            return file.lastModified();
        }
        return 0L;
    }

    @Override
    public long getLastPlayed() {
        Player player = this.getPlayer();
        if (player != null) {
            return player.getLastPlayed();
        }
        dh data = this.getBukkitData();
        if (data != null) {
            if (data.c("lastPlayed")) {
                return data.g("lastPlayed");
            }
            File file = this.getDataFile();
            return file.lastModified();
        }
        return 0L;
    }

    @Override
    public boolean hasPlayedBefore() {
        return this.getData() != null;
    }

    @Override
    public Location getBedSpawnLocation() {
        dh data = this.getData();
        if (data == null) {
            return null;
        }
        if (data.c("SpawnX") && data.c("SpawnY") && data.c("SpawnZ")) {
            String spawnWorld = data.j("SpawnWorld");
            if (spawnWorld.equals("")) {
                spawnWorld = this.server.getWorlds().get(0).getName();
            }
            return new Location(this.server.getWorld(spawnWorld), data.f("SpawnX"), data.f("SpawnY"), data.f("SpawnZ"));
        }
        return null;
    }

    public void setMetadata(String metadataKey, MetadataValue metadataValue) {
        this.server.getPlayerMetadata().setMetadata(this, metadataKey, metadataValue);
    }

    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.server.getPlayerMetadata().getMetadata(this, metadataKey);
    }

    public boolean hasMetadata(String metadataKey) {
        return this.server.getPlayerMetadata().hasMetadata(this, metadataKey);
    }

    public void removeMetadata(String metadataKey, Plugin plugin) {
        this.server.getPlayerMetadata().removeMetadata(this, metadataKey, plugin);
    }
}

