/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_7_R4.inventory;

import org.bukkit.craftbukkit.v1_7_R4.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_7_R4.inventory.CraftInventory;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;

public class CraftContainer
extends zs {
    private final InventoryView view;
    private InventoryType cachedType;
    private String cachedTitle;
    private final int cachedSize;

    public CraftContainer(InventoryView view, int id) {
        this.view = view;
        this.d = id;
        rb top = ((CraftInventory)view.getTopInventory()).getInventory();
        rb bottom = ((CraftInventory)view.getBottomInventory()).getInventory();
        this.cachedType = view.getType();
        this.cachedTitle = view.getTitle();
        this.cachedSize = this.getSize();
        this.setupSlots(top, bottom, new zs[0]);
    }

    public CraftContainer(final Inventory inventory, final HumanEntity player, int id) {
        this(new InventoryView(){

            @Override
            public Inventory getTopInventory() {
                return inventory;
            }

            @Override
            public Inventory getBottomInventory() {
                return player.getInventory();
            }

            @Override
            public HumanEntity getPlayer() {
                return player;
            }

            @Override
            public InventoryType getType() {
                return inventory.getType();
            }
        }, id);
    }

    public InventoryView getBukkitView() {
        return this.view;
    }

    private int getSize() {
        return this.view.getTopInventory().getSize();
    }

    public boolean c(yz entityhuman) {
        if (this.cachedType == this.view.getType() && this.cachedSize == this.getSize() && this.cachedTitle.equals(this.view.getTitle())) {
            return true;
        }
        boolean typeChanged = this.cachedType != this.view.getType();
        this.cachedType = this.view.getType();
        this.cachedTitle = this.view.getTitle();
        if (this.view.getPlayer() instanceof CraftPlayer) {
            CraftPlayer player = (CraftPlayer)this.view.getPlayer();
            int type = CraftContainer.getNotchInventoryType(this.cachedType);
            rb top = ((CraftInventory)this.view.getTopInventory()).getInventory();
            rb bottom = ((CraftInventory)this.view.getBottomInventory()).getInventory();
            this.b.clear();
            this.c.clear();
            if (typeChanged) {
                this.setupSlots(top, bottom, entityhuman.bo);
            }
            int size = this.getSize();
            player.getHandle().a.a((ft)new gn(this.d, type, this.cachedTitle, size, true));
            player.updateInventory();
        }
        return true;
    }

    public static int getNotchInventoryType(InventoryType type) {
        int typeID;
        switch (type) {
            case WORKBENCH: {
                typeID = 1;
                break;
            }
            case FURNACE: {
                typeID = 2;
                break;
            }
            case DISPENSER: {
                typeID = 3;
                break;
            }
            case ENCHANTING: {
                typeID = 4;
                break;
            }
            case BREWING: {
                typeID = 5;
                break;
            }
            case BEACON: {
                typeID = 7;
                break;
            }
            case ANVIL: {
                typeID = 8;
                break;
            }
            case HOPPER: {
                typeID = 9;
                break;
            }
            default: {
                typeID = 0;
            }
        }
        return typeID;
    }

    private void setupSlots(rb top, rb bottom, zs ... openContainer) {
        switch (this.cachedType) {
            case CREATIVE: {
                break;
            }
            case PLAYER: 
            case CHEST: {
                this.setupChest(top, bottom);
                break;
            }
            case DISPENSER: {
                this.setupDispenser(top, bottom);
                break;
            }
            case FURNACE: {
                this.setupFurnace(top, bottom);
                break;
            }
            case WORKBENCH: 
            case CRAFTING: {
                this.setupWorkbench(top, bottom);
                break;
            }
            case ENCHANTING: {
                this.setupEnchanting(top, bottom);
                break;
            }
            case BREWING: {
                this.setupBrewing(top, bottom);
                break;
            }
            case HOPPER: {
                this.setupHopper(top, bottom);
                break;
            }
            default: {
                if (openContainer.length <= 0) break;
                this.setupCustomInventory(top, bottom, openContainer[0]);
            }
        }
    }

    private void setupCustomInventory(rb top, rb bottom, zs openContainer) {
        for (aay s : openContainer.c) {
            this.a(s);
        }
    }

    private void setupChest(rb top, rb bottom) {
        int col;
        int row;
        int rows = top.a() / 9;
        int i = (rows - 4) * 18;
        for (row = 0; row < rows; ++row) {
            for (col = 0; col < 9; ++col) {
                this.a(new aay(top, col + row * 9, 8 + col * 18, 18 + row * 18));
            }
        }
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.a(new aay(bottom, col + row * 9 + 9, 8 + col * 18, 103 + row * 18 + i));
            }
        }
        for (col = 0; col < 9; ++col) {
            this.a(new aay(bottom, col, 8 + col * 18, 161 + i));
        }
    }

    private void setupWorkbench(rb top, rb bottom) {
        int col;
        int row;
        this.a(new aay(top, 0, 124, 35));
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 3; ++col) {
                this.a(new aay(top, 1 + col + row * 3, 30 + col * 18, 17 + row * 18));
            }
        }
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.a(new aay(bottom, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (col = 0; col < 9; ++col) {
            this.a(new aay(bottom, col, 8 + col * 18, 142));
        }
    }

    private void setupFurnace(rb top, rb bottom) {
        int col;
        this.a(new aay(top, 0, 56, 17));
        this.a(new aay(top, 1, 56, 53));
        this.a(new aay(top, 2, 116, 35));
        for (int row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.a(new aay(bottom, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (col = 0; col < 9; ++col) {
            this.a(new aay(bottom, col, 8 + col * 18, 142));
        }
    }

    private void setupDispenser(rb top, rb bottom) {
        int col;
        int row;
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 3; ++col) {
                this.a(new aay(top, col + row * 3, 61 + col * 18, 17 + row * 18));
            }
        }
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.a(new aay(bottom, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (col = 0; col < 9; ++col) {
            this.a(new aay(bottom, col, 8 + col * 18, 142));
        }
    }

    private void setupEnchanting(rb top, rb bottom) {
        int row;
        this.a(new aay(top, 0, 25, 47));
        for (row = 0; row < 3; ++row) {
            for (int i1 = 0; i1 < 9; ++i1) {
                this.a(new aay(bottom, i1 + row * 9 + 9, 8 + i1 * 18, 84 + row * 18));
            }
        }
        for (row = 0; row < 9; ++row) {
            this.a(new aay(bottom, row, 8 + row * 18, 142));
        }
    }

    private void setupBrewing(rb top, rb bottom) {
        int i;
        this.a(new aay(top, 0, 56, 46));
        this.a(new aay(top, 1, 79, 53));
        this.a(new aay(top, 2, 102, 46));
        this.a(new aay(top, 3, 79, 17));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.a(new aay(bottom, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.a(new aay(bottom, i, 8 + i * 18, 142));
        }
    }

    private void setupHopper(rb top, rb bottom) {
        int i;
        int b0 = 51;
        for (i = 0; i < top.a(); ++i) {
            this.a(new aay(top, i, 44 + i * 18, 20));
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.a(new aay(bottom, j + i * 9 + 9, 8 + j * 18, i * 18 + b0));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.a(new aay(bottom, i, 8 + i * 18, 58 + b0));
        }
    }

    public boolean a(yz entity) {
        return true;
    }
}

