/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.plugin;

import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.EventException;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredListener;

public class TimedRegisteredListener
extends RegisteredListener {
    private int count;
    private long totalTime;
    public long curTickTotal = 0L;
    public long violations = 0L;
    private Class<? extends Event> eventClass;
    private boolean multiple = false;

    public TimedRegisteredListener(Listener pluginListener, EventExecutor eventExecutor, EventPriority eventPriority, Plugin registeredPlugin, boolean listenCancelled) {
        super(pluginListener, eventExecutor, eventPriority, registeredPlugin, listenCancelled);
    }

    @Override
    public void callEvent(Event event) throws EventException {
        if (Bukkit.getServer() != null && !Bukkit.getServer().getPluginManager().useTimings()) {
            super.callEvent(event);
            return;
        }
        if (event.isAsynchronous()) {
            super.callEvent(event);
            return;
        }
        ++this.count;
        Class<?> newEventClass = event.getClass();
        if (this.eventClass == null) {
            this.eventClass = newEventClass;
        } else if (!this.eventClass.equals(newEventClass)) {
            this.multiple = true;
            this.eventClass = TimedRegisteredListener.getCommonSuperclass(newEventClass, this.eventClass).asSubclass(Event.class);
        }
        long start = System.nanoTime();
        super.callEvent(event);
        long diff = System.nanoTime() - start;
        this.curTickTotal += diff;
        this.totalTime += diff;
    }

    private static Class<?> getCommonSuperclass(Class<?> class1, Class<?> class2) {
        while (!class1.isAssignableFrom(class2)) {
            class1 = class1.getSuperclass();
        }
        return class1;
    }

    public void reset() {
        this.count = 0;
        this.totalTime = 0L;
        this.curTickTotal = 0L;
        this.violations = 0L;
    }

    public int getCount() {
        return this.count;
    }

    public long getTotalTime() {
        return this.totalTime;
    }

    public Class<? extends Event> getEventClass() {
        return this.eventClass;
    }

    public boolean hasMultiple() {
        return this.multiple;
    }
}

