/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.SpriteSources;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.data.JsonCodecProvider;

public abstract class SpriteSourceProvider
extends JsonCodecProvider<List<SpriteSource>> {
    protected static final ResourceLocation BLOCKS_ATLAS = ResourceLocation.withDefaultNamespace((String)"blocks");
    protected static final ResourceLocation BANNER_PATTERNS_ATLAS = ResourceLocation.withDefaultNamespace((String)"banner_patterns");
    protected static final ResourceLocation BEDS_ATLAS = ResourceLocation.withDefaultNamespace((String)"beds");
    protected static final ResourceLocation CHESTS_ATLAS = ResourceLocation.withDefaultNamespace((String)"chests");
    protected static final ResourceLocation SHIELD_PATTERNS_ATLAS = ResourceLocation.withDefaultNamespace((String)"shield_patterns");
    protected static final ResourceLocation SHULKER_BOXES_ATLAS = ResourceLocation.withDefaultNamespace((String)"shulker_boxes");
    protected static final ResourceLocation SIGNS_ATLAS = ResourceLocation.withDefaultNamespace((String)"signs");
    protected static final ResourceLocation MOB_EFFECTS_ATLAS = ResourceLocation.withDefaultNamespace((String)"mob_effects");
    protected static final ResourceLocation PAINTINGS_ATLAS = ResourceLocation.withDefaultNamespace((String)"paintings");
    protected static final ResourceLocation PARTICLES_ATLAS = ResourceLocation.withDefaultNamespace((String)"particles");
    private final Map<ResourceLocation, SourceList> atlases = new HashMap<ResourceLocation, SourceList>();

    public SpriteSourceProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, String modId) {
        super(output, PackOutput.Target.RESOURCE_PACK, "atlases", SpriteSources.FILE_CODEC, lookupProvider, modId);
    }

    protected final SourceList atlas(ResourceLocation id) {
        return this.atlases.computeIfAbsent(id, i -> {
            SourceList newAtlas = new SourceList(new ArrayList<SpriteSource>());
            this.unconditional((ResourceLocation)i, newAtlas.sources());
            return newAtlas;
        });
    }

    protected record SourceList(List<SpriteSource> sources) {
        public SourceList addSource(SpriteSource source) {
            this.sources.add(source);
            return this;
        }
    }
}

