/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.event;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.stream.IntStream;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.event.IModBusEvent;
import net.neoforged.neoforge.client.gui.GuiLayerManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class RegisterGuiLayersEvent
extends Event
implements IModBusEvent {
    private final List<GuiLayerManager.NamedLayer> layers;

    @ApiStatus.Internal
    public RegisterGuiLayersEvent(List<GuiLayerManager.NamedLayer> layers) {
        this.layers = layers;
    }

    public void registerBelowAll(ResourceLocation id, LayeredDraw.Layer layer) {
        this.register(Ordering.BEFORE, null, id, layer);
    }

    public void registerBelow(ResourceLocation other, ResourceLocation id, LayeredDraw.Layer layer) {
        this.register(Ordering.BEFORE, other, id, layer);
    }

    public void registerAbove(ResourceLocation other, ResourceLocation id, LayeredDraw.Layer layer) {
        this.register(Ordering.AFTER, other, id, layer);
    }

    public void registerAboveAll(ResourceLocation id, LayeredDraw.Layer layer) {
        this.register(Ordering.AFTER, null, id, layer);
    }

    private void register(Ordering ordering, @Nullable ResourceLocation other, ResourceLocation key, LayeredDraw.Layer layer) {
        int insertPosition;
        Objects.requireNonNull(key);
        for (GuiLayerManager.NamedLayer namedLayer : this.layers) {
            Preconditions.checkArgument((!namedLayer.name().equals((Object)key) ? 1 : 0) != 0, (Object)("Layer already registered: " + String.valueOf(key)));
        }
        if (other == null) {
            insertPosition = ordering == Ordering.BEFORE ? 0 : this.layers.size();
        } else {
            OptionalInt otherIndex = IntStream.range(0, this.layers.size()).filter(i -> this.layers.get(i).name().equals((Object)other)).findFirst();
            if (otherIndex.isEmpty()) {
                throw new IllegalArgumentException("Attempted to order against an unregistered layer " + String.valueOf(other) + ". Only order against vanilla's and your own.");
            }
            insertPosition = otherIndex.getAsInt() + (ordering == Ordering.BEFORE ? 0 : 1);
        }
        this.layers.add(insertPosition, new GuiLayerManager.NamedLayer(key, layer));
    }

    private static enum Ordering {
        BEFORE,
        AFTER;

    }
}

