/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.network.handlers;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.netty.buffer.Unpooled;
import java.lang.runtime.SwitchBootstraps;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.crafting.RecipeMap;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.client.event.RecipesReceivedEvent;
import net.neoforged.neoforge.client.registries.ClientRegistryManager;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.world.AuxiliaryLightManager;
import net.neoforged.neoforge.common.world.LevelChunkAuxiliaryLightManager;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;
import net.neoforged.neoforge.network.ConfigSync;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.payload.AdvancedAddEntityPayload;
import net.neoforged.neoforge.network.payload.AdvancedContainerSetDataPayload;
import net.neoforged.neoforge.network.payload.AdvancedOpenScreenPayload;
import net.neoforged.neoforge.network.payload.AuxiliaryLightDataPayload;
import net.neoforged.neoforge.network.payload.ClientDispatchPayload;
import net.neoforged.neoforge.network.payload.ClientboundCustomSetTimePayload;
import net.neoforged.neoforge.network.payload.ConfigFilePayload;
import net.neoforged.neoforge.network.payload.FrozenRegistryPayload;
import net.neoforged.neoforge.network.payload.FrozenRegistrySyncCompletedPayload;
import net.neoforged.neoforge.network.payload.FrozenRegistrySyncStartPayload;
import net.neoforged.neoforge.network.payload.KnownRegistryDataMapsPayload;
import net.neoforged.neoforge.network.payload.RecipeContentPayload;
import net.neoforged.neoforge.network.payload.RegistryDataMapSyncPayload;
import net.neoforged.neoforge.registries.RegistryManager;
import net.neoforged.neoforge.registries.RegistrySnapshot;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiStatus.Internal
public final class ClientPayloadHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientPayloadHandler.class);
    private static final Set<ResourceLocation> toSynchronize = Sets.newConcurrentHashSet();
    private static final Map<ResourceLocation, RegistrySnapshot> synchronizedRegistries = Maps.newConcurrentMap();

    private ClientPayloadHandler() {
    }

    public static void dispatch(ClientDispatchPayload payload, IPayloadContext context) {
        ClientDispatchPayload clientDispatchPayload = payload;
        Objects.requireNonNull(clientDispatchPayload);
        ClientDispatchPayload clientDispatchPayload2 = clientDispatchPayload;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AdvancedAddEntityPayload.class, AdvancedContainerSetDataPayload.class, AdvancedOpenScreenPayload.class, AuxiliaryLightDataPayload.class, ClientboundCustomSetTimePayload.class, ConfigFilePayload.class, FrozenRegistryPayload.class, FrozenRegistrySyncCompletedPayload.class, FrozenRegistrySyncStartPayload.class, KnownRegistryDataMapsPayload.class, RecipeContentPayload.class, RegistryDataMapSyncPayload.class}, (Object)clientDispatchPayload2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                AdvancedAddEntityPayload advancedAddEntityPayload = (AdvancedAddEntityPayload)clientDispatchPayload2;
                ClientPayloadHandler.handle(advancedAddEntityPayload, context);
                break;
            }
            case 1: {
                AdvancedContainerSetDataPayload advancedContainerSetDataPayload = (AdvancedContainerSetDataPayload)clientDispatchPayload2;
                ClientPayloadHandler.handle(advancedContainerSetDataPayload, context);
                break;
            }
            case 2: {
                AdvancedOpenScreenPayload advancedOpenScreenPayload = (AdvancedOpenScreenPayload)clientDispatchPayload2;
                ClientPayloadHandler.handle(advancedOpenScreenPayload, context);
                break;
            }
            case 3: {
                AuxiliaryLightDataPayload auxiliaryLightDataPayload = (AuxiliaryLightDataPayload)clientDispatchPayload2;
                ClientPayloadHandler.handle(auxiliaryLightDataPayload, context);
                break;
            }
            case 4: {
                ClientboundCustomSetTimePayload clientboundCustomSetTimePayload = (ClientboundCustomSetTimePayload)clientDispatchPayload2;
                ClientPayloadHandler.handle(clientboundCustomSetTimePayload, context);
                break;
            }
            case 5: {
                ConfigFilePayload configFilePayload = (ConfigFilePayload)clientDispatchPayload2;
                ClientPayloadHandler.handle(configFilePayload, context);
                break;
            }
            case 6: {
                FrozenRegistryPayload frozenRegistryPayload = (FrozenRegistryPayload)clientDispatchPayload2;
                ClientPayloadHandler.handle(frozenRegistryPayload, context);
                break;
            }
            case 7: {
                FrozenRegistrySyncCompletedPayload frozenRegistrySyncCompletedPayload = (FrozenRegistrySyncCompletedPayload)clientDispatchPayload2;
                ClientPayloadHandler.handle(frozenRegistrySyncCompletedPayload, context);
                break;
            }
            case 8: {
                FrozenRegistrySyncStartPayload frozenRegistrySyncStartPayload = (FrozenRegistrySyncStartPayload)clientDispatchPayload2;
                ClientPayloadHandler.handle(frozenRegistrySyncStartPayload, context);
                break;
            }
            case 9: {
                KnownRegistryDataMapsPayload knownRegistryDataMapsPayload = (KnownRegistryDataMapsPayload)clientDispatchPayload2;
                ClientRegistryManager.handleKnownDataMaps(knownRegistryDataMapsPayload, context);
                break;
            }
            case 10: {
                RecipeContentPayload recipeContentPayload = (RecipeContentPayload)clientDispatchPayload2;
                ClientPayloadHandler.handle(recipeContentPayload, context);
                break;
            }
            case 11: {
                RegistryDataMapSyncPayload registryDataMapSyncPayload = (RegistryDataMapSyncPayload)clientDispatchPayload2;
                ClientRegistryManager.handleDataMapSync(registryDataMapSyncPayload, context);
            }
        }
    }

    private static void handle(FrozenRegistryPayload payload, IPayloadContext context) {
        synchronizedRegistries.put(payload.registryName(), payload.snapshot());
        toSynchronize.remove(payload.registryName());
    }

    private static void handle(FrozenRegistrySyncStartPayload payload, IPayloadContext context) {
        toSynchronize.addAll(payload.toAccess());
        synchronizedRegistries.clear();
    }

    private static void handle(FrozenRegistrySyncCompletedPayload payload, IPayloadContext context) {
        if (!toSynchronize.isEmpty()) {
            context.disconnect((Component)Component.translatable((String)"neoforge.network.registries.sync.missing", (Object[])new Object[]{toSynchronize.stream().map(Object::toString).collect(Collectors.joining(", "))}));
            return;
        }
        try {
            Set<ResourceKey<?>> keysUnknownToClient = RegistryManager.applySnapshot(synchronizedRegistries, false, false);
            if (!keysUnknownToClient.isEmpty()) {
                context.disconnect((Component)Component.translatable((String)"neoforge.network.registries.sync.server-with-unknown-keys", (Object[])new Object[]{keysUnknownToClient.stream().map(Object::toString).collect(Collectors.joining(", "))}));
                return;
            }
            toSynchronize.clear();
            synchronizedRegistries.clear();
            context.reply(FrozenRegistrySyncCompletedPayload.INSTANCE);
        }
        catch (Throwable t) {
            LOGGER.error("Failed to handle registry sync from server.", t);
            context.disconnect((Component)Component.translatable((String)"neoforge.network.registries.sync.failed", (Object[])new Object[]{t.toString()}));
        }
    }

    private static void handle(ConfigFilePayload payload, IPayloadContext context) {
        if (!context.connection().isMemoryConnection()) {
            ConfigSync.receiveSyncedConfig(payload.contents(), payload.fileName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handle(AdvancedAddEntityPayload advancedAddEntityPayload, IPayloadContext context) {
        block5: {
            try {
                Entity entity = context.player().level().getEntity(advancedAddEntityPayload.entityId());
                if (!(entity instanceof IEntityWithComplexSpawn)) break block5;
                IEntityWithComplexSpawn entityAdditionalSpawnData = (IEntityWithComplexSpawn)entity;
                RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf(Unpooled.wrappedBuffer((byte[])advancedAddEntityPayload.customPayload()), entity.registryAccess(), context.listener().getConnectionType());
                try {
                    entityAdditionalSpawnData.readSpawnData(buf);
                }
                finally {
                    buf.release();
                }
            }
            catch (Throwable t) {
                LOGGER.error("Failed to handle advanced add entity from server.", t);
                context.disconnect((Component)Component.translatable((String)"neoforge.network.advanced_add_entity.failed", (Object[])new Object[]{t.toString()}));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handle(AdvancedOpenScreenPayload msg, IPayloadContext context) {
        Minecraft mc = Minecraft.getInstance();
        RegistryAccess registryAccess = mc.player.registryAccess();
        RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf(Unpooled.wrappedBuffer((byte[])msg.additionalData()), registryAccess, context.listener().getConnectionType());
        try {
            ClientPayloadHandler.createMenuScreen(msg.name(), msg.menuType(), msg.windowId(), buf);
        }
        catch (Throwable t) {
            LOGGER.error("Failed to handle advanced open screen from server.", t);
            context.disconnect((Component)Component.translatable((String)"neoforge.network.advanced_open_screen.failed", (Object[])new Object[]{t.toString()}));
        }
        finally {
            buf.release();
        }
    }

    private static <T extends AbstractContainerMenu> void createMenuScreen(Component name, MenuType<T> menuType, int windowId, RegistryFriendlyByteBuf buf) {
        Minecraft mc = Minecraft.getInstance();
        MenuScreens.getScreenFactory(menuType).ifPresent(f -> {
            Screen s = f.create(menuType.create(windowId, mc.player.getInventory(), buf), mc.player.getInventory(), name);
            mc.player.containerMenu = ((MenuAccess)s).getMenu();
            mc.setScreen(s);
        });
    }

    private static void handle(AuxiliaryLightDataPayload msg, IPayloadContext context) {
        try {
            Minecraft mc = Minecraft.getInstance();
            if (mc.level == null) {
                return;
            }
            AuxiliaryLightManager lightManager = mc.level.getAuxLightManager(msg.pos());
            if (lightManager instanceof LevelChunkAuxiliaryLightManager) {
                LevelChunkAuxiliaryLightManager manager = (LevelChunkAuxiliaryLightManager)lightManager;
                manager.handleLightDataSync(msg.entries());
            }
        }
        catch (Throwable t) {
            LOGGER.error("Failed to handle auxiliary light data from server.", t);
            context.disconnect((Component)Component.translatable((String)"neoforge.network.aux_light_data.failed", (Object[])new Object[]{msg.pos().toString(), t.toString()}));
        }
    }

    private static void handle(AdvancedContainerSetDataPayload msg, IPayloadContext context) {
        context.handle((Packet<?>)msg.toVanillaPacket());
    }

    private static void handle(ClientboundCustomSetTimePayload payload, IPayloadContext context) {
        ClientLevel level = Minecraft.getInstance().level;
        level.setTimeFromServer(payload.gameTime(), payload.dayTime(), payload.gameRule());
        level.setDayTimeFraction(payload.dayTimeFraction());
        level.setDayTimePerTick(payload.dayTimePerTick());
    }

    private static void handle(RecipeContentPayload payload, IPayloadContext context) {
        RecipeMap recipeMap = RecipeMap.create(payload.recipes());
        NeoForge.EVENT_BUS.post((Event)new RecipesReceivedEvent(payload.recipeTypes(), recipeMap));
    }
}

