/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.extensions;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AdventureModePredicate;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.FuelValues;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.ItemCapability;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.Nullable;

public interface IItemStackExtension {
    private ItemStack self() {
        return (ItemStack)this;
    }

    default public ItemStack getCraftingRemainder() {
        return this.self().getItem().getCraftingRemainder(this.self());
    }

    default public int getBurnTime(@Nullable RecipeType<?> recipeType, FuelValues fuelValues) {
        if (this.self().isEmpty()) {
            return 0;
        }
        int burnTime = this.self().getItem().getBurnTime(this.self(), recipeType, fuelValues);
        if (burnTime < 0) {
            throw new IllegalStateException("Stack of item " + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)this.self().getItem())) + " has a negative burn time");
        }
        return EventHooks.getItemBurnTime(this.self(), burnTime, recipeType, fuelValues);
    }

    default public InteractionResult onItemUseFirst(UseOnContext context) {
        Player entityplayer = context.getPlayer();
        BlockPos blockpos = context.getClickedPos();
        BlockInWorld blockworldstate = new BlockInWorld((LevelReader)context.getLevel(), blockpos, false);
        AdventureModePredicate adventureModePredicate = (AdventureModePredicate)this.self().get(DataComponents.CAN_PLACE_ON);
        if (!(entityplayer == null || entityplayer.getAbilities().mayBuild || adventureModePredicate != null && adventureModePredicate.test(blockworldstate))) {
            return InteractionResult.PASS;
        }
        Item item = this.self().getItem();
        InteractionResult enumactionresult = item.onItemUseFirst(this.self(), context);
        if (entityplayer != null && enumactionresult == InteractionResult.SUCCESS) {
            entityplayer.awardStat(Stats.ITEM_USED.get((Object)item));
        }
        return enumactionresult;
    }

    default public boolean canPerformAction(ItemAbility itemAbility) {
        return this.self().getItem().canPerformAction(this.self(), itemAbility);
    }

    default public boolean shouldCauseBlockBreakReset(ItemStack newStack) {
        return this.self().getItem().shouldCauseBlockBreakReset(this.self(), newStack);
    }

    default public boolean isPrimaryItemFor(Holder<Enchantment> enchantment) {
        return this.self().getItem().isPrimaryItemFor(this.self(), enchantment);
    }

    default public boolean supportsEnchantment(Holder<Enchantment> enchantment) {
        return this.self().getItem().supportsEnchantment(this.self(), enchantment);
    }

    default public int getEnchantmentLevel(Holder<Enchantment> enchantment) {
        int level = this.self().getItem().getEnchantmentLevel(this.self(), enchantment);
        return EventHooks.getEnchantmentLevelSpecific(level, this.self(), enchantment);
    }

    default public ItemEnchantments getAllEnchantments(HolderLookup.RegistryLookup<Enchantment> lookup) {
        ItemEnchantments enchantments = this.self().getItem().getAllEnchantments(this.self(), lookup);
        return EventHooks.getAllEnchantmentLevels(enchantments, this.self(), lookup);
    }

    @Nullable
    default public EquipmentSlot getEquipmentSlot() {
        return this.self().getItem().getEquipmentSlot(this.self());
    }

    default public boolean onEntitySwing(LivingEntity entity, InteractionHand hand) {
        return this.self().getItem().onEntitySwing(this.self(), entity, hand);
    }

    default public void onStopUsing(LivingEntity entity, int count) {
        this.self().getItem().onStopUsing(this.self(), entity, count);
    }

    default public int getEntityLifespan(Level level) {
        return this.self().getItem().getEntityLifespan(this.self(), level);
    }

    default public boolean onEntityItemUpdate(ItemEntity entity) {
        return this.self().getItem().onEntityItemUpdate(this.self(), entity);
    }

    default public float getXpRepairRatio() {
        return this.self().getItem().getXpRepairRatio(this.self());
    }

    default public void onAnimalArmorTick(Level level, Mob horse) {
        this.self().getItem().onAnimalArmorTick(this.self(), level, horse);
    }

    default public boolean canEquip(EquipmentSlot armorType, LivingEntity entity) {
        return this.self().getItem().canEquip(this.self(), armorType, entity);
    }

    default public boolean onDroppedByPlayer(Player player) {
        return this.self().getItem().onDroppedByPlayer(this.self(), player);
    }

    default public Component getHighlightTip(Component displayName) {
        return this.self().getItem().getHighlightTip(this.self(), displayName);
    }

    default public boolean doesSneakBypassUse(LevelReader level, BlockPos pos, Player player) {
        return this.self().isEmpty() || this.self().getItem().doesSneakBypassUse(this.self(), level, pos, player);
    }

    default public boolean isCombineRepairable() {
        return this.self().getItem().isCombineRepairable(this.self());
    }

    default public boolean isPiglinCurrency() {
        return this.self().getItem().isPiglinCurrency(this.self());
    }

    default public boolean makesPiglinsNeutral(LivingEntity wearer) {
        return this.self().getItem().makesPiglinsNeutral(this.self(), wearer);
    }

    default public boolean isGazeDisguise(Player player, @Nullable LivingEntity entity) {
        return this.self().getItem().isGazeDisguise(this.self(), player, entity);
    }

    default public boolean canWalkOnPowderedSnow(LivingEntity wearer) {
        return this.self().getItem().canWalkOnPowderedSnow(this.self(), wearer);
    }

    default public AABB getSweepHitBox(Player player, Entity target) {
        return this.self().getItem().getSweepHitBox(this.self(), player, target);
    }

    default public void onDestroyed(ItemEntity itemEntity, DamageSource damageSource) {
        this.self().getItem().onDestroyed(itemEntity, damageSource);
    }

    default public boolean isNotReplaceableByPickAction(Player player, int inventorySlot) {
        return this.self().getItem().isNotReplaceableByPickAction(this.self(), player, inventorySlot);
    }

    default public boolean canGrindstoneRepair() {
        return this.self().getItem().canGrindstoneRepair(this.self());
    }

    @Nullable
    default public <T, C> T getCapability(ItemCapability<T, C> capability, C context) {
        return capability.getCapability(this.self(), context);
    }

    @Nullable
    default public <T> T getCapability(ItemCapability<T, @Nullable Void> capability) {
        return capability.getCapability(this.self(), null);
    }

    default public ItemAttributeModifiers getAttributeModifiers() {
        ItemAttributeModifiers defaultModifiers = (ItemAttributeModifiers)this.self().getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY);
        if (defaultModifiers.modifiers().isEmpty()) {
            defaultModifiers = this.self().getItem().getDefaultAttributeModifiers(this.self());
        }
        return CommonHooks.computeModifiedAttributes(this.self(), defaultModifiers);
    }
}

