/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.util;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.TooltipDisplay;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.extensions.IHolderExtension;
import net.neoforged.neoforge.common.util.AttributeTooltipContext;
import net.neoforged.neoforge.event.AddAttributeTooltipsEvent;
import net.neoforged.neoforge.event.GatherSkippedAttributeTooltipsEvent;
import net.neoforged.neoforge.internal.NeoForgeProxy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AttributeUtil {
    public static final ResourceLocation BASE_ATTACK_DAMAGE_ID = Item.BASE_ATTACK_DAMAGE_ID;
    public static final ResourceLocation BASE_ATTACK_SPEED_ID = Item.BASE_ATTACK_SPEED_ID;
    public static final ResourceLocation BASE_ENTITY_REACH_ID = ResourceLocation.withDefaultNamespace((String)"base_entity_reach");
    public static final ResourceLocation FAKE_MERGED_ID = ResourceLocation.fromNamespaceAndPath((String)"neoforge", (String)"fake_merged_modifier");
    public static final Comparator<AttributeModifier> ATTRIBUTE_MODIFIER_COMPARATOR = Comparator.comparing(AttributeModifier::operation).thenComparingDouble(a -> -Math.abs(a.amount())).thenComparing(AttributeModifier::id);
    private static final Logger LOGGER = LogManager.getLogger();

    public static void addAttributeTooltips(ItemStack stack, Consumer<Component> tooltip, TooltipDisplay tooltipDisplay, AttributeTooltipContext ctx) {
        if (tooltipDisplay.shows(DataComponents.ATTRIBUTE_MODIFIERS)) {
            AttributeUtil.applyModifierTooltips(stack, tooltip, ctx);
        }
        NeoForge.EVENT_BUS.post((Event)new AddAttributeTooltipsEvent(stack, tooltip, ctx));
    }

    public static void applyModifierTooltips(ItemStack stack, Consumer<Component> tooltip, AttributeTooltipContext ctx) {
        GatherSkippedAttributeTooltipsEvent event = (GatherSkippedAttributeTooltipsEvent)NeoForge.EVENT_BUS.post((Event)new GatherSkippedAttributeTooltipsEvent(stack, ctx));
        if (event.isSkippingAll()) {
            return;
        }
        for (EquipmentSlotGroup group : EquipmentSlotGroup.values()) {
            if (event.isSkipped(group)) continue;
            Multimap<Holder<Attribute>, AttributeModifier> modifiers = AttributeUtil.getSortedModifiers(stack, group);
            modifiers.values().removeIf(m -> event.isSkipped(m.id()));
            if (modifiers.isEmpty()) continue;
            tooltip.accept((Component)Component.empty());
            tooltip.accept((Component)Component.translatable((String)("item.modifiers." + group.getSerializedName())).withStyle(ChatFormatting.GRAY));
            AttributeUtil.applyTextFor(stack, tooltip, modifiers, ctx);
        }
    }

    public static void applyTextFor(ItemStack stack, Consumer<Component> tooltip, Multimap<Holder<Attribute>, AttributeModifier> modifierMap, AttributeTooltipContext ctx) {
        if (modifierMap.isEmpty()) {
            return;
        }
        Reference2ReferenceLinkedOpenHashMap baseModifs = new Reference2ReferenceLinkedOpenHashMap();
        Iterator it = modifierMap.entries().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            Holder holder = (Holder)entry.getKey();
            AttributeModifier modif2 = (AttributeModifier)entry.getValue();
            if (!modif2.id().equals((Object)((Attribute)holder.value()).getBaseId())) continue;
            baseModifs.put(holder, new BaseModifier(modif2, new ArrayList<AttributeModifier>()));
            it.remove();
        }
        for (Map.Entry entry : modifierMap.entries()) {
            BaseModifier base = (BaseModifier)baseModifs.get(entry.getKey());
            if (base == null) continue;
            base.children.add((AttributeModifier)entry.getValue());
        }
        for (Map.Entry entry : baseModifs.entrySet()) {
            double base;
            Holder attr = (Holder)entry.getKey();
            BaseModifier baseModif = (BaseModifier)entry.getValue();
            double entityBase = ctx.player() == null ? 0.0 : ctx.player().getAttributeBaseValue(attr);
            double rawBase = base = baseModif.base.amount() + entityBase;
            double amt = base;
            if (NeoForgeMod.shouldMergeAttributeTooltips()) {
                for (AttributeModifier modif3 : baseModif.children) {
                    switch (modif3.operation()) {
                        case ADD_VALUE: {
                            base = amt += modif3.amount();
                            break;
                        }
                        case ADD_MULTIPLIED_BASE: {
                            amt += modif3.amount() * base;
                            break;
                        }
                        case ADD_MULTIPLIED_TOTAL: {
                            amt *= 1.0 + modif3.amount();
                        }
                    }
                }
            }
            boolean isMerged = NeoForgeMod.shouldMergeAttributeTooltips() && !baseModif.children.isEmpty();
            MutableComponent text = ((Attribute)attr.value()).toBaseComponent(amt, entityBase, isMerged, ctx.flag());
            tooltip.accept((Component)Component.literal((String)" ").append((Component)text).withStyle(isMerged ? ChatFormatting.GOLD : ChatFormatting.DARK_GREEN));
            if (!ctx.flag().hasShiftDown() || !isMerged) continue;
            text = ((Attribute)attr.value()).toBaseComponent(rawBase, entityBase, false, ctx.flag());
            tooltip.accept((Component)AttributeUtil.listHeader().append((Component)text.withStyle(ChatFormatting.DARK_GREEN)));
            for (AttributeModifier modifier : baseModif.children) {
                tooltip.accept((Component)AttributeUtil.listHeader().append((Component)((Attribute)attr.value()).toComponent(modifier, ctx.flag())));
            }
        }
        for (Holder holder : modifierMap.keySet()) {
            if (NeoForgeMod.shouldMergeAttributeTooltips() && baseModifs.containsKey(holder)) continue;
            Collection modifs = modifierMap.get((Object)holder);
            if (NeoForgeMod.shouldMergeAttributeTooltips() && modifs.size() > 1) {
                EnumMap<AttributeModifier.Operation, MergedModifierData> mergeData = new EnumMap<AttributeModifier.Operation, MergedModifierData>(AttributeModifier.Operation.class);
                for (AttributeModifier modifier : modifs) {
                    if (modifier.amount() == 0.0) continue;
                    MergedModifierData data = mergeData.computeIfAbsent(modifier.operation(), op -> new MergedModifierData());
                    if (data.sum != 0.0) {
                        data.isMerged = true;
                    }
                    data.sum += modifier.amount();
                    data.children.add(modifier);
                }
                for (AttributeModifier.Operation op2 : AttributeModifier.Operation.values()) {
                    MergedModifierData data = (MergedModifierData)mergeData.get(op2);
                    if (data == null || data.sum == 0.0) continue;
                    if (data.isMerged) {
                        TextColor color = ((Attribute)holder.value()).getMergedStyle(data.sum > 0.0);
                        AttributeModifier fakeModif = new AttributeModifier(FAKE_MERGED_ID, data.sum, op2);
                        MutableComponent comp = ((Attribute)holder.value()).toComponent(fakeModif, ctx.flag());
                        tooltip.accept((Component)comp.withStyle(comp.getStyle().withColor(color)));
                        if (!ctx.flag().hasShiftDown()) continue;
                        data.children.forEach(modif -> tooltip.accept((Component)AttributeUtil.listHeader().append((Component)((Attribute)attr.value()).toComponent(modif, ctx.flag()))));
                        continue;
                    }
                    AttributeModifier fakeModif = new AttributeModifier(FAKE_MERGED_ID, data.sum, op2);
                    tooltip.accept((Component)((Attribute)holder.value()).toComponent(fakeModif, ctx.flag()));
                }
                continue;
            }
            for (AttributeModifier m : modifs) {
                if (m.amount() == 0.0) continue;
                tooltip.accept((Component)((Attribute)holder.value()).toComponent(m, ctx.flag()));
            }
        }
    }

    public static void addPotionTooltip(List<Pair<Holder<Attribute>, AttributeModifier>> list, Consumer<Component> tooltips) {
        for (Pair<Holder<Attribute>, AttributeModifier> pair : list) {
            tooltips.accept((Component)((Attribute)((Holder)pair.getFirst()).value()).toComponent((AttributeModifier)pair.getSecond(), NeoForgeProxy.INSTANCE.getTooltipFlag()));
        }
    }

    public static Multimap<Holder<Attribute>, AttributeModifier> sortedMap() {
        return TreeMultimap.create(Comparator.comparing(IHolderExtension::getKey), ATTRIBUTE_MODIFIER_COMPARATOR);
    }

    public static Multimap<Holder<Attribute>, AttributeModifier> getSortedModifiers(ItemStack stack, EquipmentSlotGroup slot) {
        LinkedListMultimap map = LinkedListMultimap.create();
        stack.forEachModifier(slot, (arg_0, arg_1) -> AttributeUtil.lambda$getSortedModifiers$4((Multimap)map, stack, arg_0, arg_1));
        return map;
    }

    private static MutableComponent listHeader() {
        return Component.literal((String)" \u2507 ").withStyle(ChatFormatting.GRAY);
    }

    private static /* synthetic */ void lambda$getSortedModifiers$4(Multimap map, ItemStack stack, Holder attr, AttributeModifier modif) {
        if (attr != null && modif != null) {
            map.put((Object)attr, (Object)modif);
        } else {
            LOGGER.debug("Detected broken attribute modifier entry on item {}.  Attr={}, Modif={}", (Object)stack, (Object)attr, (Object)modif);
        }
    }

    private record BaseModifier(AttributeModifier base, List<AttributeModifier> children) {
    }

    private static class MergedModifierData {
        double sum = 0.0;
        boolean isMerged = false;
        private List<AttributeModifier> children = new LinkedList<AttributeModifier>();

        private MergedModifierData() {
        }
    }
}

