/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.event;

import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ReloadableServerResources;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.event.SortedReloadListenerEvent;
import net.neoforged.neoforge.resource.VanillaServerListeners;
import org.jetbrains.annotations.ApiStatus;

public class AddServerReloadListenersEvent
extends SortedReloadListenerEvent {
    private final ReloadableServerResources serverResources;
    private final RegistryAccess registryAccess;

    @ApiStatus.Internal
    public AddServerReloadListenersEvent(ReloadableServerResources serverResources, RegistryAccess registryAccess) {
        super(serverResources.listeners(), AddServerReloadListenersEvent::lookupName);
        this.serverResources = serverResources;
        this.registryAccess = registryAccess;
    }

    public ReloadableServerResources getServerResources() {
        return this.serverResources;
    }

    public ICondition.IContext getConditionContext() {
        return this.serverResources.getConditionContext();
    }

    public RegistryAccess getRegistryAccess() {
        return this.registryAccess;
    }

    private static ResourceLocation lookupName(PreparableReloadListener listener) {
        ResourceLocation key = VanillaServerListeners.getNameForClass(listener.getClass());
        if (key == null) {
            if (listener.getClass().getPackageName().startsWith("net.minecraft")) {
                throw new IllegalArgumentException("A key for the reload listener " + String.valueOf(listener) + " was not provided in VanillaServerListeners!");
            }
            throw new IllegalArgumentException("A non-vanilla reload listener " + String.valueOf(listener) + " was added via mixin before the AddReloadListenerEvent! Mod-added listeners must go through the event.");
        }
        return key;
    }
}

