/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.network;

import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.configuration.ServerConfigurationPacketListener;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.config.ConfigTracker;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.config.ModConfigs;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.payload.ConfigFilePayload;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class ConfigSync {
    private static final Object lock = new Object();
    private static final Map<Connection, Map<String, byte[]>> configsToSync = new WeakHashMap<Connection, Map<String, byte[]>>();

    private ConfigSync() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void syncAllConfigs(ServerConfigurationPacketListener listener) {
        Connection connection = listener.getConnection();
        if (connection.isMemoryConnection()) {
            return;
        }
        Object object = lock;
        synchronized (object) {
            configsToSync.put(connection, new LinkedHashMap());
        }
        Map<String, byte[]> configData = ModConfigs.getConfigSet((ModConfig.Type)ModConfig.Type.SERVER).stream().collect(Collectors.toMap(ModConfig::getFileName, mc -> {
            try {
                return Files.readAllBytes(mc.getFullPath());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }));
        for (Map.Entry<String, byte[]> entry : configData.entrySet()) {
            listener.send((CustomPacketPayload)new ConfigFilePayload(entry.getKey(), entry.getValue()));
        }
    }

    public static void registerEventListeners() {
        for (ModContainer modContainer : ModList.get().getSortedMods()) {
            IEventBus modBus = modContainer.getEventBus();
            if (modBus == null) continue;
            modBus.addListener(ModConfigEvent.Reloading.class, event -> {
                ModConfig config = event.getConfig();
                if (config.getType() != ModConfig.Type.SERVER) {
                    return;
                }
                IConfigSpec.ILoadedConfig loadedConfig = config.getLoadedConfig();
                if (loadedConfig == null) {
                    return;
                }
                ConfigFormat configFormat = loadedConfig.config().configFormat();
                if (configFormat.isInMemory()) {
                    return;
                }
                byte[] bytes = configFormat.createWriter().writeToString((UnmodifiableConfig)loadedConfig.config()).getBytes(StandardCharsets.UTF_8);
                Object object = lock;
                synchronized (object) {
                    for (Map<String, byte[]> toSync : configsToSync.values()) {
                        toSync.put(config.getFileName(), bytes);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void syncPendingConfigs(MinecraftServer server) {
        Object object = lock;
        synchronized (object) {
            for (ServerPlayer player : server.getPlayerList().getPlayers()) {
                if (!player.connection.hasChannel(ConfigFilePayload.TYPE) || player.connection.getConnection().isMemoryConnection()) continue;
                Map<String, byte[]> toSync = configsToSync.get(player.connection.getConnection());
                if (toSync == null) {
                    if (player.getClass() != ServerPlayer.class) continue;
                    throw new IllegalStateException("configsToSync should contain an entry for player " + String.valueOf(player.getName()));
                }
                toSync.forEach((fileName, data) -> PacketDistributor.sendToPlayer(player, new ConfigFilePayload((String)fileName, (byte[])data), new CustomPacketPayload[0]));
                toSync.clear();
            }
        }
    }

    public static void receiveSyncedConfig(byte[] contents, String fileName) {
        Optional.ofNullable((ModConfig)ModConfigs.getFileMap().get(fileName)).ifPresent(mc -> ConfigTracker.acceptSyncedConfig((ModConfig)mc, (byte[])contents));
    }
}

