/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.network.registration;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.negotiation.NegotiationResult;
import net.neoforged.neoforge.network.registration.NetworkChannel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public record NetworkPayloadSetup(Map<ConnectionProtocol, Map<ResourceLocation, NetworkChannel>> channels) {
    public static StreamCodec<FriendlyByteBuf, NetworkPayloadSetup> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.map(IdentityHashMap::new, (StreamCodec)ByteBufCodecs.idMapper(b -> ConnectionProtocol.values()[b], Enum::ordinal), (StreamCodec)ByteBufCodecs.map(HashMap::new, (StreamCodec)ResourceLocation.STREAM_CODEC, NetworkChannel.STREAM_CODEC)), NetworkPayloadSetup::channels, NetworkPayloadSetup::new);

    public Map<ResourceLocation, NetworkChannel> getChannels(ConnectionProtocol protocol) {
        return this.channels().getOrDefault(protocol, Collections.emptyMap());
    }

    @Nullable
    public NetworkChannel getChannel(ConnectionProtocol protocol, ResourceLocation id) {
        return this.getChannels(protocol).get(id);
    }

    public static NetworkPayloadSetup empty() {
        return new NetworkPayloadSetup(Collections.emptyMap());
    }

    public static NetworkPayloadSetup from(Map<ConnectionProtocol, NegotiationResult> results) {
        ImmutableMap.Builder channels = ImmutableMap.builder();
        for (Map.Entry<ConnectionProtocol, NegotiationResult> result : results.entrySet()) {
            ImmutableMap.Builder protocolChannels = ImmutableMap.builder();
            result.getValue().components().forEach(component -> protocolChannels.put((Object)component.id(), (Object)new NetworkChannel(component.id(), component.version())));
            channels.put((Object)result.getKey(), (Object)protocolChannels.build());
        }
        return new NetworkPayloadSetup((Map<ConnectionProtocol, Map<ResourceLocation, NetworkChannel>>)channels.build());
    }
}

