/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.registries;

import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.IdMapper;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.DebugLevelSource;
import net.neoforged.neoforge.registries.callback.AddCallback;
import net.neoforged.neoforge.registries.callback.BakeCallback;
import net.neoforged.neoforge.registries.callback.ClearCallback;

class NeoForgeRegistryCallbacks {
    NeoForgeRegistryCallbacks() {
    }

    static class PoiTypeCallbacks
    implements AddCallback<PoiType>,
    ClearCallback<PoiType> {
        static final PoiTypeCallbacks INSTANCE = new PoiTypeCallbacks();
        static final Map<BlockState, Holder<PoiType>> BLOCKSTATE_TO_POI_TYPE_MAP = new HashMap<BlockState, Holder<PoiType>>();

        PoiTypeCallbacks() {
        }

        @Override
        public void onAdd(Registry<PoiType> registry, int id, ResourceKey<PoiType> key, PoiType value) {
            value.matchingStates().forEach(state -> {
                Holder<PoiType> oldType = BLOCKSTATE_TO_POI_TYPE_MAP.put((BlockState)state, (Holder<PoiType>)registry.getOrThrow(key));
                if (oldType != null) {
                    throw new IllegalStateException(String.format(Locale.ENGLISH, "Point of interest types %s and %s both list %s in their blockstates, this is not allowed. Blockstates can only have one point of interest type each.", oldType, value, state));
                }
            });
        }

        @Override
        public void onClear(Registry<PoiType> registry, boolean full) {
            if (full) {
                BLOCKSTATE_TO_POI_TYPE_MAP.clear();
            }
        }
    }

    static class AttributeCallbacks
    implements BakeCallback<Attribute> {
        static final AttributeCallbacks INSTANCE = new AttributeCallbacks();

        AttributeCallbacks() {
        }

        @Override
        public void onBake(Registry<Attribute> registry) {
            DefaultAttributes.validate();
        }
    }

    static class ItemCallbacks
    implements AddCallback<Item>,
    ClearCallback<Item> {
        static final ItemCallbacks INSTANCE = new ItemCallbacks();
        static final Map<Block, Item> BLOCK_TO_ITEM_MAP = new HashMap<Block, Item>();

        ItemCallbacks() {
        }

        @Override
        public void onAdd(Registry<Item> registry, int id, ResourceKey<Item> key, Item item) {
            if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                blockItem.registerBlocks(BLOCK_TO_ITEM_MAP, item);
            }
        }

        @Override
        public void onClear(Registry<Item> registry, boolean full) {
            if (full) {
                BLOCK_TO_ITEM_MAP.clear();
            }
        }
    }

    static class BlockCallbacks
    implements AddCallback<Block>,
    ClearCallback<Block>,
    BakeCallback<Block> {
        static final BlockCallbacks INSTANCE = new BlockCallbacks();
        static final ClearableObjectIntIdentityMap<BlockState> BLOCKSTATE_TO_ID_MAP = new ClearableObjectIntIdentityMap();
        private final Set<Block> addedBlocks = new ReferenceOpenHashSet();

        BlockCallbacks() {
        }

        @Override
        public void onAdd(Registry<Block> registry, int id, ResourceKey<Block> key, Block value) {
            this.addedBlocks.add(value);
        }

        @Override
        public void onClear(Registry<Block> registry, boolean full) {
            BLOCKSTATE_TO_ID_MAP.clear();
        }

        @Override
        public void onBake(Registry<Block> registry) {
            for (Block block : this.addedBlocks) {
                block.getStateDefinition().getPossibleStates().forEach(BlockBehaviour.BlockStateBase::initCache);
            }
            this.addedBlocks.clear();
            for (Block block : registry) {
                for (BlockState state : block.getStateDefinition().getPossibleStates()) {
                    BLOCKSTATE_TO_ID_MAP.add(state);
                }
            }
            DebugLevelSource.initValidStates();
        }

        private static class ClearableObjectIntIdentityMap<T>
        extends IdMapper<T> {
            private ClearableObjectIntIdentityMap() {
            }

            void clear() {
                this.tToId.clear();
                this.idToT.clear();
                this.nextId = 0;
            }
        }
    }
}

