/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.resource;

import com.google.common.graph.Graph;
import com.google.common.graph.Graphs;
import com.google.common.graph.MutableGraph;
import com.google.common.graph.SuccessorsFunction;
import com.google.common.graph.Traverser;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.neoforged.fml.loading.toposort.CyclePresentException;
import net.neoforged.fml.loading.toposort.TopologicalSort;
import net.neoforged.neoforge.event.SortedReloadListenerEvent;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ReloadListenerSort {
    public static List<PreparableReloadListener> sort(SortedReloadListenerEvent event) {
        return ReloadListenerSort.sortListeners(event.getNameLookup(), (MutableGraph<PreparableReloadListener>)((MutableGraph)event.getGraph()), event.getRegistry(), event.getLastVanillaListener());
    }

    public static List<PreparableReloadListener> sortListeners(SortedReloadListenerEvent.NameLookup lookup, MutableGraph<PreparableReloadListener> graph, Map<ResourceLocation, PreparableReloadListener> registry, PreparableReloadListener lastVanilla) {
        for (Map.Entry<ResourceLocation, PreparableReloadListener> entry : registry.entrySet()) {
            if (!ReloadListenerSort.needsToBeLinkedToVanilla(lookup, graph, entry.getValue())) continue;
            graph.putEdge((Object)lastVanilla, (Object)entry.getValue());
        }
        Object2IntOpenHashMap insertionOrder = new Object2IntOpenHashMap();
        int idx = 0;
        for (PreparableReloadListener listener : registry.values()) {
            insertionOrder.put((Object)listener, idx++);
        }
        try {
            List sorted = TopologicalSort.topologicalSort(graph, Comparator.comparingInt(arg_0 -> ((Object2IntMap)insertionOrder).getInt(arg_0)));
            return Collections.unmodifiableList(sorted);
        }
        catch (CyclePresentException ex) {
            Set cycles = ex.getCycles();
            Set keyedCycles = cycles.stream().map(set -> set.stream().map(lookup::apply).collect(Collectors.toCollection(LinkedHashSet::new))).collect(Collectors.toSet());
            StringBuilder sb = new StringBuilder();
            sb.append("Cycles were detected during reload listener sorting:").append('\n');
            idx = 0;
            for (Set cycle : keyedCycles) {
                StringBuilder msg = new StringBuilder();
                msg.append(idx++).append(": ");
                for (ResourceLocation key : cycle) {
                    msg.append(key).append("->");
                }
                msg.append(cycle.iterator().next());
                sb.append((CharSequence)msg);
                sb.append('\n');
            }
            throw new IllegalArgumentException(sb.toString());
        }
    }

    private static boolean needsToBeLinkedToVanilla(SortedReloadListenerEvent.NameLookup lookup, Graph<PreparableReloadListener> graph, PreparableReloadListener listener) {
        if (ReloadListenerSort.isVanilla(lookup, listener)) {
            return false;
        }
        for (PreparableReloadListener node : Traverser.forGraph(graph).depthFirstPreOrder((Object)listener)) {
            if (!ReloadListenerSort.isVanilla(lookup, node)) continue;
            return false;
        }
        for (PreparableReloadListener node : Traverser.forGraph((SuccessorsFunction)Graphs.transpose(graph)).depthFirstPreOrder((Object)listener)) {
            if (!ReloadListenerSort.isVanilla(lookup, node)) continue;
            return false;
        }
        return true;
    }

    private static boolean isVanilla(SortedReloadListenerEvent.NameLookup lookup, PreparableReloadListener listener) {
        return "minecraft".equals(lookup.apply(listener).getNamespace());
    }
}

