/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.blocks;

import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockInput
implements Predicate<BlockInWorld> {
    private final BlockState state;
    private final Set<Property<?>> properties;
    @Nullable
    private final CompoundTag tag;

    public BlockInput(BlockState p_114666_, Set<Property<?>> p_114667_, @Nullable CompoundTag p_114668_) {
        this.state = p_114666_;
        this.properties = p_114667_;
        this.tag = p_114668_;
    }

    public BlockState getState() {
        return this.state;
    }

    public Set<Property<?>> getDefinedProperties() {
        return this.properties;
    }

    @Override
    public boolean test(BlockInWorld p_114675_) {
        BlockState $$1 = p_114675_.getState();
        if (!$$1.is(this.state.getBlock())) {
            return false;
        }
        for (Property<?> $$2 : this.properties) {
            if ($$1.getValue($$2) == this.state.getValue($$2)) continue;
            return false;
        }
        if (this.tag != null) {
            BlockEntity $$3 = p_114675_.getEntity();
            return $$3 != null && NbtUtils.compareNbt(this.tag, $$3.saveWithFullMetadata(p_114675_.getLevel().registryAccess()), true);
        }
        return true;
    }

    public boolean test(ServerLevel p_173524_, BlockPos p_173525_) {
        return this.test(new BlockInWorld(p_173524_, p_173525_, false));
    }

    public boolean place(ServerLevel p_114671_, BlockPos p_114672_, int p_114673_) {
        BlockEntity $$5;
        BlockState $$3;
        BlockState blockState = $$3 = (p_114673_ & 0x10) != 0 ? this.state : Block.updateFromNeighbourShapes(this.state, p_114671_, p_114672_);
        if ($$3.isAir()) {
            $$3 = this.state;
        }
        $$3 = this.overwriteWithDefinedProperties($$3);
        boolean $$4 = false;
        if (p_114671_.setBlock(p_114672_, $$3, p_114673_)) {
            $$4 = true;
        }
        if (this.tag != null && ($$5 = p_114671_.getBlockEntity(p_114672_)) != null) {
            CompoundTag $$6 = $$5.saveWithoutMetadata(p_114671_.registryAccess());
            $$5.loadWithComponents(this.tag, p_114671_.registryAccess());
            CompoundTag $$7 = $$5.saveWithoutMetadata(p_114671_.registryAccess());
            if (!$$7.equals($$6)) {
                $$4 = true;
                $$5.setChanged();
                p_114671_.getChunkSource().blockChanged(p_114672_);
            }
        }
        return $$4;
    }

    private BlockState overwriteWithDefinedProperties(BlockState p_383160_) {
        if (p_383160_ == this.state) {
            return p_383160_;
        }
        for (Property<?> $$1 : this.properties) {
            p_383160_ = BlockInput.copyProperty(p_383160_, this.state, $$1);
        }
        return p_383160_;
    }

    private static <T extends Comparable<T>> BlockState copyProperty(BlockState p_382881_, BlockState p_382920_, Property<T> p_382944_) {
        return (BlockState)p_382881_.trySetValue(p_382944_, p_382920_.getValue(p_382944_));
    }

    @Override
    public /* synthetic */ boolean test(Object object) {
        return this.test((BlockInWorld)object);
    }
}

