/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.item;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Unit;
import net.minecraft.util.parsing.packrat.Atom;
import net.minecraft.util.parsing.packrat.Dictionary;
import net.minecraft.util.parsing.packrat.NamedRule;
import net.minecraft.util.parsing.packrat.Scope;
import net.minecraft.util.parsing.packrat.Term;
import net.minecraft.util.parsing.packrat.commands.Grammar;
import net.minecraft.util.parsing.packrat.commands.ResourceLocationParseRule;
import net.minecraft.util.parsing.packrat.commands.ResourceLookupRule;
import net.minecraft.util.parsing.packrat.commands.StringReaderTerms;
import net.minecraft.util.parsing.packrat.commands.TagParseRule;

public class ComponentPredicateParser {
    public static <T, C, P> Grammar<List<T>> createGrammar(Context<T, C, P> p_335727_) {
        Atom $$1 = Atom.of("top");
        Atom $$2 = Atom.of("type");
        Atom $$3 = Atom.of("any_type");
        Atom $$4 = Atom.of("element_type");
        Atom $$5 = Atom.of("tag_type");
        Atom $$6 = Atom.of("conditions");
        Atom $$7 = Atom.of("alternatives");
        Atom $$8 = Atom.of("term");
        Atom $$9 = Atom.of("negation");
        Atom $$10 = Atom.of("test");
        Atom $$11 = Atom.of("component_type");
        Atom $$12 = Atom.of("predicate_type");
        Atom $$13 = Atom.of("id");
        Atom $$14 = Atom.of("tag");
        Dictionary<StringReader> $$15 = new Dictionary<StringReader>();
        NamedRule<StringReader, ResourceLocation> $$16 = $$15.put($$13, ResourceLocationParseRule.INSTANCE);
        NamedRule $$17 = $$15.put($$1, Term.alternative(Term.sequence($$15.named($$2), StringReaderTerms.character('['), Term.cut(), Term.optional($$15.named($$6)), StringReaderTerms.character(']')), $$15.named($$2)), p_336103_ -> {
            ImmutableList.Builder $$3 = ImmutableList.builder();
            ((Optional)p_336103_.getOrThrow($$2)).ifPresent(arg_0 -> ((ImmutableList.Builder)$$3).add(arg_0));
            List $$4 = (List)p_336103_.get($$6);
            if ($$4 != null) {
                $$3.addAll((Iterable)$$4);
            }
            return $$3.build();
        });
        $$15.put($$2, Term.alternative($$15.named($$4), Term.sequence(StringReaderTerms.character('#'), Term.cut(), $$15.named($$5)), $$15.named($$3)), p_335800_ -> Optional.ofNullable(p_335800_.getAny($$4, $$5)));
        $$15.put($$3, StringReaderTerms.character('*'), p_335962_ -> Unit.INSTANCE);
        $$15.put($$4, new ElementLookupRule<T, C, P>($$16, p_335727_));
        $$15.put($$5, new TagLookupRule<T, C, P>($$16, p_335727_));
        $$15.put($$6, Term.sequence($$15.named($$7), Term.optional(Term.sequence(StringReaderTerms.character(','), $$15.named($$6)))), p_336093_ -> {
            Object $$4 = p_335727_.anyOf((List)p_336093_.getOrThrow($$7));
            return Optional.ofNullable((List)p_336093_.get($$6)).map(p_335806_ -> Util.copyAndAdd($$4, p_335806_)).orElse(List.of($$4));
        });
        $$15.put($$7, Term.sequence($$15.named($$8), Term.optional(Term.sequence(StringReaderTerms.character('|'), $$15.named($$7)))), p_335542_ -> {
            Object $$3 = p_335542_.getOrThrow($$8);
            return Optional.ofNullable((List)p_335542_.get($$7)).map(p_335939_ -> Util.copyAndAdd($$3, p_335939_)).orElse(List.of($$3));
        });
        $$15.put($$8, Term.alternative($$15.named($$10), Term.sequence(StringReaderTerms.character('!'), $$15.named($$9))), p_335647_ -> p_335647_.getAnyOrThrow($$10, $$9));
        $$15.put($$9, $$15.named($$10), p_335793_ -> p_335727_.negate(p_335793_.getOrThrow($$10)));
        $$15.putComplex($$10, Term.alternative(Term.sequence($$15.named($$11), StringReaderTerms.character('='), Term.cut(), $$15.named($$14)), Term.sequence($$15.named($$12), StringReaderTerms.character('~'), Term.cut(), $$15.named($$14)), $$15.named($$11)), p_409120_ -> {
            Scope $$5 = p_409120_.scope();
            Object $$6 = $$5.get($$12);
            try {
                if ($$6 != null) {
                    Dynamic $$7 = (Dynamic)$$5.getOrThrow($$14);
                    return p_335727_.createPredicateTest((ImmutableStringReader)p_409120_.input(), $$6, $$7);
                }
                Object $$8 = $$5.getOrThrow($$11);
                Dynamic $$9 = (Dynamic)$$5.get($$14);
                return $$9 != null ? p_335727_.createComponentTest((ImmutableStringReader)p_409120_.input(), $$8, $$9) : p_335727_.createComponentTest((ImmutableStringReader)p_409120_.input(), $$8);
            }
            catch (CommandSyntaxException $$10) {
                p_409120_.errorCollector().store(p_409120_.mark(), (Object)$$10);
                return null;
            }
        });
        $$15.put($$11, new ComponentLookupRule<T, C, P>($$16, p_335727_));
        $$15.put($$12, new PredicateLookupRule<T, C, P>($$16, p_335727_));
        $$15.put($$14, new TagParseRule<Tag>(NbtOps.INSTANCE));
        return new Grammar<List<T>>($$15, $$17);
    }

    static class ElementLookupRule<T, C, P>
    extends ResourceLookupRule<Context<T, C, P>, T> {
        ElementLookupRule(NamedRule<StringReader, ResourceLocation> p_409673_, Context<T, C, P> p_335797_) {
            super(p_409673_, p_335797_);
        }

        @Override
        protected T validateElement(ImmutableStringReader p_335629_, ResourceLocation p_335530_) throws Exception {
            return ((Context)this.context).forElementType(p_335629_, p_335530_);
        }

        @Override
        public Stream<ResourceLocation> possibleResources() {
            return ((Context)this.context).listElementTypes();
        }
    }

    public static interface Context<T, C, P> {
        public T forElementType(ImmutableStringReader var1, ResourceLocation var2) throws CommandSyntaxException;

        public Stream<ResourceLocation> listElementTypes();

        public T forTagType(ImmutableStringReader var1, ResourceLocation var2) throws CommandSyntaxException;

        public Stream<ResourceLocation> listTagTypes();

        public C lookupComponentType(ImmutableStringReader var1, ResourceLocation var2) throws CommandSyntaxException;

        public Stream<ResourceLocation> listComponentTypes();

        public T createComponentTest(ImmutableStringReader var1, C var2, Dynamic<?> var3) throws CommandSyntaxException;

        public T createComponentTest(ImmutableStringReader var1, C var2);

        public P lookupPredicateType(ImmutableStringReader var1, ResourceLocation var2) throws CommandSyntaxException;

        public Stream<ResourceLocation> listPredicateTypes();

        public T createPredicateTest(ImmutableStringReader var1, P var2, Dynamic<?> var3) throws CommandSyntaxException;

        public T negate(T var1);

        public T anyOf(List<T> var1);
    }

    static class TagLookupRule<T, C, P>
    extends ResourceLookupRule<Context<T, C, P>, T> {
        TagLookupRule(NamedRule<StringReader, ResourceLocation> p_410573_, Context<T, C, P> p_335934_) {
            super(p_410573_, p_335934_);
        }

        @Override
        protected T validateElement(ImmutableStringReader p_335858_, ResourceLocation p_335888_) throws Exception {
            return ((Context)this.context).forTagType(p_335858_, p_335888_);
        }

        @Override
        public Stream<ResourceLocation> possibleResources() {
            return ((Context)this.context).listTagTypes();
        }
    }

    static class ComponentLookupRule<T, C, P>
    extends ResourceLookupRule<Context<T, C, P>, C> {
        ComponentLookupRule(NamedRule<StringReader, ResourceLocation> p_410586_, Context<T, C, P> p_335692_) {
            super(p_410586_, p_335692_);
        }

        @Override
        protected C validateElement(ImmutableStringReader p_335604_, ResourceLocation p_335964_) throws Exception {
            return ((Context)this.context).lookupComponentType(p_335604_, p_335964_);
        }

        @Override
        public Stream<ResourceLocation> possibleResources() {
            return ((Context)this.context).listComponentTypes();
        }
    }

    static class PredicateLookupRule<T, C, P>
    extends ResourceLookupRule<Context<T, C, P>, P> {
        PredicateLookupRule(NamedRule<StringReader, ResourceLocation> p_409912_, Context<T, C, P> p_335572_) {
            super(p_409912_, p_335572_);
        }

        @Override
        protected P validateElement(ImmutableStringReader p_336035_, ResourceLocation p_335697_) throws Exception {
            return ((Context)this.context).lookupPredicateType(p_336035_, p_335697_);
        }

        @Override
        public Stream<ResourceLocation> possibleResources() {
            return ((Context)this.context).listPredicateTypes();
        }
    }
}

