/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.component;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public final class DataComponentExactPredicate
implements Predicate<DataComponentGetter> {
    public static final Codec<DataComponentExactPredicate> CODEC = DataComponentType.VALUE_MAP_CODEC.xmap(p_399796_ -> new DataComponentExactPredicate(p_399796_.entrySet().stream().map(TypedDataComponent::fromEntryUnchecked).collect(Collectors.toList())), p_399915_ -> p_399915_.expectedComponents.stream().filter(p_399578_ -> !p_399578_.type().isTransient()).collect(Collectors.toMap(TypedDataComponent::type, TypedDataComponent::value)));
    public static final StreamCodec<RegistryFriendlyByteBuf, DataComponentExactPredicate> STREAM_CODEC = TypedDataComponent.STREAM_CODEC.apply(ByteBufCodecs.list()).map(DataComponentExactPredicate::new, p_399906_ -> p_399906_.expectedComponents);
    public static final DataComponentExactPredicate EMPTY = new DataComponentExactPredicate(List.of());
    private final List<TypedDataComponent<?>> expectedComponents;

    DataComponentExactPredicate(List<TypedDataComponent<?>> p_399476_) {
        this.expectedComponents = p_399476_;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static <T> DataComponentExactPredicate expect(DataComponentType<T> p_399793_, T p_399502_) {
        return new DataComponentExactPredicate(List.of(new TypedDataComponent<T>(p_399793_, p_399502_)));
    }

    public static DataComponentExactPredicate allOf(DataComponentMap p_400188_) {
        return new DataComponentExactPredicate((List<TypedDataComponent<?>>)ImmutableList.copyOf((Iterable)p_400188_));
    }

    public static DataComponentExactPredicate someOf(DataComponentMap p_400247_, DataComponentType<?> ... p_399678_) {
        Builder $$2 = new Builder();
        for (DataComponentType<?> $$3 : p_399678_) {
            TypedDataComponent<?> $$4 = p_400247_.getTyped($$3);
            if ($$4 == null) continue;
            $$2.expect($$4);
        }
        return $$2.build();
    }

    public boolean isEmpty() {
        return this.expectedComponents.isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object p_399699_) {
        if (!(p_399699_ instanceof DataComponentExactPredicate)) return false;
        DataComponentExactPredicate $$1 = (DataComponentExactPredicate)p_399699_;
        if (!this.expectedComponents.equals($$1.expectedComponents)) return false;
        return true;
    }

    public int hashCode() {
        return this.expectedComponents.hashCode();
    }

    public String toString() {
        return this.expectedComponents.toString();
    }

    @Override
    public boolean test(DataComponentGetter p_400037_) {
        for (TypedDataComponent<?> $$1 : this.expectedComponents) {
            Object $$2 = p_400037_.get($$1.type());
            if (Objects.equals($$1.value(), $$2)) continue;
            return false;
        }
        return true;
    }

    public boolean alwaysMatches() {
        return this.expectedComponents.isEmpty();
    }

    public DataComponentPatch asPatch() {
        DataComponentPatch.Builder $$0 = DataComponentPatch.builder();
        for (TypedDataComponent<?> $$1 : this.expectedComponents) {
            $$0.set($$1);
        }
        return $$0.build();
    }

    @Override
    public /* synthetic */ boolean test(Object object) {
        return this.test((DataComponentGetter)object);
    }

    public static class Builder {
        private final List<TypedDataComponent<?>> expectedComponents = new ArrayList();

        Builder() {
        }

        public <T> Builder expect(TypedDataComponent<T> p_400286_) {
            return this.expect(p_400286_.type(), p_400286_.value());
        }

        public <T> Builder expect(DataComponentType<? super T> p_400166_, T p_400039_) {
            for (TypedDataComponent<?> $$2 : this.expectedComponents) {
                if ($$2.type() != p_400166_) continue;
                throw new IllegalArgumentException("Predicate already has component of type: '" + String.valueOf(p_400166_) + "'");
            }
            this.expectedComponents.add(new TypedDataComponent<T>(p_400166_, p_400039_));
            return this;
        }

        public DataComponentExactPredicate build() {
            return new DataComponentExactPredicate(List.copyOf(this.expectedComponents));
        }
    }
}

