/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import com.google.common.collect.ImmutableMap;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.WorldVersion;
import net.minecraft.data.CachedOutput;
import org.apache.commons.lang3.mutable.MutableInt;
import org.slf4j.Logger;

public class HashCache {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final String HEADER_MARKER = "// ";
    private final Path rootDir;
    private final Path cacheDir;
    private final String versionId;
    private final Map<String, ProviderCache> caches;
    private final Set<String> cachesToWrite = new HashSet<String>();
    final Set<Path> cachePaths = new HashSet<Path>();
    private final int initialCount;
    private int writes;

    private Path getProviderCachePath(String p_254395_) {
        return this.cacheDir.resolve(Hashing.sha1().hashString((CharSequence)p_254395_, StandardCharsets.UTF_8).toString());
    }

    public HashCache(Path p_236087_, Collection<String> p_253748_, WorldVersion p_236089_) throws IOException {
        this.versionId = p_236089_.getName();
        this.rootDir = p_236087_;
        this.cacheDir = p_236087_.resolve(".cache");
        Files.createDirectories(this.cacheDir, new FileAttribute[0]);
        HashMap<String, ProviderCache> $$3 = new HashMap<String, ProviderCache>();
        int $$4 = 0;
        for (String $$5 : p_253748_) {
            Path $$6 = this.getProviderCachePath($$5);
            this.cachePaths.add($$6);
            ProviderCache $$7 = HashCache.readCache(p_236087_, $$6);
            $$3.put($$5, $$7);
            $$4 += $$7.count();
        }
        this.caches = $$3;
        this.initialCount = $$4;
    }

    private static ProviderCache readCache(Path p_236093_, Path p_236094_) {
        if (Files.isReadable(p_236094_)) {
            try {
                return ProviderCache.load(p_236093_, p_236094_);
            }
            catch (Exception $$2) {
                LOGGER.warn("Failed to parse cache {}, discarding", (Object)p_236094_, (Object)$$2);
            }
        }
        return new ProviderCache("unknown", (ImmutableMap<Path, HashCode>)ImmutableMap.of());
    }

    public boolean shouldRunInThisVersion(String p_254319_) {
        ProviderCache $$1 = this.caches.get(p_254319_);
        return $$1 == null || !$$1.version.equals(this.versionId);
    }

    public CompletableFuture<UpdateResult> generateUpdate(String p_253944_, UpdateFunction p_254321_) {
        ProviderCache $$2 = this.caches.get(p_253944_);
        if ($$2 == null) {
            throw new IllegalStateException("Provider not registered: " + p_253944_);
        }
        CacheUpdater $$3 = new CacheUpdater(p_253944_, this.versionId, $$2);
        return p_254321_.update($$3).thenApply(p_253376_ -> $$3.close());
    }

    public void applyUpdate(UpdateResult p_253725_) {
        this.caches.put(p_253725_.providerId(), p_253725_.cache());
        this.cachesToWrite.add(p_253725_.providerId());
        this.writes += p_253725_.writes();
    }

    public void purgeStaleAndWrite() throws IOException {
        final HashSet<Path> $$0 = new HashSet<Path>();
        this.caches.forEach((p_253378_, p_253379_) -> {
            if (this.cachesToWrite.contains(p_253378_)) {
                Path $$3 = this.getProviderCachePath((String)p_253378_);
                p_253379_.save(this.rootDir, $$3, DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(LocalDateTime.now()) + "\t" + p_253378_);
            }
            $$0.addAll((Collection<Path>)p_253379_.data().keySet());
        });
        $$0.add(this.rootDir.resolve("version.json"));
        final MutableInt $$1 = new MutableInt();
        final MutableInt $$2 = new MutableInt();
        Files.walkFileTree(this.rootDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path p_320355_, BasicFileAttributes p_320633_) {
                if (HashCache.this.cachePaths.contains(p_320355_)) {
                    return FileVisitResult.CONTINUE;
                }
                $$1.increment();
                if ($$0.contains(p_320355_)) {
                    return FileVisitResult.CONTINUE;
                }
                try {
                    Files.delete(p_320355_);
                }
                catch (IOException $$22) {
                    LOGGER.warn("Failed to delete file {}", (Object)p_320355_, (Object)$$22);
                }
                $$2.increment();
                return FileVisitResult.CONTINUE;
            }

            @Override
            public /* synthetic */ FileVisitResult visitFile(Object object, BasicFileAttributes basicFileAttributes) throws IOException {
                return this.visitFile((Path)object, basicFileAttributes);
            }
        });
        LOGGER.info("Caching: total files: {}, old count: {}, new count: {}, removed stale: {}, written: {}", new Object[]{$$1, this.initialCount, $$0.size(), $$2, this.writes});
    }

    record ProviderCache(String version, ImmutableMap<Path, HashCode> data) {
        @Nullable
        public HashCode get(Path p_236135_) {
            return (HashCode)this.data.get((Object)p_236135_);
        }

        public int count() {
            return this.data.size();
        }

        public static ProviderCache load(Path p_236140_, Path p_236141_) throws IOException {
            try (BufferedReader $$2 = Files.newBufferedReader(p_236141_, StandardCharsets.UTF_8);){
                String $$3 = $$2.readLine();
                if (!$$3.startsWith(HashCache.HEADER_MARKER)) {
                    throw new IllegalStateException("Missing cache file header");
                }
                String[] $$4 = $$3.substring(HashCache.HEADER_MARKER.length()).split("\t", 2);
                String $$5 = $$4[0];
                ImmutableMap.Builder $$6 = ImmutableMap.builder();
                $$2.lines().forEach(p_253382_ -> {
                    int $$3 = p_253382_.indexOf(32);
                    $$6.put((Object)p_236140_.resolve(p_253382_.substring($$3 + 1)), (Object)HashCode.fromString((String)p_253382_.substring(0, $$3)));
                });
                ProviderCache providerCache = new ProviderCache($$5, (ImmutableMap<Path, HashCode>)$$6.build());
                return providerCache;
            }
        }

        public void save(Path p_236143_, Path p_236144_, String p_236145_) {
            try (BufferedWriter $$3 = Files.newBufferedWriter(p_236144_, StandardCharsets.UTF_8, new OpenOption[0]);){
                $$3.write(HashCache.HEADER_MARKER);
                $$3.write(this.version);
                $$3.write(9);
                $$3.write(p_236145_);
                $$3.newLine();
                for (Map.Entry $$4 : this.data.entrySet()) {
                    $$3.write(((HashCode)$$4.getValue()).toString());
                    $$3.write(32);
                    $$3.write(p_236143_.relativize((Path)$$4.getKey()).toString());
                    $$3.newLine();
                }
            }
            catch (IOException $$5) {
                LOGGER.warn("Unable write cachefile {}: {}", (Object)p_236144_, (Object)$$5);
            }
        }
    }

    static class CacheUpdater
    implements CachedOutput {
        private final String provider;
        private final ProviderCache oldCache;
        private final ProviderCacheBuilder newCache;
        private final AtomicInteger writes = new AtomicInteger();
        private volatile boolean closed;

        CacheUpdater(String p_253971_, String p_254002_, ProviderCache p_254244_) {
            this.provider = p_253971_;
            this.oldCache = p_254244_;
            this.newCache = new ProviderCacheBuilder(p_254002_);
        }

        private boolean shouldWrite(Path p_236120_, HashCode p_236121_) {
            return !Objects.equals(this.oldCache.get(p_236120_), p_236121_) || !Files.exists(p_236120_, new LinkOption[0]);
        }

        @Override
        public void writeIfNeeded(Path p_236123_, byte[] p_236124_, HashCode p_236125_) throws IOException {
            if (this.closed) {
                throw new IllegalStateException("Cannot write to cache as it has already been closed");
            }
            if (this.shouldWrite(p_236123_, p_236125_)) {
                this.writes.incrementAndGet();
                Files.createDirectories(p_236123_.getParent(), new FileAttribute[0]);
                Files.write(p_236123_, p_236124_, new OpenOption[0]);
            }
            this.newCache.put(p_236123_, p_236125_);
        }

        public UpdateResult close() {
            this.closed = true;
            return new UpdateResult(this.provider, this.newCache.build(), this.writes.get());
        }
    }

    @FunctionalInterface
    public static interface UpdateFunction {
        public CompletableFuture<?> update(CachedOutput var1);
    }

    public record UpdateResult(String providerId, ProviderCache cache, int writes) {
    }

    record ProviderCacheBuilder(String version, ConcurrentMap<Path, HashCode> data) {
        ProviderCacheBuilder(String p_254186_) {
            this(p_254186_, new ConcurrentHashMap<Path, HashCode>());
        }

        public void put(Path p_254121_, HashCode p_254288_) {
            this.data.put(p_254121_, p_254288_);
        }

        public ProviderCache build() {
            return new ProviderCache(this.version, (ImmutableMap<Path, HashCode>)ImmutableMap.copyOf(this.data));
        }
    }
}

