/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.tags;

import com.google.common.collect.Maps;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagBuilder;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagFile;
import net.minecraft.tags.TagKey;

public abstract class TagsProvider<T>
implements DataProvider {
    protected final PackOutput.PathProvider pathProvider;
    private final CompletableFuture<HolderLookup.Provider> lookupProvider;
    private final CompletableFuture<Void> contentsDone = new CompletableFuture();
    private final CompletableFuture<TagLookup<T>> parentProvider;
    protected final ResourceKey<? extends Registry<T>> registryKey;
    private final Map<ResourceLocation, TagBuilder> builders = Maps.newLinkedHashMap();

    protected TagsProvider(PackOutput p_256596_, ResourceKey<? extends Registry<T>> p_255886_, CompletableFuture<HolderLookup.Provider> p_256513_) {
        this(p_256596_, p_255886_, p_256513_, CompletableFuture.completedFuture(TagLookup.empty()));
    }

    protected TagsProvider(PackOutput p_275432_, ResourceKey<? extends Registry<T>> p_275476_, CompletableFuture<HolderLookup.Provider> p_275222_, CompletableFuture<TagLookup<T>> p_275565_) {
        this.pathProvider = p_275432_.createRegistryTagsPathProvider(p_275476_);
        this.registryKey = p_275476_;
        this.parentProvider = p_275565_;
        this.lookupProvider = p_275222_;
    }

    @Override
    public final String getName() {
        return "Tags for " + String.valueOf(this.registryKey.location());
    }

    protected abstract void addTags(HolderLookup.Provider var1);

    @Override
    public CompletableFuture<?> run(CachedOutput p_253684_) {
        record CombinedData<T>(HolderLookup.Provider contents, TagLookup<T> parent) {
        }
        return ((CompletableFuture)((CompletableFuture)this.createContentsProvider().thenApply(p_275895_ -> {
            this.contentsDone.complete(null);
            return p_275895_;
        })).thenCombineAsync(this.parentProvider, (p_274778_, p_274779_) -> new CombinedData((HolderLookup.Provider)p_274778_, p_274779_), (Executor)Util.backgroundExecutor())).thenCompose(p_323140_ -> {
            HolderGetter $$2 = p_323140_.contents.lookupOrThrow(this.registryKey);
            Predicate<ResourceLocation> $$3 = arg_0 -> this.lambda$run$2((HolderLookup.RegistryLookup)$$2, arg_0);
            Predicate<ResourceLocation> $$4 = p_274776_ -> this.builders.containsKey(p_274776_) || p_274775_.parent.contains(TagKey.create(this.registryKey, p_274776_));
            return CompletableFuture.allOf((CompletableFuture[])this.builders.entrySet().stream().map(p_323138_ -> {
                ResourceLocation $$5 = (ResourceLocation)p_323138_.getKey();
                TagBuilder $$6 = (TagBuilder)p_323138_.getValue();
                List<TagEntry> $$7 = $$6.build();
                List<TagEntry> $$8 = $$7.stream().filter(p_274771_ -> !p_274771_.verifyIfPresent($$3, $$4)).toList();
                if (!$$8.isEmpty()) {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "Couldn't define tag %s as it is missing following references: %s", $$5, $$8.stream().map(Objects::toString).collect(Collectors.joining(","))));
                }
                Path $$9 = this.pathProvider.json($$5);
                return DataProvider.saveStable(p_253684_, p_323137_.contents, TagFile.CODEC, new TagFile($$7, false), $$9);
            }).toArray(CompletableFuture[]::new));
        });
    }

    protected TagAppender<T> tag(TagKey<T> p_206425_) {
        TagBuilder $$1 = this.getOrCreateRawBuilder(p_206425_);
        return new TagAppender($$1);
    }

    protected TagBuilder getOrCreateRawBuilder(TagKey<T> p_236452_) {
        return this.builders.computeIfAbsent(p_236452_.location(), p_236442_ -> TagBuilder.create());
    }

    public CompletableFuture<TagLookup<T>> contentsGetter() {
        return this.contentsDone.thenApply(p_276016_ -> p_274772_ -> Optional.ofNullable(this.builders.get(p_274772_.location())));
    }

    protected CompletableFuture<HolderLookup.Provider> createContentsProvider() {
        return this.lookupProvider.thenApply(p_274768_ -> {
            this.builders.clear();
            this.addTags((HolderLookup.Provider)p_274768_);
            return p_274768_;
        });
    }

    private /* synthetic */ boolean lambda$run$2(HolderLookup.RegistryLookup p_255495_, ResourceLocation p_255496_) {
        return p_255495_.get(ResourceKey.create(this.registryKey, p_255496_)).isPresent();
    }

    @FunctionalInterface
    public static interface TagLookup<T>
    extends Function<TagKey<T>, Optional<TagBuilder>> {
        public static <T> TagLookup<T> empty() {
            return p_275247_ -> Optional.empty();
        }

        default public boolean contains(TagKey<T> p_275413_) {
            return ((Optional)this.apply(p_275413_)).isPresent();
        }
    }

    protected static class TagAppender<T> {
        private final TagBuilder builder;

        protected TagAppender(TagBuilder p_256426_) {
            this.builder = p_256426_;
        }

        public final TagAppender<T> add(ResourceKey<T> p_256138_) {
            this.builder.addElement(p_256138_.location());
            return this;
        }

        @SafeVarargs
        public final TagAppender<T> add(ResourceKey<T> ... p_211102_) {
            for (ResourceKey<T> $$1 : p_211102_) {
                this.builder.addElement($$1.location());
            }
            return this;
        }

        public final TagAppender<T> addAll(List<ResourceKey<T>> p_316189_) {
            for (ResourceKey<T> $$1 : p_316189_) {
                this.builder.addElement($$1.location());
            }
            return this;
        }

        public TagAppender<T> addOptional(ResourceLocation p_176840_) {
            this.builder.addOptionalElement(p_176840_);
            return this;
        }

        public TagAppender<T> addTag(TagKey<T> p_206429_) {
            this.builder.addTag(p_206429_.location());
            return this;
        }

        public TagAppender<T> addOptionalTag(ResourceLocation p_176842_) {
            this.builder.addOptionalTag(p_176842_);
            return this;
        }
    }
}

