/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.google.common.base.MoreObjects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.ExhaustedAttemptsException;
import net.minecraft.gametest.framework.GameTestAssertException;
import net.minecraft.gametest.framework.GameTestAssertPosException;
import net.minecraft.gametest.framework.GameTestInfo;
import net.minecraft.gametest.framework.GameTestInstance;
import net.minecraft.gametest.framework.GameTestListener;
import net.minecraft.gametest.framework.GameTestRunner;
import net.minecraft.gametest.framework.GlobalTestReporter;
import net.minecraft.gametest.framework.RetryOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.TestInstanceBlockEntity;
import org.apache.commons.lang3.exception.ExceptionUtils;

class ReportGameListener
implements GameTestListener {
    private int attempts = 0;
    private int successes = 0;

    @Override
    public void testStructureLoaded(GameTestInfo p_177718_) {
        ++this.attempts;
    }

    private void handleRetry(GameTestInfo p_319864_, GameTestRunner p_319782_, boolean p_320742_) {
        RetryOptions $$3 = p_319864_.retryOptions();
        Object $$4 = String.format("[Run: %4d, Ok: %4d, Fail: %4d", this.attempts, this.successes, this.attempts - this.successes);
        if (!$$3.unlimitedTries()) {
            $$4 = (String)$$4 + String.format(", Left: %4d", $$3.numberOfTries() - this.attempts);
        }
        $$4 = (String)$$4 + "]";
        String $$5 = String.valueOf(p_319864_.id()) + " " + (p_320742_ ? "passed" : "failed") + "! " + p_319864_.getRunTime() + "ms";
        String $$6 = String.format("%-53s%s", $$4, $$5);
        if (p_320742_) {
            ReportGameListener.reportPassed(p_319864_, $$6);
        } else {
            ReportGameListener.say(p_319864_.getLevel(), ChatFormatting.RED, $$6);
        }
        if ($$3.hasTriesLeft(this.attempts, this.successes)) {
            p_319782_.rerunTest(p_319864_);
        }
    }

    @Override
    public void testPassed(GameTestInfo p_177729_, GameTestRunner p_320359_) {
        ++this.successes;
        if (p_177729_.retryOptions().hasRetries()) {
            this.handleRetry(p_177729_, p_320359_, true);
            return;
        }
        if (!p_177729_.isFlaky()) {
            ReportGameListener.reportPassed(p_177729_, String.valueOf(p_177729_.id()) + " passed! (" + p_177729_.getRunTime() + "ms)");
            return;
        }
        if (this.successes >= p_177729_.requiredSuccesses()) {
            ReportGameListener.reportPassed(p_177729_, String.valueOf(p_177729_) + " passed " + this.successes + " times of " + this.attempts + " attempts.");
        } else {
            ReportGameListener.say(p_177729_.getLevel(), ChatFormatting.GREEN, "Flaky test " + String.valueOf(p_177729_) + " succeeded, attempt: " + this.attempts + " successes: " + this.successes);
            p_320359_.rerunTest(p_177729_);
        }
    }

    @Override
    public void testFailed(GameTestInfo p_177737_, GameTestRunner p_320181_) {
        if (!p_177737_.isFlaky()) {
            ReportGameListener.reportFailure(p_177737_, p_177737_.getError());
            if (p_177737_.retryOptions().hasRetries()) {
                this.handleRetry(p_177737_, p_320181_, false);
            }
            return;
        }
        GameTestInstance $$2 = p_177737_.getTest();
        String $$3 = "Flaky test " + String.valueOf(p_177737_) + " failed, attempt: " + this.attempts + "/" + $$2.maxAttempts();
        if ($$2.requiredSuccesses() > 1) {
            $$3 = $$3 + ", successes: " + this.successes + " (" + $$2.requiredSuccesses() + " required)";
        }
        ReportGameListener.say(p_177737_.getLevel(), ChatFormatting.YELLOW, $$3);
        if (p_177737_.maxAttempts() - this.attempts + this.successes >= p_177737_.requiredSuccesses()) {
            p_320181_.rerunTest(p_177737_);
        } else {
            ReportGameListener.reportFailure(p_177737_, new ExhaustedAttemptsException(this.attempts, this.successes, p_177737_));
        }
    }

    @Override
    public void testAddedForRerun(GameTestInfo p_320478_, GameTestInfo p_320907_, GameTestRunner p_320607_) {
        p_320907_.addListener(this);
    }

    public static void reportPassed(GameTestInfo p_177723_, String p_177724_) {
        ReportGameListener.getTestInstanceBlockEntity(p_177723_).ifPresent(p_396406_ -> p_396406_.setSuccess());
        ReportGameListener.visualizePassedTest(p_177723_, p_177724_);
    }

    private static void visualizePassedTest(GameTestInfo p_177731_, String p_177732_) {
        ReportGameListener.say(p_177731_.getLevel(), ChatFormatting.GREEN, p_177732_);
        GlobalTestReporter.onTestSuccess(p_177731_);
    }

    protected static void reportFailure(GameTestInfo p_177726_, Throwable p_177727_) {
        MutableComponent $$4;
        if (p_177727_ instanceof GameTestAssertException) {
            GameTestAssertException $$2 = (GameTestAssertException)p_177727_;
            Component $$3 = $$2.getDescription();
        } else {
            $$4 = Component.literal(Util.describeError(p_177727_));
        }
        ReportGameListener.getTestInstanceBlockEntity(p_177726_).ifPresent(p_396408_ -> p_396408_.setErrorMessage($$4));
        ReportGameListener.visualizeFailedTest(p_177726_, p_177727_);
    }

    protected static void visualizeFailedTest(GameTestInfo p_177734_, Throwable p_177735_) {
        String $$2 = p_177735_.getMessage() + (String)(p_177735_.getCause() == null ? "" : " cause: " + Util.describeError(p_177735_.getCause()));
        String $$3 = (p_177734_.isRequired() ? "" : "(optional) ") + String.valueOf(p_177734_.id()) + " failed! " + $$2;
        ReportGameListener.say(p_177734_.getLevel(), p_177734_.isRequired() ? ChatFormatting.RED : ChatFormatting.YELLOW, $$3);
        Throwable $$4 = (Throwable)MoreObjects.firstNonNull((Object)ExceptionUtils.getRootCause((Throwable)p_177735_), (Object)p_177735_);
        if ($$4 instanceof GameTestAssertPosException) {
            GameTestAssertPosException $$5 = (GameTestAssertPosException)$$4;
            ReportGameListener.showRedBox(p_177734_.getLevel(), $$5.getAbsolutePos(), $$5.getMessageToShowAtBlock());
        }
        GlobalTestReporter.onTestFailed(p_177734_);
    }

    private static Optional<TestInstanceBlockEntity> getTestInstanceBlockEntity(GameTestInfo p_397435_) {
        ServerLevel $$1 = p_397435_.getLevel();
        Optional<BlockPos> $$2 = Optional.ofNullable(p_397435_.getTestBlockPos());
        Optional<TestInstanceBlockEntity> $$3 = $$2.flatMap(p_396405_ -> $$1.getBlockEntity((BlockPos)p_396405_, BlockEntityType.TEST_INSTANCE_BLOCK));
        return $$3;
    }

    protected static void say(ServerLevel p_177701_, ChatFormatting p_177702_, String p_177703_) {
        p_177701_.getPlayers(p_177705_ -> true).forEach(p_177709_ -> p_177709_.sendSystemMessage(Component.literal(p_177703_).withStyle(p_177702_)));
    }

    private static void showRedBox(ServerLevel p_177697_, BlockPos p_177698_, String p_177699_) {
        DebugPackets.sendGameTestAddMarker(p_177697_, p_177698_, p_177699_, -2130771968, Integer.MAX_VALUE);
    }
}

