/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.functions.CommandFunction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerFunctionManager;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.GameRules;
import org.slf4j.Logger;

public interface TestEnvironmentDefinition {
    public static final Codec<TestEnvironmentDefinition> DIRECT_CODEC = BuiltInRegistries.TEST_ENVIRONMENT_DEFINITION_TYPE.byNameCodec().dispatch(TestEnvironmentDefinition::codec, p_397290_ -> p_397290_);
    public static final Codec<Holder<TestEnvironmentDefinition>> CODEC = RegistryFileCodec.create(Registries.TEST_ENVIRONMENT, DIRECT_CODEC);

    public static MapCodec<? extends TestEnvironmentDefinition> bootstrap(Registry<MapCodec<? extends TestEnvironmentDefinition>> p_397024_) {
        Registry.register(p_397024_, "all_of", AllOf.CODEC);
        Registry.register(p_397024_, "game_rules", SetGameRules.CODEC);
        Registry.register(p_397024_, "time_of_day", TimeOfDay.CODEC);
        Registry.register(p_397024_, "weather", Weather.CODEC);
        return Registry.register(p_397024_, "function", Functions.CODEC);
    }

    public void setup(ServerLevel var1);

    default public void teardown(ServerLevel p_397431_) {
    }

    public MapCodec<? extends TestEnvironmentDefinition> codec();

    public record AllOf(List<Holder<TestEnvironmentDefinition>> definitions) implements TestEnvironmentDefinition
    {
        public static final MapCodec<AllOf> CODEC = RecordCodecBuilder.mapCodec(p_397209_ -> p_397209_.group((App)CODEC.listOf().fieldOf("definitions").forGetter(AllOf::definitions)).apply((Applicative)p_397209_, AllOf::new));

        public AllOf(TestEnvironmentDefinition ... p_398055_) {
            this(Arrays.stream(p_398055_).map(Holder::direct).toList());
        }

        @Override
        public void setup(ServerLevel p_397476_) {
            this.definitions.forEach(p_397273_ -> ((TestEnvironmentDefinition)p_397273_.value()).setup(p_397476_));
        }

        @Override
        public void teardown(ServerLevel p_397650_) {
            this.definitions.forEach(p_397475_ -> ((TestEnvironmentDefinition)p_397475_.value()).teardown(p_397650_));
        }

        public MapCodec<AllOf> codec() {
            return CODEC;
        }
    }

    public record SetGameRules(List<Entry<Boolean, GameRules.BooleanValue>> boolRules, List<Entry<Integer, GameRules.IntegerValue>> intRules) implements TestEnvironmentDefinition
    {
        public static final MapCodec<SetGameRules> CODEC = RecordCodecBuilder.mapCodec(p_397782_ -> p_397782_.group((App)Entry.codec(GameRules.BooleanValue.class, Codec.BOOL).listOf().fieldOf("bool_rules").forGetter(SetGameRules::boolRules), (App)Entry.codec(GameRules.IntegerValue.class, Codec.INT).listOf().fieldOf("int_rules").forGetter(SetGameRules::intRules)).apply((Applicative)p_397782_, SetGameRules::new));

        @Override
        public void setup(ServerLevel p_397170_) {
            GameRules $$1 = p_397170_.getGameRules();
            MinecraftServer $$2 = p_397170_.getServer();
            for (Entry<Boolean, GameRules.BooleanValue> entry : this.boolRules) {
                $$1.getRule(entry.key()).set(entry.value(), $$2);
            }
            for (Entry<Comparable<Boolean>, GameRules.Value> entry : this.intRules) {
                ((GameRules.IntegerValue)$$1.getRule(entry.key())).set((Integer)entry.value(), $$2);
            }
        }

        @Override
        public void teardown(ServerLevel p_397717_) {
            GameRules $$1 = p_397717_.getGameRules();
            MinecraftServer $$2 = p_397717_.getServer();
            for (Entry<Boolean, GameRules.BooleanValue> entry : this.boolRules) {
                $$1.getRule(entry.key()).setFrom(GameRules.getType(entry.key()).createRule(), $$2);
            }
            for (Entry<Comparable<Boolean>, GameRules.Value> entry : this.intRules) {
                ((GameRules.IntegerValue)$$1.getRule(entry.key())).setFrom((GameRules.IntegerValue)GameRules.getType(entry.key()).createRule(), $$2);
            }
        }

        public MapCodec<SetGameRules> codec() {
            return CODEC;
        }

        public static <S, T extends GameRules.Value<T>> Entry<S, T> entry(GameRules.Key<T> p_397315_, S p_397234_) {
            return new Entry<S, T>(p_397315_, p_397234_);
        }

        public record Entry<S, T extends GameRules.Value<T>>(GameRules.Key<T> key, S value) {
            public static <S, T extends GameRules.Value<T>> Codec<Entry<S, T>> codec(Class<T> p_397595_, Codec<S> p_398057_) {
                return RecordCodecBuilder.create(p_397136_ -> p_397136_.group((App)GameRules.keyCodec(p_397595_).fieldOf("rule").forGetter(Entry::key), (App)p_398057_.fieldOf("value").forGetter(Entry::value)).apply((Applicative)p_397136_, Entry::new));
            }
        }
    }

    public record TimeOfDay(int time) implements TestEnvironmentDefinition
    {
        public static final MapCodec<TimeOfDay> CODEC = RecordCodecBuilder.mapCodec(p_397416_ -> p_397416_.group((App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("time").forGetter(TimeOfDay::time)).apply((Applicative)p_397416_, TimeOfDay::new));

        @Override
        public void setup(ServerLevel p_397305_) {
            p_397305_.setDayTime(this.time);
        }

        public MapCodec<TimeOfDay> codec() {
            return CODEC;
        }
    }

    public record Weather(Type weather) implements TestEnvironmentDefinition
    {
        public static final MapCodec<Weather> CODEC = RecordCodecBuilder.mapCodec(p_397274_ -> p_397274_.group((App)Type.CODEC.fieldOf("weather").forGetter(Weather::weather)).apply((Applicative)p_397274_, Weather::new));

        @Override
        public void setup(ServerLevel p_397776_) {
            this.weather.apply(p_397776_);
        }

        @Override
        public void teardown(ServerLevel p_397150_) {
            p_397150_.resetWeatherCycle();
        }

        public MapCodec<Weather> codec() {
            return CODEC;
        }

        public static enum Type implements StringRepresentable
        {
            CLEAR("clear", 100000, 0, false, false),
            RAIN("rain", 0, 100000, true, false),
            THUNDER("thunder", 0, 100000, true, true);

            public static final Codec<Type> CODEC;
            private final String id;
            private final int clearTime;
            private final int rainTime;
            private final boolean raining;
            private final boolean thundering;

            private Type(String p_397515_, int p_397174_, int p_397504_, boolean p_397182_, boolean p_397947_) {
                this.id = p_397515_;
                this.clearTime = p_397174_;
                this.rainTime = p_397504_;
                this.raining = p_397182_;
                this.thundering = p_397947_;
            }

            void apply(ServerLevel p_397874_) {
                p_397874_.setWeatherParameters(this.clearTime, this.rainTime, this.raining, this.thundering);
            }

            @Override
            public String getSerializedName() {
                return this.id;
            }

            static {
                CODEC = StringRepresentable.fromEnum(Type::values);
            }
        }
    }

    public record Functions(Optional<ResourceLocation> setupFunction, Optional<ResourceLocation> teardownFunction) implements TestEnvironmentDefinition
    {
        private static final Logger LOGGER = LogUtils.getLogger();
        public static final MapCodec<Functions> CODEC = RecordCodecBuilder.mapCodec(p_397358_ -> p_397358_.group((App)ResourceLocation.CODEC.optionalFieldOf("setup").forGetter(Functions::setupFunction), (App)ResourceLocation.CODEC.optionalFieldOf("teardown").forGetter(Functions::teardownFunction)).apply((Applicative)p_397358_, Functions::new));

        @Override
        public void setup(ServerLevel p_397955_) {
            this.setupFunction.ifPresent(p_397245_ -> Functions.run(p_397955_, p_397245_));
        }

        @Override
        public void teardown(ServerLevel p_397731_) {
            this.teardownFunction.ifPresent(p_397509_ -> Functions.run(p_397731_, p_397509_));
        }

        private static void run(ServerLevel p_397011_, ResourceLocation p_397867_) {
            MinecraftServer $$2 = p_397011_.getServer();
            ServerFunctionManager $$3 = $$2.getFunctions();
            Optional<CommandFunction<CommandSourceStack>> $$4 = $$3.get(p_397867_);
            if ($$4.isPresent()) {
                CommandSourceStack $$5 = $$2.createCommandSourceStack().withPermission(2).withSuppressedOutput().withLevel(p_397011_);
                $$3.execute($$4.get(), $$5);
            } else {
                LOGGER.error("Test Batch failed for non-existent function {}", (Object)p_397867_);
            }
        }

        public MapCodec<Functions> codec() {
            return CODEC;
        }
    }
}

