/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.gametest.framework.FailedTestTracker;
import net.minecraft.gametest.framework.GameTestInstance;
import net.minecraft.gametest.framework.StructureUtils;
import net.minecraft.gametest.framework.TestInstanceFinder;
import net.minecraft.gametest.framework.TestPosFinder;

public class TestFinder
implements TestInstanceFinder,
TestPosFinder {
    static final TestInstanceFinder NO_FUNCTIONS = Stream::empty;
    static final TestPosFinder NO_STRUCTURES = Stream::empty;
    private final TestInstanceFinder testInstanceFinder;
    private final TestPosFinder testPosFinder;
    private final CommandSourceStack source;

    @Override
    public Stream<BlockPos> findTestPos() {
        return this.testPosFinder.findTestPos();
    }

    public static Builder builder() {
        return new Builder();
    }

    TestFinder(CommandSourceStack p_320004_, TestInstanceFinder p_397279_, TestPosFinder p_397048_) {
        this.source = p_320004_;
        this.testInstanceFinder = p_397279_;
        this.testPosFinder = p_397048_;
    }

    public CommandSourceStack source() {
        return this.source;
    }

    @Override
    public Stream<Holder.Reference<GameTestInstance>> findTests() {
        return this.testInstanceFinder.findTests();
    }

    public static class Builder {
        private final UnaryOperator<Supplier<Stream<Holder.Reference<GameTestInstance>>>> testFinderWrapper;
        private final UnaryOperator<Supplier<Stream<BlockPos>>> structureBlockPosFinderWrapper;

        public Builder() {
            this.testFinderWrapper = p_329857_ -> p_329857_;
            this.structureBlockPosFinderWrapper = p_329858_ -> p_329858_;
        }

        private Builder(UnaryOperator<Supplier<Stream<Holder.Reference<GameTestInstance>>>> p_397152_, UnaryOperator<Supplier<Stream<BlockPos>>> p_398014_) {
            this.testFinderWrapper = p_397152_;
            this.structureBlockPosFinderWrapper = p_398014_;
        }

        public Builder createMultipleCopies(int p_330482_) {
            return new Builder(Builder.createCopies(p_330482_), Builder.createCopies(p_330482_));
        }

        private static <Q> UnaryOperator<Supplier<Stream<Q>>> createCopies(int p_330804_) {
            return p_396490_ -> {
                LinkedList $$2 = new LinkedList();
                List $$3 = ((Stream)p_396490_.get()).toList();
                for (int $$4 = 0; $$4 < p_330804_; ++$$4) {
                    $$2.addAll($$3);
                }
                return $$2::stream;
            };
        }

        private TestFinder build(CommandSourceStack p_330622_, TestInstanceFinder p_397791_, TestPosFinder p_397288_) {
            return new TestFinder(p_330622_, ((Supplier)((Supplier)this.testFinderWrapper.apply(p_397791_::findTests)))::get, ((Supplier)((Supplier)this.structureBlockPosFinderWrapper.apply(p_397288_::findTestPos)))::get);
        }

        public TestFinder radius(CommandContext<CommandSourceStack> p_320307_, int p_320811_) {
            CommandSourceStack $$2 = (CommandSourceStack)p_320307_.getSource();
            BlockPos $$3 = BlockPos.containing($$2.getPosition());
            return this.build($$2, NO_FUNCTIONS, () -> StructureUtils.findTestBlocks($$3, p_320811_, $$2.getLevel()));
        }

        public TestFinder nearest(CommandContext<CommandSourceStack> p_320944_) {
            CommandSourceStack $$1 = (CommandSourceStack)p_320944_.getSource();
            BlockPos $$2 = BlockPos.containing($$1.getPosition());
            return this.build($$1, NO_FUNCTIONS, () -> StructureUtils.findNearestTest($$2, 15, $$1.getLevel()).stream());
        }

        public TestFinder allNearby(CommandContext<CommandSourceStack> p_320216_) {
            CommandSourceStack $$1 = (CommandSourceStack)p_320216_.getSource();
            BlockPos $$2 = BlockPos.containing($$1.getPosition());
            return this.build($$1, NO_FUNCTIONS, () -> StructureUtils.findTestBlocks($$2, 200, $$1.getLevel()));
        }

        public TestFinder lookedAt(CommandContext<CommandSourceStack> p_320178_) {
            CommandSourceStack $$1 = (CommandSourceStack)p_320178_.getSource();
            return this.build($$1, NO_FUNCTIONS, () -> StructureUtils.lookedAtTestPos(BlockPos.containing($$1.getPosition()), $$1.getPlayer().getCamera(), $$1.getLevel()));
        }

        public TestFinder failedTests(CommandContext<CommandSourceStack> p_320960_, boolean p_320352_) {
            return this.build((CommandSourceStack)p_320960_.getSource(), () -> FailedTestTracker.getLastFailedTests().filter(p_396483_ -> !p_320352_ || ((GameTestInstance)p_396483_.value()).required()), NO_STRUCTURES);
        }

        public TestFinder byResourceSelection(CommandContext<CommandSourceStack> p_397078_, Collection<Holder.Reference<GameTestInstance>> p_397871_) {
            return this.build((CommandSourceStack)p_397078_.getSource(), p_397871_::stream, NO_STRUCTURES);
        }

        public TestFinder failedTests(CommandContext<CommandSourceStack> p_320220_) {
            return this.failedTests(p_320220_, false);
        }
    }
}

