/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.lang.runtime.SwitchBootstraps;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class NbtOps
implements DynamicOps<Tag> {
    public static final NbtOps INSTANCE = new NbtOps();

    private NbtOps() {
    }

    public Tag empty() {
        return EndTag.INSTANCE;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <U> U convertTo(DynamicOps<U> p_128980_, Tag p_128981_) {
        Object object;
        Tag tag = p_128981_;
        Objects.requireNonNull(tag);
        Tag tag2 = tag;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EndTag.class, ByteTag.class, ShortTag.class, IntTag.class, LongTag.class, FloatTag.class, DoubleTag.class, ByteArrayTag.class, StringTag.class, ListTag.class, CompoundTag.class, IntArrayTag.class, LongArrayTag.class}, (Object)tag2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                EndTag $$2 = (EndTag)tag2;
                object = p_128980_.empty();
                return (U)object;
            }
            case 1: {
                byte $$3;
                ByteTag byteTag = (ByteTag)tag2;
                try {
                    byte by;
                    $$3 = by = byteTag.value();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                object = p_128980_.createByte($$3);
                return (U)object;
            }
            case 2: {
                short $$4;
                ShortTag shortTag = (ShortTag)tag2;
                {
                    short s;
                    $$4 = s = shortTag.value();
                }
                object = p_128980_.createShort($$4);
                return (U)object;
            }
            case 3: {
                int $$5;
                IntTag intTag = (IntTag)tag2;
                {
                    int n2;
                    $$5 = n2 = intTag.value();
                }
                object = p_128980_.createInt($$5);
                return (U)object;
            }
            case 4: {
                long $$6;
                LongTag longTag = (LongTag)tag2;
                {
                    long l;
                    $$6 = l = longTag.value();
                }
                object = p_128980_.createLong($$6);
                return (U)object;
            }
            case 5: {
                float $$7;
                FloatTag floatTag = (FloatTag)tag2;
                {
                    float f;
                    $$7 = f = floatTag.value();
                }
                object = p_128980_.createFloat($$7);
                return (U)object;
            }
            case 6: {
                double $$8;
                DoubleTag doubleTag = (DoubleTag)tag2;
                {
                    double d;
                    $$8 = d = doubleTag.value();
                }
                object = p_128980_.createDouble($$8);
                return (U)object;
            }
            case 7: {
                ByteArrayTag $$9 = (ByteArrayTag)tag2;
                object = p_128980_.createByteList(ByteBuffer.wrap($$9.getAsByteArray()));
                return (U)object;
            }
            case 8: {
                String $$10;
                StringTag stringTag = (StringTag)tag2;
                {
                    String string;
                    $$10 = string = stringTag.value();
                }
                object = p_128980_.createString($$10);
                return (U)object;
            }
            case 9: {
                ListTag $$11 = (ListTag)tag2;
                object = this.convertList(p_128980_, $$11);
                return (U)object;
            }
            case 10: {
                CompoundTag $$12 = (CompoundTag)tag2;
                object = this.convertMap(p_128980_, $$12);
                return (U)object;
            }
            case 11: {
                IntArrayTag $$13 = (IntArrayTag)tag2;
                object = p_128980_.createIntList(Arrays.stream($$13.getAsIntArray()));
                return (U)object;
            }
            case 12: 
        }
        LongArrayTag $$14 = (LongArrayTag)tag2;
        object = p_128980_.createLongList(Arrays.stream($$14.getAsLongArray()));
        return (U)object;
    }

    public DataResult<Number> getNumberValue(Tag p_129030_) {
        return p_129030_.asNumber().map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Not a number"));
    }

    public Tag createNumeric(Number p_128983_) {
        return DoubleTag.valueOf(p_128983_.doubleValue());
    }

    public Tag createByte(byte p_128963_) {
        return ByteTag.valueOf(p_128963_);
    }

    public Tag createShort(short p_129048_) {
        return ShortTag.valueOf(p_129048_);
    }

    public Tag createInt(int p_128976_) {
        return IntTag.valueOf(p_128976_);
    }

    public Tag createLong(long p_128978_) {
        return LongTag.valueOf(p_128978_);
    }

    public Tag createFloat(float p_128974_) {
        return FloatTag.valueOf(p_128974_);
    }

    public Tag createDouble(double p_128972_) {
        return DoubleTag.valueOf(p_128972_);
    }

    public Tag createBoolean(boolean p_129050_) {
        return ByteTag.valueOf(p_129050_);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DataResult<String> getStringValue(Tag p_129061_) {
        String $$1;
        if (!(p_129061_ instanceof StringTag)) return DataResult.error(() -> "Not a string");
        StringTag stringTag = (StringTag)p_129061_;
        try {
            String string;
            $$1 = string = stringTag.value();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        return DataResult.success((Object)$$1);
    }

    public Tag createString(String p_128985_) {
        return StringTag.valueOf(p_128985_);
    }

    public DataResult<Tag> mergeToList(Tag p_129041_, Tag p_129042_) {
        return NbtOps.createCollector(p_129041_).map(p_248053_ -> DataResult.success((Object)p_248053_.accept(p_129042_).result())).orElseGet(() -> DataResult.error(() -> "mergeToList called with not a list: " + String.valueOf(p_129041_), (Object)p_129041_));
    }

    public DataResult<Tag> mergeToList(Tag p_129038_, List<Tag> p_129039_) {
        return NbtOps.createCollector(p_129038_).map(p_248048_ -> DataResult.success((Object)p_248048_.acceptAll(p_129039_).result())).orElseGet(() -> DataResult.error(() -> "mergeToList called with not a list: " + String.valueOf(p_129038_), (Object)p_129038_));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DataResult<Tag> mergeToMap(Tag p_129044_, Tag p_129045_, Tag p_129046_) {
        void $$4;
        CompoundTag compoundTag;
        if (!(p_129044_ instanceof CompoundTag) && !(p_129044_ instanceof EndTag)) {
            return DataResult.error(() -> "mergeToMap called with not a map: " + String.valueOf(p_129044_), (Object)p_129044_);
        }
        if (!(p_129045_ instanceof StringTag)) return DataResult.error(() -> "key is not a string: " + String.valueOf(p_129045_), (Object)p_129044_);
        StringTag stringTag = (StringTag)p_129045_;
        try {
            String string;
            String $$3 = string = stringTag.value();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        if (p_129044_ instanceof CompoundTag) {
            CompoundTag $$5 = (CompoundTag)p_129044_;
            compoundTag = $$5.shallowCopy();
        } else {
            compoundTag = new CompoundTag();
        }
        CompoundTag $$6 = compoundTag;
        $$6.put((String)$$4, p_129046_);
        return DataResult.success((Object)$$6);
    }

    public DataResult<Tag> mergeToMap(Tag p_129032_, MapLike<Tag> p_129033_) {
        CompoundTag compoundTag;
        if (!(p_129032_ instanceof CompoundTag) && !(p_129032_ instanceof EndTag)) {
            return DataResult.error(() -> "mergeToMap called with not a map: " + String.valueOf(p_129032_), (Object)p_129032_);
        }
        if (p_129032_ instanceof CompoundTag) {
            CompoundTag $$2 = (CompoundTag)p_129032_;
            compoundTag = $$2.shallowCopy();
        } else {
            compoundTag = new CompoundTag();
        }
        CompoundTag $$3 = compoundTag;
        ArrayList $$4 = new ArrayList();
        p_129033_.entries().forEach(p_409125_ -> {
            void $$7;
            Tag $$3 = (Tag)p_409125_.getFirst();
            if (!($$3 instanceof StringTag)) {
                $$4.add($$3);
                return;
            }
            StringTag $$4 = (StringTag)$$3;
            try {
                String $$5;
                String $$6 = $$5 = $$4.value();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            $$3.put((String)$$7, (Tag)p_409125_.getSecond());
        });
        if (!$$4.isEmpty()) {
            return DataResult.error(() -> "some keys are not strings: " + String.valueOf($$4), (Object)$$3);
        }
        return DataResult.success((Object)$$3);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DataResult<Tag> mergeToMap(Tag p_341945_, Map<Tag, Tag> p_341920_) {
        CompoundTag compoundTag;
        if (!(p_341945_ instanceof CompoundTag) && !(p_341945_ instanceof EndTag)) {
            return DataResult.error(() -> "mergeToMap called with not a map: " + String.valueOf(p_341945_), (Object)p_341945_);
        }
        if (p_341945_ instanceof CompoundTag) {
            CompoundTag $$2 = (CompoundTag)p_341945_;
            compoundTag = $$2.shallowCopy();
        } else {
            compoundTag = new CompoundTag();
        }
        CompoundTag $$3 = compoundTag;
        ArrayList<Tag> $$4 = new ArrayList<Tag>();
        for (Map.Entry<Tag, Tag> $$5 : p_341920_.entrySet()) {
            Tag $$6 = $$5.getKey();
            if ($$6 instanceof StringTag) {
                StringTag stringTag = (StringTag)$$6;
                try {
                    String string;
                    String $$7 = string = stringTag.value();
                    $$3.put($$7, $$5.getValue());
                    continue;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            $$4.add($$6);
        }
        if (!$$4.isEmpty()) {
            return DataResult.error(() -> "some keys are not strings: " + String.valueOf($$4), (Object)$$3);
        }
        return DataResult.success((Object)$$3);
    }

    public DataResult<Stream<Pair<Tag, Tag>>> getMapValues(Tag p_129070_) {
        if (p_129070_ instanceof CompoundTag) {
            CompoundTag $$1 = (CompoundTag)p_129070_;
            return DataResult.success($$1.entrySet().stream().map(p_341872_ -> Pair.of((Object)this.createString((String)p_341872_.getKey()), (Object)((Tag)p_341872_.getValue()))));
        }
        return DataResult.error(() -> "Not a map: " + String.valueOf(p_129070_));
    }

    public DataResult<Consumer<BiConsumer<Tag, Tag>>> getMapEntries(Tag p_129103_) {
        if (p_129103_ instanceof CompoundTag) {
            CompoundTag $$1 = (CompoundTag)p_129103_;
            return DataResult.success(p_341867_ -> {
                for (Map.Entry<String, Tag> $$2 : $$1.entrySet()) {
                    p_341867_.accept(this.createString($$2.getKey()), $$2.getValue());
                }
            });
        }
        return DataResult.error(() -> "Not a map: " + String.valueOf(p_129103_));
    }

    public DataResult<MapLike<Tag>> getMap(Tag p_129105_) {
        if (p_129105_ instanceof CompoundTag) {
            final CompoundTag $$1 = (CompoundTag)p_129105_;
            return DataResult.success((Object)new MapLike<Tag>(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public Tag get(Tag p_129174_) {
                    if (!(p_129174_ instanceof StringTag)) throw new UnsupportedOperationException("Cannot get map entry with non-string key: " + String.valueOf(p_129174_));
                    StringTag stringTag = (StringTag)p_129174_;
                    try {
                        String string;
                        String $$12 = string = stringTag.value();
                        return $$1.get($$12);
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                }

                @Nullable
                public Tag get(String p_129169_) {
                    return $$1.get(p_129169_);
                }

                public Stream<Pair<Tag, Tag>> entries() {
                    return $$1.entrySet().stream().map(p_341873_ -> Pair.of((Object)NbtOps.this.createString((String)p_341873_.getKey()), (Object)((Tag)p_341873_.getValue())));
                }

                public String toString() {
                    return "MapLike[" + String.valueOf($$1) + "]";
                }

                @Nullable
                public /* synthetic */ Object get(String string) {
                    return this.get(string);
                }

                @Nullable
                public /* synthetic */ Object get(Object object) {
                    return this.get((Tag)object);
                }
            });
        }
        return DataResult.error(() -> "Not a map: " + String.valueOf(p_129105_));
    }

    public Tag createMap(Stream<Pair<Tag, Tag>> p_129004_) {
        CompoundTag $$1 = new CompoundTag();
        p_129004_.forEach(p_409127_ -> {
            Tag $$2 = (Tag)p_409127_.getFirst();
            Tag $$3 = (Tag)p_409127_.getSecond();
            if (!($$2 instanceof StringTag)) throw new UnsupportedOperationException("Cannot create map with non-string key: " + String.valueOf($$2));
            StringTag $$4 = (StringTag)$$2;
            try {
                String $$5;
                String $$6 = $$5 = $$4.value();
                $$1.put($$6, $$3);
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        });
        return $$1;
    }

    public DataResult<Stream<Tag>> getStream(Tag p_129108_) {
        if (p_129108_ instanceof CollectionTag) {
            CollectionTag $$1 = (CollectionTag)p_129108_;
            return DataResult.success($$1.stream());
        }
        return DataResult.error(() -> "Not a list");
    }

    public DataResult<Consumer<Consumer<Tag>>> getList(Tag p_129110_) {
        if (p_129110_ instanceof CollectionTag) {
            CollectionTag $$1 = (CollectionTag)p_129110_;
            return DataResult.success($$1::forEach);
        }
        return DataResult.error(() -> "Not a list: " + String.valueOf(p_129110_));
    }

    public DataResult<ByteBuffer> getByteBuffer(Tag p_129132_) {
        if (p_129132_ instanceof ByteArrayTag) {
            ByteArrayTag $$1 = (ByteArrayTag)p_129132_;
            return DataResult.success((Object)ByteBuffer.wrap($$1.getAsByteArray()));
        }
        return super.getByteBuffer((Object)p_129132_);
    }

    public Tag createByteList(ByteBuffer p_128990_) {
        ByteBuffer $$1 = p_128990_.duplicate().clear();
        byte[] $$2 = new byte[p_128990_.capacity()];
        $$1.get(0, $$2, 0, $$2.length);
        return new ByteArrayTag($$2);
    }

    public DataResult<IntStream> getIntStream(Tag p_129134_) {
        if (p_129134_ instanceof IntArrayTag) {
            IntArrayTag $$1 = (IntArrayTag)p_129134_;
            return DataResult.success((Object)Arrays.stream($$1.getAsIntArray()));
        }
        return super.getIntStream((Object)p_129134_);
    }

    public Tag createIntList(IntStream p_129000_) {
        return new IntArrayTag(p_129000_.toArray());
    }

    public DataResult<LongStream> getLongStream(Tag p_129136_) {
        if (p_129136_ instanceof LongArrayTag) {
            LongArrayTag $$1 = (LongArrayTag)p_129136_;
            return DataResult.success((Object)Arrays.stream($$1.getAsLongArray()));
        }
        return super.getLongStream((Object)p_129136_);
    }

    public Tag createLongList(LongStream p_129002_) {
        return new LongArrayTag(p_129002_.toArray());
    }

    public Tag createList(Stream<Tag> p_129052_) {
        return new ListTag(p_129052_.collect(Util.toMutableList()));
    }

    public Tag remove(Tag p_129035_, String p_129036_) {
        if (p_129035_ instanceof CompoundTag) {
            CompoundTag $$2 = (CompoundTag)p_129035_;
            CompoundTag $$3 = $$2.shallowCopy();
            $$3.remove(p_129036_);
            return $$3;
        }
        return p_129035_;
    }

    public String toString() {
        return "NBT";
    }

    public RecordBuilder<Tag> mapBuilder() {
        return new NbtRecordBuilder(this);
    }

    private static Optional<ListCollector> createCollector(Tag p_249503_) {
        if (p_249503_ instanceof EndTag) {
            return Optional.of(new GenericListCollector());
        }
        if (p_249503_ instanceof CollectionTag) {
            CollectionTag $$1 = (CollectionTag)p_249503_;
            if ($$1.isEmpty()) {
                return Optional.of(new GenericListCollector());
            }
            CollectionTag collectionTag = $$1;
            Objects.requireNonNull(collectionTag);
            CollectionTag collectionTag2 = collectionTag;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ListTag.class, ByteArrayTag.class, IntArrayTag.class, LongArrayTag.class}, (Object)collectionTag2, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    ListTag $$2 = (ListTag)collectionTag2;
                    yield Optional.of(new GenericListCollector($$2));
                }
                case 1 -> {
                    ByteArrayTag $$3 = (ByteArrayTag)collectionTag2;
                    yield Optional.of(new ByteListCollector($$3.getAsByteArray()));
                }
                case 2 -> {
                    IntArrayTag $$4 = (IntArrayTag)collectionTag2;
                    yield Optional.of(new IntListCollector($$4.getAsIntArray()));
                }
                case 3 -> {
                    LongArrayTag $$5 = (LongArrayTag)collectionTag2;
                    yield Optional.of(new LongListCollector($$5.getAsLongArray()));
                }
            };
        }
        return Optional.empty();
    }

    public /* synthetic */ Object remove(Object object, String string) {
        return this.remove((Tag)object, string);
    }

    public /* synthetic */ Object createLongList(LongStream longStream) {
        return this.createLongList(longStream);
    }

    public /* synthetic */ DataResult getLongStream(Object object) {
        return this.getLongStream((Tag)object);
    }

    public /* synthetic */ Object createIntList(IntStream intStream) {
        return this.createIntList(intStream);
    }

    public /* synthetic */ DataResult getIntStream(Object object) {
        return this.getIntStream((Tag)object);
    }

    public /* synthetic */ Object createByteList(ByteBuffer byteBuffer) {
        return this.createByteList(byteBuffer);
    }

    public /* synthetic */ DataResult getByteBuffer(Object object) {
        return this.getByteBuffer((Tag)object);
    }

    public /* synthetic */ Object createList(Stream stream) {
        return this.createList(stream);
    }

    public /* synthetic */ DataResult getList(Object object) {
        return this.getList((Tag)object);
    }

    public /* synthetic */ DataResult getStream(Object object) {
        return this.getStream((Tag)object);
    }

    public /* synthetic */ DataResult getMap(Object object) {
        return this.getMap((Tag)object);
    }

    public /* synthetic */ Object createMap(Stream stream) {
        return this.createMap(stream);
    }

    public /* synthetic */ DataResult getMapEntries(Object object) {
        return this.getMapEntries((Tag)object);
    }

    public /* synthetic */ DataResult getMapValues(Object object) {
        return this.getMapValues((Tag)object);
    }

    public /* synthetic */ DataResult mergeToMap(Object object, MapLike mapLike) {
        return this.mergeToMap((Tag)object, (MapLike<Tag>)mapLike);
    }

    public /* synthetic */ DataResult mergeToMap(Object object, Map map) {
        return this.mergeToMap((Tag)object, (Map<Tag, Tag>)map);
    }

    public /* synthetic */ DataResult mergeToMap(Object object, Object object2, Object object3) {
        return this.mergeToMap((Tag)object, (Tag)object2, (Tag)object3);
    }

    public /* synthetic */ DataResult mergeToList(Object object, List list) {
        return this.mergeToList((Tag)object, (List<Tag>)list);
    }

    public /* synthetic */ DataResult mergeToList(Object object, Object object2) {
        return this.mergeToList((Tag)object, (Tag)object2);
    }

    public /* synthetic */ Object createString(String string) {
        return this.createString(string);
    }

    public /* synthetic */ DataResult getStringValue(Object object) {
        return this.getStringValue((Tag)object);
    }

    public /* synthetic */ Object createBoolean(boolean bl) {
        return this.createBoolean(bl);
    }

    public /* synthetic */ Object createDouble(double d) {
        return this.createDouble(d);
    }

    public /* synthetic */ Object createFloat(float f) {
        return this.createFloat(f);
    }

    public /* synthetic */ Object createLong(long l) {
        return this.createLong(l);
    }

    public /* synthetic */ Object createInt(int n) {
        return this.createInt(n);
    }

    public /* synthetic */ Object createShort(short s) {
        return this.createShort(s);
    }

    public /* synthetic */ Object createByte(byte by) {
        return this.createByte(by);
    }

    public /* synthetic */ Object createNumeric(Number number) {
        return this.createNumeric(number);
    }

    public /* synthetic */ DataResult getNumberValue(Object object) {
        return this.getNumberValue((Tag)object);
    }

    public /* synthetic */ Object convertTo(DynamicOps dynamicOps, Object object) {
        return this.convertTo(dynamicOps, (Tag)object);
    }

    public /* synthetic */ Object empty() {
        return this.empty();
    }

    class NbtRecordBuilder
    extends RecordBuilder.AbstractStringBuilder<Tag, CompoundTag> {
        protected NbtRecordBuilder(NbtOps nbtOps) {
            super((DynamicOps)nbtOps);
        }

        protected CompoundTag initBuilder() {
            return new CompoundTag();
        }

        protected CompoundTag append(String p_129186_, Tag p_129187_, CompoundTag p_129188_) {
            p_129188_.put(p_129186_, p_129187_);
            return p_129188_;
        }

        protected DataResult<Tag> build(CompoundTag p_129190_, Tag p_129191_) {
            if (p_129191_ == null || p_129191_ == EndTag.INSTANCE) {
                return DataResult.success((Object)p_129190_);
            }
            if (p_129191_ instanceof CompoundTag) {
                CompoundTag $$2 = (CompoundTag)p_129191_;
                CompoundTag $$3 = $$2.shallowCopy();
                for (Map.Entry<String, Tag> $$4 : p_129190_.entrySet()) {
                    $$3.put($$4.getKey(), $$4.getValue());
                }
                return DataResult.success((Object)$$3);
            }
            return DataResult.error(() -> "mergeToMap called with not a map: " + String.valueOf(p_129191_), (Object)p_129191_);
        }

        protected /* synthetic */ Object append(String string, Object object, Object object2) {
            return this.append(string, (Tag)object, (CompoundTag)object2);
        }

        protected /* synthetic */ DataResult build(Object object, Object object2) {
            return this.build((CompoundTag)object, (Tag)object2);
        }

        protected /* synthetic */ Object initBuilder() {
            return this.initBuilder();
        }
    }

    static class GenericListCollector
    implements ListCollector {
        private final ListTag result = new ListTag();

        GenericListCollector() {
        }

        GenericListCollector(ListTag p_410808_) {
            this.result.addAll(p_410808_);
        }

        public GenericListCollector(IntArrayList p_410408_) {
            p_410408_.forEach(p_410063_ -> this.result.add(IntTag.valueOf(p_410063_)));
        }

        public GenericListCollector(ByteArrayList p_410684_) {
            p_410684_.forEach(p_410068_ -> this.result.add(ByteTag.valueOf(p_410068_)));
        }

        public GenericListCollector(LongArrayList p_410197_) {
            p_410197_.forEach(p_409796_ -> this.result.add(LongTag.valueOf(p_409796_)));
        }

        @Override
        public ListCollector accept(Tag p_409877_) {
            this.result.add(p_409877_);
            return this;
        }

        @Override
        public Tag result() {
            return this.result;
        }
    }

    static class ByteListCollector
    implements ListCollector {
        private final ByteArrayList values = new ByteArrayList();

        public ByteListCollector(byte[] p_250457_) {
            this.values.addElements(0, p_250457_);
        }

        @Override
        public ListCollector accept(Tag p_250723_) {
            if (p_250723_ instanceof ByteTag) {
                ByteTag $$1 = (ByteTag)p_250723_;
                this.values.add($$1.byteValue());
                return this;
            }
            return new GenericListCollector(this.values).accept(p_250723_);
        }

        @Override
        public Tag result() {
            return new ByteArrayTag(this.values.toByteArray());
        }
    }

    static class IntListCollector
    implements ListCollector {
        private final IntArrayList values = new IntArrayList();

        public IntListCollector(int[] p_249489_) {
            this.values.addElements(0, p_249489_);
        }

        @Override
        public ListCollector accept(Tag p_251372_) {
            if (p_251372_ instanceof IntTag) {
                IntTag $$1 = (IntTag)p_251372_;
                this.values.add($$1.intValue());
                return this;
            }
            return new GenericListCollector(this.values).accept(p_251372_);
        }

        @Override
        public Tag result() {
            return new IntArrayTag(this.values.toIntArray());
        }
    }

    static class LongListCollector
    implements ListCollector {
        private final LongArrayList values = new LongArrayList();

        public LongListCollector(long[] p_251409_) {
            this.values.addElements(0, p_251409_);
        }

        @Override
        public ListCollector accept(Tag p_252167_) {
            if (p_252167_ instanceof LongTag) {
                LongTag $$1 = (LongTag)p_252167_;
                this.values.add($$1.longValue());
                return this;
            }
            return new GenericListCollector(this.values).accept(p_252167_);
        }

        @Override
        public Tag result() {
            return new LongArrayTag(this.values.toLongArray());
        }
    }

    static interface ListCollector {
        public ListCollector accept(Tag var1);

        default public ListCollector acceptAll(Iterable<Tag> p_249781_) {
            ListCollector $$1 = this;
            for (Tag $$2 : p_249781_) {
                $$1 = $$1.accept($$2);
            }
            return $$1;
        }

        default public ListCollector acceptAll(Stream<Tag> p_249876_) {
            return this.acceptAll(p_249876_::iterator);
        }

        public Tag result();
    }
}

