/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.util.parsing.packrat.DelayedException;
import net.minecraft.util.parsing.packrat.ParseState;
import net.minecraft.util.parsing.packrat.SuggestionSupplier;

public class SnbtOperations {
    static final DelayedException<CommandSyntaxException> ERROR_EXPECTED_STRING_UUID = DelayedException.create(new SimpleCommandExceptionType((Message)Component.translatable("snbt.parser.expected_string_uuid")));
    static final DelayedException<CommandSyntaxException> ERROR_EXPECTED_NUMBER_OR_BOOLEAN = DelayedException.create(new SimpleCommandExceptionType((Message)Component.translatable("snbt.parser.expected_number_or_boolean")));
    public static final String BUILTIN_TRUE = "true";
    public static final String BUILTIN_FALSE = "false";
    public static final Map<BuiltinKey, BuiltinOperation> BUILTIN_OPERATIONS = Map.of(new BuiltinKey("bool", 1), new BuiltinOperation(){

        @Override
        public <T> T run(DynamicOps<T> p_411055_, List<T> p_411088_, ParseState<StringReader> p_411086_) {
            Boolean $$3 = 1.convert(p_411055_, p_411088_.getFirst());
            if ($$3 == null) {
                p_411086_.errorCollector().store(p_411086_.mark(), ERROR_EXPECTED_NUMBER_OR_BOOLEAN);
                return null;
            }
            return (T)p_411055_.createBoolean($$3.booleanValue());
        }

        @Nullable
        private static <T> Boolean convert(DynamicOps<T> p_411075_, T p_411094_) {
            Optional $$2 = p_411075_.getBooleanValue(p_411094_).result();
            if ($$2.isPresent()) {
                return (Boolean)$$2.get();
            }
            Optional $$3 = p_411075_.getNumberValue(p_411094_).result();
            if ($$3.isPresent()) {
                return ((Number)$$3.get()).doubleValue() != 0.0;
            }
            return null;
        }
    }, new BuiltinKey("uuid", 1), new BuiltinOperation(){

        /*
         * WARNING - void declaration
         */
        @Override
        public <T> T run(DynamicOps<T> p_411071_, List<T> p_411073_, ParseState<StringReader> p_411067_) {
            void $$6;
            Optional $$3 = p_411071_.getStringValue(p_411073_.getFirst()).result();
            if ($$3.isEmpty()) {
                p_411067_.errorCollector().store(p_411067_.mark(), ERROR_EXPECTED_STRING_UUID);
                return null;
            }
            try {
                UUID $$4 = UUID.fromString((String)$$3.get());
            }
            catch (IllegalArgumentException $$5) {
                p_411067_.errorCollector().store(p_411067_.mark(), ERROR_EXPECTED_STRING_UUID);
                return null;
            }
            return (T)p_411071_.createIntList(IntStream.of(UUIDUtil.uuidToIntArray((UUID)$$6)));
        }
    });
    public static final SuggestionSupplier<StringReader> BUILTIN_IDS = new SuggestionSupplier<StringReader>(){
        private final Set<String> keys = Stream.concat(Stream.of("false", "true"), BUILTIN_OPERATIONS.keySet().stream().map(BuiltinKey::id)).collect(Collectors.toSet());

        @Override
        public Stream<String> possibleValues(ParseState<StringReader> p_411084_) {
            return this.keys.stream();
        }
    };

    public record BuiltinKey(String id, int argCount) {
        @Override
        public String toString() {
            return this.id + "/" + this.argCount;
        }
    }

    public static interface BuiltinOperation {
        @Nullable
        public <T> T run(DynamicOps<T> var1, List<T> var2, ParseState<StringReader> var3);
    }
}

