/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.primitives.Ints;
import com.mojang.serialization.Codec;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.MessageSignatureCache;
import net.minecraft.util.SignatureUpdater;

public record LastSeenMessages(List<MessageSignature> entries) {
    public static final Codec<LastSeenMessages> CODEC = MessageSignature.CODEC.listOf().xmap(LastSeenMessages::new, LastSeenMessages::entries);
    public static LastSeenMessages EMPTY = new LastSeenMessages(List.of());
    public static final int LAST_SEEN_MESSAGES_MAX_LENGTH = 20;

    public void updateSignature(SignatureUpdater.Output p_251665_) throws SignatureException {
        p_251665_.update(Ints.toByteArray((int)this.entries.size()));
        for (MessageSignature $$1 : this.entries) {
            p_251665_.update($$1.bytes());
        }
    }

    public Packed pack(MessageSignatureCache p_253961_) {
        return new Packed(this.entries.stream().map(p_253457_ -> p_253457_.pack(p_253961_)).toList());
    }

    public byte computeChecksum() {
        int $$0 = 1;
        for (MessageSignature $$1 : this.entries) {
            $$0 = 31 * $$0 + $$1.checksum();
        }
        byte $$2 = (byte)$$0;
        return $$2 == 0 ? (byte)1 : $$2;
    }

    public record Packed(List<MessageSignature.Packed> entries) {
        public static final Packed EMPTY = new Packed(List.of());

        public Packed(FriendlyByteBuf p_249757_) {
            this(p_249757_.readCollection(FriendlyByteBuf.limitValue(ArrayList::new, 20), MessageSignature.Packed::read));
        }

        public void write(FriendlyByteBuf p_250725_) {
            p_250725_.writeCollection(this.entries, MessageSignature.Packed::write);
        }

        public Optional<LastSeenMessages> unpack(MessageSignatureCache p_253745_) {
            ArrayList<MessageSignature> $$1 = new ArrayList<MessageSignature>(this.entries.size());
            for (MessageSignature.Packed $$2 : this.entries) {
                Optional<MessageSignature> $$3 = $$2.unpack(p_253745_);
                if ($$3.isEmpty()) {
                    return Optional.empty();
                }
                $$1.add($$3.get());
            }
            return Optional.of(new LastSeenMessages($$1));
        }
    }

    public record Update(int offset, BitSet acknowledged, byte checksum) {
        public static final byte IGNORE_CHECKSUM = 0;

        public Update(FriendlyByteBuf p_242184_) {
            this(p_242184_.readVarInt(), p_242184_.readFixedBitSet(20), p_242184_.readByte());
        }

        public void write(FriendlyByteBuf p_242221_) {
            p_242221_.writeVarInt(this.offset);
            p_242221_.writeFixedBitSet(this.acknowledged, 20);
            p_242221_.writeByte(this.checksum);
        }

        public boolean verifyChecksum(LastSeenMessages p_412643_) {
            return this.checksum == 0 || this.checksum == p_412643_.computeChecksum();
        }
    }
}

