/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.mojang.logging.LogUtils;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.util.SignatureValidator;
import org.slf4j.Logger;

@FunctionalInterface
public interface SignedMessageValidator {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final SignedMessageValidator ACCEPT_UNSIGNED = PlayerChatMessage::removeSignature;
    public static final SignedMessageValidator REJECT_ALL = p_314910_ -> {
        LOGGER.error("Received chat message from {}, but they have no chat session initialized and secure chat is enforced", (Object)p_314910_.sender());
        return null;
    };

    @Nullable
    public PlayerChatMessage updateAndValidate(PlayerChatMessage var1);

    public static class KeyBased
    implements SignedMessageValidator {
        private final SignatureValidator validator;
        private final BooleanSupplier expired;
        @Nullable
        private PlayerChatMessage lastMessage;
        private boolean isChainValid = true;

        public KeyBased(SignatureValidator p_241517_, BooleanSupplier p_298457_) {
            this.validator = p_241517_;
            this.expired = p_298457_;
        }

        private boolean validateChain(PlayerChatMessage p_250412_) {
            if (p_250412_.equals(this.lastMessage)) {
                return true;
            }
            if (this.lastMessage != null && !p_250412_.link().isDescendantOf(this.lastMessage.link())) {
                LOGGER.error("Received out-of-order chat message from {}: expected index > {} for session {}, but was {} for session {}", new Object[]{p_250412_.sender(), this.lastMessage.link().index(), this.lastMessage.link().sessionId(), p_250412_.link().index(), p_250412_.link().sessionId()});
                return false;
            }
            return true;
        }

        private boolean validate(PlayerChatMessage p_298939_) {
            if (this.expired.getAsBoolean()) {
                LOGGER.error("Received message with expired profile public key from {} with session {}", (Object)p_298939_.sender(), (Object)p_298939_.link().sessionId());
                return false;
            }
            if (!p_298939_.verify(this.validator)) {
                LOGGER.error("Received message with invalid signature (is the session wrong, or signature cache out of sync?): {}", (Object)PlayerChatMessage.describeSigned(p_298939_));
                return false;
            }
            return this.validateChain(p_298939_);
        }

        @Override
        @Nullable
        public PlayerChatMessage updateAndValidate(PlayerChatMessage p_251182_) {
            boolean bl = this.isChainValid = this.isChainValid && this.validate(p_251182_);
            if (!this.isChainValid) {
                return null;
            }
            this.lastMessage = p_251182_;
            return p_251182_;
        }
    }
}

