/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.codec;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.network.VarInt;
import net.minecraft.network.codec.StreamCodec;

public class IdDispatchCodec<B extends ByteBuf, V, T>
implements StreamCodec<B, V> {
    private static final int UNKNOWN_TYPE = -1;
    private final Function<V, ? extends T> typeGetter;
    private final List<Entry<B, V, T>> byId;
    private final Object2IntMap<T> toId;

    IdDispatchCodec(Function<V, ? extends T> p_320468_, List<Entry<B, V, T>> p_320536_, Object2IntMap<T> p_320597_) {
        this.typeGetter = p_320468_;
        this.byId = p_320536_;
        this.toId = p_320597_;
    }

    @Override
    public V decode(B p_320374_) {
        int $$1 = VarInt.read(p_320374_);
        if ($$1 < 0 || $$1 >= this.byId.size()) {
            throw new DecoderException("Received unknown packet id " + $$1);
        }
        Entry<B, V, T> $$2 = this.byId.get($$1);
        try {
            return (V)$$2.serializer.decode(p_320374_);
        }
        catch (Exception $$3) {
            if ($$3 instanceof DontDecorateException) {
                throw $$3;
            }
            throw new DecoderException("Failed to decode packet '" + String.valueOf($$2.type) + "'", (Throwable)$$3);
        }
    }

    @Override
    public void encode(B p_319955_, V p_320138_) {
        T $$2 = this.typeGetter.apply(p_320138_);
        int $$3 = this.toId.getOrDefault($$2, -1);
        if ($$3 == -1) {
            throw new EncoderException("Sending unknown packet '" + String.valueOf($$2) + "'");
        }
        VarInt.write(p_319955_, $$3);
        Entry<B, V, T> $$4 = this.byId.get($$3);
        try {
            StreamCodec $$5 = $$4.serializer;
            $$5.encode(p_319955_, p_320138_);
        }
        catch (Exception $$6) {
            if ($$6 instanceof DontDecorateException) {
                throw $$6;
            }
            throw new EncoderException("Failed to encode packet '" + String.valueOf($$2) + "'", (Throwable)$$6);
        }
    }

    public static <B extends ByteBuf, V, T> Builder<B, V, T> builder(Function<V, ? extends T> p_319781_) {
        return new Builder(p_319781_);
    }

    @Override
    public /* synthetic */ void encode(Object object, Object object2) {
        this.encode((B)((ByteBuf)object), (V)object2);
    }

    @Override
    public /* synthetic */ Object decode(Object object) {
        return this.decode((B)((ByteBuf)object));
    }

    record Entry<B, V, T>(StreamCodec<? super B, ? extends V> serializer, T type) {
    }

    public static interface DontDecorateException {
    }

    public static class Builder<B extends ByteBuf, V, T> {
        private final List<Entry<B, V, T>> entries = new ArrayList<Entry<B, V, T>>();
        private final Function<V, ? extends T> typeGetter;

        Builder(Function<V, ? extends T> p_320009_) {
            this.typeGetter = p_320009_;
        }

        public Builder<B, V, T> add(T p_320423_, StreamCodec<? super B, ? extends V> p_320781_) {
            this.entries.add(new Entry<B, V, T>(p_320781_, p_320423_));
            return this;
        }

        public IdDispatchCodec<B, V, T> build() {
            Object2IntOpenHashMap $$0 = new Object2IntOpenHashMap();
            $$0.defaultReturnValue(-2);
            for (Entry<B, V, T> $$1 : this.entries) {
                int $$2 = $$0.size();
                int $$3 = $$0.putIfAbsent($$1.type, $$2);
                if ($$3 == -2) continue;
                throw new IllegalStateException("Duplicate registration for type " + String.valueOf($$1.type));
            }
            return new IdDispatchCodec<B, V, T>(this.typeGetter, List.copyOf(this.entries), $$0);
        }
    }
}

