/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.recipebook;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.recipebook.PlaceRecipeHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;

public class ServerPlaceRecipe<R extends Recipe<?>> {
    private static final int ITEM_NOT_FOUND = -1;
    private final Inventory inventory;
    private final CraftingMenuAccess<R> menu;
    private final boolean useMaxItems;
    private final int gridWidth;
    private final int gridHeight;
    private final List<Slot> inputGridSlots;
    private final List<Slot> slotsToClear;

    public static <I extends RecipeInput, R extends Recipe<I>> RecipeBookMenu.PostPlaceAction placeRecipe(CraftingMenuAccess<R> p_361341_, int p_361512_, int p_362929_, List<Slot> p_364825_, List<Slot> p_364661_, Inventory p_364618_, RecipeHolder<R> p_363024_, boolean p_360549_, boolean p_361381_) {
        ServerPlaceRecipe<R> $$9 = new ServerPlaceRecipe<R>(p_361341_, p_364618_, p_360549_, p_361512_, p_362929_, p_364825_, p_364661_);
        if (!p_361381_ && !$$9.testClearGrid()) {
            return RecipeBookMenu.PostPlaceAction.NOTHING;
        }
        StackedItemContents $$10 = new StackedItemContents();
        p_364618_.fillStackedContents($$10);
        p_361341_.fillCraftSlotsStackedContents($$10);
        return $$9.tryPlaceRecipe(p_363024_, $$10);
    }

    private ServerPlaceRecipe(CraftingMenuAccess<R> p_363275_, Inventory p_361371_, boolean p_364633_, int p_362980_, int p_361285_, List<Slot> p_364759_, List<Slot> p_361301_) {
        this.menu = p_363275_;
        this.inventory = p_361371_;
        this.useMaxItems = p_364633_;
        this.gridWidth = p_362980_;
        this.gridHeight = p_361285_;
        this.inputGridSlots = p_364759_;
        this.slotsToClear = p_361301_;
    }

    private RecipeBookMenu.PostPlaceAction tryPlaceRecipe(RecipeHolder<R> p_362187_, StackedItemContents p_361415_) {
        if (p_361415_.canCraft((Recipe<?>)p_362187_.value(), null)) {
            this.placeRecipe(p_362187_, p_361415_);
            this.inventory.setChanged();
            return RecipeBookMenu.PostPlaceAction.NOTHING;
        }
        this.clearGrid();
        this.inventory.setChanged();
        return RecipeBookMenu.PostPlaceAction.PLACE_GHOST_RECIPE;
    }

    private void clearGrid() {
        for (Slot $$0 : this.slotsToClear) {
            ItemStack $$1 = $$0.getItem().copy();
            this.inventory.placeItemBackInInventory($$1, false);
            $$0.set($$1);
        }
        this.menu.clearCraftingContent();
    }

    private void placeRecipe(RecipeHolder<R> p_364551_, StackedItemContents p_362416_) {
        boolean $$2 = this.menu.recipeMatches(p_364551_);
        int $$3 = p_362416_.getBiggestCraftableStack((Recipe<?>)p_364551_.value(), null);
        if ($$2) {
            for (Slot $$4 : this.inputGridSlots) {
                ItemStack $$5 = $$4.getItem();
                if ($$5.isEmpty() || Math.min($$3, $$5.getMaxStackSize()) >= $$5.getCount() + 1) continue;
                return;
            }
        }
        int $$6 = this.calculateAmountToCraft($$3, $$2);
        ArrayList<Holder<Item>> $$7 = new ArrayList<Holder<Item>>();
        if (!p_362416_.canCraft((Recipe<?>)p_364551_.value(), $$6, $$7::add)) {
            return;
        }
        int $$8 = ServerPlaceRecipe.clampToMaxStackSize($$6, $$7);
        if ($$8 != $$6) {
            $$7.clear();
            if (!p_362416_.canCraft((Recipe<?>)p_364551_.value(), $$8, $$7::add)) {
                return;
            }
        }
        this.clearGrid();
        PlaceRecipeHelper.placeRecipe(this.gridWidth, this.gridHeight, p_364551_.value(), p_364551_.value().placementInfo().slotsToIngredientIndex(), (p_389375_, p_389376_, p_389377_, p_389378_) -> {
            if (p_389375_ == -1) {
                return;
            }
            Slot $$6 = this.inputGridSlots.get(p_389376_);
            Holder $$7 = (Holder)$$7.get((int)p_389375_);
            int $$8 = $$8;
            while ($$8 > 0) {
                if (($$8 = this.moveItemToGrid($$6, $$7, $$8)) != -1) continue;
                return;
            }
        });
    }

    private static int clampToMaxStackSize(int p_389711_, List<Holder<Item>> p_389467_) {
        for (Holder<Item> $$2 : p_389467_) {
            p_389711_ = Math.min(p_389711_, $$2.value().getDefaultMaxStackSize());
        }
        return p_389711_;
    }

    private int calculateAmountToCraft(int p_364430_, boolean p_362919_) {
        if (this.useMaxItems) {
            return p_364430_;
        }
        if (p_362919_) {
            int $$2 = Integer.MAX_VALUE;
            for (Slot $$3 : this.inputGridSlots) {
                ItemStack $$4 = $$3.getItem();
                if ($$4.isEmpty() || $$2 <= $$4.getCount()) continue;
                $$2 = $$4.getCount();
            }
            if ($$2 != Integer.MAX_VALUE) {
                ++$$2;
            }
            return $$2;
        }
        return 1;
    }

    private int moveItemToGrid(Slot p_135439_, Holder<Item> p_360762_, int p_346157_) {
        ItemStack $$7;
        ItemStack $$3 = p_135439_.getItem();
        int $$4 = this.inventory.findSlotMatchingCraftingIngredient(p_360762_, $$3);
        if ($$4 == -1) {
            return -1;
        }
        ItemStack $$5 = this.inventory.getItem($$4);
        if (p_346157_ < $$5.getCount()) {
            ItemStack $$6 = this.inventory.removeItem($$4, p_346157_);
        } else {
            $$7 = this.inventory.removeItemNoUpdate($$4);
        }
        int $$8 = $$7.getCount();
        if ($$3.isEmpty()) {
            p_135439_.set($$7);
        } else {
            $$3.grow($$8);
        }
        return p_346157_ - $$8;
    }

    private boolean testClearGrid() {
        ArrayList $$0 = Lists.newArrayList();
        int $$1 = this.getAmountOfFreeSlotsInInventory();
        for (Slot $$2 : this.inputGridSlots) {
            ItemStack $$3 = $$2.getItem().copy();
            if ($$3.isEmpty()) continue;
            int $$4 = this.inventory.getSlotWithRemainingSpace($$3);
            if ($$4 == -1 && $$0.size() <= $$1) {
                for (ItemStack $$5 : $$0) {
                    if (!ItemStack.isSameItem($$5, $$3) || $$5.getCount() == $$5.getMaxStackSize() || $$5.getCount() + $$3.getCount() > $$5.getMaxStackSize()) continue;
                    $$5.grow($$3.getCount());
                    $$3.setCount(0);
                    break;
                }
                if ($$3.isEmpty()) continue;
                if ($$0.size() < $$1) {
                    $$0.add($$3);
                    continue;
                }
                return false;
            }
            if ($$4 != -1) continue;
            return false;
        }
        return true;
    }

    private int getAmountOfFreeSlotsInInventory() {
        int $$0 = 0;
        for (ItemStack $$1 : this.inventory.getNonEquipmentItems()) {
            if (!$$1.isEmpty()) continue;
            ++$$0;
        }
        return $$0;
    }

    public static interface CraftingMenuAccess<T extends Recipe<?>> {
        public void fillCraftSlotsStackedContents(StackedItemContents var1);

        public void clearCraftingContent();

        public boolean recipeMatches(RecipeHolder<T> var1);
    }
}

