/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySynchronization;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.gametest.framework.GameTestInstance;
import net.minecraft.gametest.framework.TestEnvironmentDefinition;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ChatType;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.repository.KnownPack;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.tags.TagLoader;
import net.minecraft.tags.TagNetworkSerialization;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.ChickenVariant;
import net.minecraft.world.entity.animal.CowVariant;
import net.minecraft.world.entity.animal.PigVariant;
import net.minecraft.world.entity.animal.frog.FrogVariant;
import net.minecraft.world.entity.animal.wolf.WolfSoundVariant;
import net.minecraft.world.entity.animal.wolf.WolfVariant;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.providers.EnchantmentProvider;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import net.minecraft.world.item.equipment.trim.TrimPattern;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerConfig;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorPreset;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import org.slf4j.Logger;

public class RegistryDataLoader {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Comparator<ResourceKey<?>> ERROR_KEY_COMPARATOR = Comparator.comparing(ResourceKey::registry).thenComparing(ResourceKey::location);
    private static final RegistrationInfo NETWORK_REGISTRATION_INFO = new RegistrationInfo(Optional.empty(), Lifecycle.experimental());
    private static final Function<Optional<KnownPack>, RegistrationInfo> REGISTRATION_INFO_CACHE = Util.memoize(p_325559_ -> {
        Lifecycle $$1 = p_325559_.map(KnownPack::isVanilla).map(p_325560_ -> Lifecycle.stable()).orElse(Lifecycle.experimental());
        return new RegistrationInfo((Optional<KnownPack>)p_325559_, $$1);
    });
    public static final List<RegistryData<?>> WORLDGEN_REGISTRIES = List.of(new RegistryData<DimensionType>(Registries.DIMENSION_TYPE, DimensionType.DIRECT_CODEC), new RegistryData<Biome>(Registries.BIOME, Biome.DIRECT_CODEC), new RegistryData<ChatType>(Registries.CHAT_TYPE, ChatType.DIRECT_CODEC), new RegistryData(Registries.CONFIGURED_CARVER, ConfiguredWorldCarver.DIRECT_CODEC), new RegistryData(Registries.CONFIGURED_FEATURE, ConfiguredFeature.DIRECT_CODEC), new RegistryData<PlacedFeature>(Registries.PLACED_FEATURE, PlacedFeature.DIRECT_CODEC), new RegistryData<Structure>(Registries.STRUCTURE, Structure.DIRECT_CODEC), new RegistryData<StructureSet>(Registries.STRUCTURE_SET, StructureSet.DIRECT_CODEC), new RegistryData<StructureProcessorList>(Registries.PROCESSOR_LIST, StructureProcessorType.DIRECT_CODEC), new RegistryData<StructureTemplatePool>(Registries.TEMPLATE_POOL, StructureTemplatePool.DIRECT_CODEC), new RegistryData<NoiseGeneratorSettings>(Registries.NOISE_SETTINGS, NoiseGeneratorSettings.DIRECT_CODEC), new RegistryData<NormalNoise.NoiseParameters>(Registries.NOISE, NormalNoise.NoiseParameters.DIRECT_CODEC), new RegistryData<DensityFunction>(Registries.DENSITY_FUNCTION, DensityFunction.DIRECT_CODEC), new RegistryData<WorldPreset>(Registries.WORLD_PRESET, WorldPreset.DIRECT_CODEC), new RegistryData<FlatLevelGeneratorPreset>(Registries.FLAT_LEVEL_GENERATOR_PRESET, FlatLevelGeneratorPreset.DIRECT_CODEC), new RegistryData<TrimPattern>(Registries.TRIM_PATTERN, TrimPattern.DIRECT_CODEC), new RegistryData<TrimMaterial>(Registries.TRIM_MATERIAL, TrimMaterial.DIRECT_CODEC), new RegistryData<TrialSpawnerConfig>(Registries.TRIAL_SPAWNER_CONFIG, TrialSpawnerConfig.DIRECT_CODEC), new RegistryData<WolfVariant>(Registries.WOLF_VARIANT, WolfVariant.DIRECT_CODEC, true), new RegistryData<WolfSoundVariant>(Registries.WOLF_SOUND_VARIANT, WolfSoundVariant.DIRECT_CODEC, true), new RegistryData<PigVariant>(Registries.PIG_VARIANT, PigVariant.DIRECT_CODEC, true), new RegistryData<FrogVariant>(Registries.FROG_VARIANT, FrogVariant.DIRECT_CODEC, true), new RegistryData<CatVariant>(Registries.CAT_VARIANT, CatVariant.DIRECT_CODEC, true), new RegistryData<CowVariant>(Registries.COW_VARIANT, CowVariant.DIRECT_CODEC, true), new RegistryData<ChickenVariant>(Registries.CHICKEN_VARIANT, ChickenVariant.DIRECT_CODEC, true), new RegistryData<PaintingVariant>(Registries.PAINTING_VARIANT, PaintingVariant.DIRECT_CODEC, true), new RegistryData<DamageType>(Registries.DAMAGE_TYPE, DamageType.DIRECT_CODEC), new RegistryData<MultiNoiseBiomeSourceParameterList>(Registries.MULTI_NOISE_BIOME_SOURCE_PARAMETER_LIST, MultiNoiseBiomeSourceParameterList.DIRECT_CODEC), new RegistryData<BannerPattern>(Registries.BANNER_PATTERN, BannerPattern.DIRECT_CODEC), new RegistryData<Enchantment>(Registries.ENCHANTMENT, Enchantment.DIRECT_CODEC), new RegistryData<EnchantmentProvider>(Registries.ENCHANTMENT_PROVIDER, EnchantmentProvider.DIRECT_CODEC), new RegistryData<JukeboxSong>(Registries.JUKEBOX_SONG, JukeboxSong.DIRECT_CODEC), new RegistryData<Instrument>(Registries.INSTRUMENT, Instrument.DIRECT_CODEC), new RegistryData<TestEnvironmentDefinition>(Registries.TEST_ENVIRONMENT, TestEnvironmentDefinition.DIRECT_CODEC), new RegistryData<GameTestInstance>(Registries.TEST_INSTANCE, GameTestInstance.DIRECT_CODEC));
    public static final List<RegistryData<?>> DIMENSION_REGISTRIES = List.of(new RegistryData<LevelStem>(Registries.LEVEL_STEM, LevelStem.CODEC));
    public static final List<RegistryData<?>> SYNCHRONIZED_REGISTRIES = List.of(new RegistryData<Biome>(Registries.BIOME, Biome.NETWORK_CODEC), new RegistryData<ChatType>(Registries.CHAT_TYPE, ChatType.DIRECT_CODEC), new RegistryData<TrimPattern>(Registries.TRIM_PATTERN, TrimPattern.DIRECT_CODEC), new RegistryData<TrimMaterial>(Registries.TRIM_MATERIAL, TrimMaterial.DIRECT_CODEC), new RegistryData<WolfVariant>(Registries.WOLF_VARIANT, WolfVariant.NETWORK_CODEC, true), new RegistryData<WolfSoundVariant>(Registries.WOLF_SOUND_VARIANT, WolfSoundVariant.NETWORK_CODEC, true), new RegistryData<PigVariant>(Registries.PIG_VARIANT, PigVariant.NETWORK_CODEC, true), new RegistryData<FrogVariant>(Registries.FROG_VARIANT, FrogVariant.NETWORK_CODEC, true), new RegistryData<CatVariant>(Registries.CAT_VARIANT, CatVariant.NETWORK_CODEC, true), new RegistryData<CowVariant>(Registries.COW_VARIANT, CowVariant.NETWORK_CODEC, true), new RegistryData<ChickenVariant>(Registries.CHICKEN_VARIANT, ChickenVariant.NETWORK_CODEC, true), new RegistryData<PaintingVariant>(Registries.PAINTING_VARIANT, PaintingVariant.DIRECT_CODEC, true), new RegistryData<DimensionType>(Registries.DIMENSION_TYPE, DimensionType.DIRECT_CODEC), new RegistryData<DamageType>(Registries.DAMAGE_TYPE, DamageType.DIRECT_CODEC), new RegistryData<BannerPattern>(Registries.BANNER_PATTERN, BannerPattern.DIRECT_CODEC), new RegistryData<Enchantment>(Registries.ENCHANTMENT, Enchantment.DIRECT_CODEC), new RegistryData<JukeboxSong>(Registries.JUKEBOX_SONG, JukeboxSong.DIRECT_CODEC), new RegistryData<Instrument>(Registries.INSTRUMENT, Instrument.DIRECT_CODEC), new RegistryData<TestEnvironmentDefinition>(Registries.TEST_ENVIRONMENT, TestEnvironmentDefinition.DIRECT_CODEC), new RegistryData<GameTestInstance>(Registries.TEST_INSTANCE, GameTestInstance.DIRECT_CODEC));

    public static RegistryAccess.Frozen load(ResourceManager p_364116_, List<HolderLookup.RegistryLookup<?>> p_321716_, List<RegistryData<?>> p_365382_) {
        return RegistryDataLoader.load((Loader<?> p_321412_, RegistryOps.RegistryInfoLookup p_321413_) -> p_321412_.loadFromResources(p_364116_, p_321413_), p_321716_, p_365382_);
    }

    public static RegistryAccess.Frozen load(Map<ResourceKey<? extends Registry<?>>, NetworkedRegistryData> p_364449_, ResourceProvider p_360464_, List<HolderLookup.RegistryLookup<?>> p_250344_, List<RegistryData<?>> p_363651_) {
        return RegistryDataLoader.load((Loader<?> p_325557_, RegistryOps.RegistryInfoLookup p_325558_) -> p_325557_.loadFromNetwork(p_364449_, p_360464_, p_325558_), p_250344_, p_363651_);
    }

    private static RegistryAccess.Frozen load(LoadingFunction p_321713_, List<HolderLookup.RegistryLookup<?>> p_321856_, List<RegistryData<?>> p_364355_) {
        HashMap $$3 = new HashMap();
        List<Loader<?>> $$4 = p_364355_.stream().map(p_321410_ -> p_321410_.create(Lifecycle.stable(), $$3)).collect(Collectors.toUnmodifiableList());
        RegistryOps.RegistryInfoLookup $$5 = RegistryDataLoader.createContext(p_321856_, $$4);
        $$4.forEach(p_321416_ -> p_321713_.apply((Loader<?>)p_321416_, $$5));
        $$4.forEach(p_396495_ -> {
            WritableRegistry $$2 = p_396495_.registry();
            try {
                $$2.freeze();
            }
            catch (Exception $$3) {
                $$3.put($$2.key(), $$3);
            }
            if (p_396495_.data.requiredNonEmpty && $$2.size() == 0) {
                $$3.put($$2.key(), new IllegalStateException("Registry must be non-empty: " + String.valueOf($$2.key().location())));
            }
        });
        if (!$$3.isEmpty()) {
            throw RegistryDataLoader.logErrors($$3);
        }
        return new RegistryAccess.ImmutableRegistryAccess($$4.stream().map(Loader::registry).toList()).freeze();
    }

    private static RegistryOps.RegistryInfoLookup createContext(List<HolderLookup.RegistryLookup<?>> p_255821_, List<Loader<?>> p_360285_) {
        final HashMap $$2 = new HashMap();
        p_255821_.forEach(p_359481_ -> $$2.put(p_359481_.key(), RegistryDataLoader.createInfoForContextRegistry(p_359481_)));
        p_360285_.forEach(p_367838_ -> $$2.put(p_367838_.registry.key(), RegistryDataLoader.createInfoForNewRegistry(p_367838_.registry)));
        return new RegistryOps.RegistryInfoLookup(){

            @Override
            public <T> Optional<RegistryOps.RegistryInfo<T>> lookup(ResourceKey<? extends Registry<? extends T>> p_256014_) {
                return Optional.ofNullable((RegistryOps.RegistryInfo)$$2.get(p_256014_));
            }
        };
    }

    private static <T> RegistryOps.RegistryInfo<T> createInfoForNewRegistry(WritableRegistry<T> p_256020_) {
        return new RegistryOps.RegistryInfo<T>(p_256020_, p_256020_.createRegistrationLookup(), p_256020_.registryLifecycle());
    }

    private static <T> RegistryOps.RegistryInfo<T> createInfoForContextRegistry(HolderLookup.RegistryLookup<T> p_364499_) {
        return new RegistryOps.RegistryInfo<T>(p_364499_, p_364499_, p_364499_.registryLifecycle());
    }

    private static ReportedException logErrors(Map<ResourceKey<?>, Exception> p_366903_) {
        RegistryDataLoader.printFullDetailsToLog(p_366903_);
        return RegistryDataLoader.createReportWithBriefInfo(p_366903_);
    }

    private static void printFullDetailsToLog(Map<ResourceKey<?>, Exception> p_252325_) {
        StringWriter $$1 = new StringWriter();
        PrintWriter $$2 = new PrintWriter($$1);
        Map<ResourceLocation, Map<ResourceLocation, Exception>> $$3 = p_252325_.entrySet().stream().collect(Collectors.groupingBy(p_249353_ -> ((ResourceKey)p_249353_.getKey()).registry(), Collectors.toMap(p_251444_ -> ((ResourceKey)p_251444_.getKey()).location(), Map.Entry::getValue)));
        $$3.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(p_249838_ -> {
            $$2.printf("> Errors in registry %s:%n", p_249838_.getKey());
            ((Map)p_249838_.getValue()).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(p_250688_ -> {
                $$2.printf(">> Errors in element %s:%n", p_250688_.getKey());
                ((Exception)p_250688_.getValue()).printStackTrace($$2);
            });
        });
        $$2.flush();
        LOGGER.error("Registry loading errors:\n{}", (Object)$$1);
    }

    private static ReportedException createReportWithBriefInfo(Map<ResourceKey<?>, Exception> p_366880_) {
        CrashReport $$1 = CrashReport.forThrowable(new IllegalStateException("Failed to load registries due to errors"), "Registry Loading");
        CrashReportCategory $$2 = $$1.addCategory("Loading info");
        $$2.setDetail("Errors", () -> {
            StringBuilder $$1 = new StringBuilder();
            p_366880_.entrySet().stream().sorted(Map.Entry.comparingByKey(ERROR_KEY_COMPARATOR)).forEach(p_366373_ -> $$1.append("\n\t\t").append(((ResourceKey)p_366373_.getKey()).registry()).append("/").append(((ResourceKey)p_366373_.getKey()).location()).append(": ").append(((Exception)p_366373_.getValue()).getMessage()));
            return $$1.toString();
        });
        return new ReportedException($$1);
    }

    private static <E> void loadElementFromResource(WritableRegistry<E> p_326195_, Decoder<E> p_326476_, RegistryOps<JsonElement> p_325932_, ResourceKey<E> p_326054_, Resource p_326141_, RegistrationInfo p_326033_) throws IOException {
        try (BufferedReader $$6 = p_326141_.openAsReader();){
            JsonElement $$7 = JsonParser.parseReader((Reader)$$6);
            DataResult $$8 = p_326476_.parse(p_325932_, (Object)$$7);
            Object $$9 = $$8.getOrThrow();
            p_326195_.register(p_326054_, $$9, p_326033_);
        }
    }

    static <E> void loadContentsFromManager(ResourceManager p_321535_, RegistryOps.RegistryInfoLookup p_321612_, WritableRegistry<E> p_321557_, Decoder<E> p_321820_, Map<ResourceKey<?>, Exception> p_321649_) {
        FileToIdConverter $$5 = FileToIdConverter.registry(p_321557_.key());
        RegistryOps<JsonElement> $$6 = RegistryOps.create(JsonOps.INSTANCE, p_321612_);
        for (Map.Entry<ResourceLocation, Resource> $$7 : $$5.listMatchingResources(p_321535_).entrySet()) {
            ResourceLocation $$8 = $$7.getKey();
            ResourceKey $$9 = ResourceKey.create(p_321557_.key(), $$5.fileToId($$8));
            Resource $$10 = $$7.getValue();
            RegistrationInfo $$11 = REGISTRATION_INFO_CACHE.apply($$10.knownPackInfo());
            try {
                RegistryDataLoader.loadElementFromResource(p_321557_, p_321820_, $$6, $$9, $$10, $$11);
            }
            catch (Exception $$12) {
                p_321649_.put($$9, new IllegalStateException(String.format(Locale.ROOT, "Failed to parse %s from pack %s", $$8, $$10.sourcePackId()), $$12));
            }
        }
        TagLoader.loadTagsForRegistry(p_321535_, p_321557_);
    }

    static <E> void loadContentsFromNetwork(Map<ResourceKey<? extends Registry<?>>, NetworkedRegistryData> p_321633_, ResourceProvider p_326020_, RegistryOps.RegistryInfoLookup p_321801_, WritableRegistry<E> p_321671_, Decoder<E> p_321718_, Map<ResourceKey<?>, Exception> p_321625_) {
        NetworkedRegistryData $$6 = p_321633_.get(p_321671_.key());
        if ($$6 == null) {
            return;
        }
        RegistryOps<Tag> $$7 = RegistryOps.create(NbtOps.INSTANCE, p_321801_);
        RegistryOps<JsonElement> $$8 = RegistryOps.create(JsonOps.INSTANCE, p_321801_);
        FileToIdConverter $$9 = FileToIdConverter.registry(p_321671_.key());
        for (RegistrySynchronization.PackedRegistryEntry $$10 : $$6.elements) {
            ResourceKey $$11 = ResourceKey.create(p_321671_.key(), $$10.id());
            Optional<Tag> $$12 = $$10.data();
            if ($$12.isPresent()) {
                try {
                    DataResult $$13 = p_321718_.parse($$7, (Object)$$12.get());
                    Object $$14 = $$13.getOrThrow();
                    p_321671_.register($$11, $$14, NETWORK_REGISTRATION_INFO);
                }
                catch (Exception $$15) {
                    p_321625_.put($$11, new IllegalStateException(String.format(Locale.ROOT, "Failed to parse value %s from server", $$12.get()), $$15));
                }
                continue;
            }
            ResourceLocation $$16 = $$9.idToFile($$10.id());
            try {
                Resource $$17 = p_326020_.getResourceOrThrow($$16);
                RegistryDataLoader.loadElementFromResource(p_321671_, p_321718_, $$8, $$11, $$17, NETWORK_REGISTRATION_INFO);
            }
            catch (Exception $$18) {
                p_321625_.put($$11, new IllegalStateException("Failed to parse local data", $$18));
            }
        }
        TagLoader.loadTagsFromNetwork($$6.tags, p_321671_);
    }

    @FunctionalInterface
    static interface LoadingFunction {
        public void apply(Loader<?> var1, RegistryOps.RegistryInfoLookup var2);
    }

    public record NetworkedRegistryData(List<RegistrySynchronization.PackedRegistryEntry> elements, TagNetworkSerialization.NetworkPayload tags) {
    }

    record Loader<T>(RegistryData<T> data, WritableRegistry<T> registry, Map<ResourceKey<?>, Exception> loadingErrors) {
        public void loadFromResources(ResourceManager p_321702_, RegistryOps.RegistryInfoLookup p_321840_) {
            RegistryDataLoader.loadContentsFromManager(p_321702_, p_321840_, this.registry, this.data.elementCodec, this.loadingErrors);
        }

        public void loadFromNetwork(Map<ResourceKey<? extends Registry<?>>, NetworkedRegistryData> p_321562_, ResourceProvider p_326419_, RegistryOps.RegistryInfoLookup p_321617_) {
            RegistryDataLoader.loadContentsFromNetwork(p_321562_, p_326419_, p_321617_, this.registry, this.data.elementCodec, this.loadingErrors);
        }
    }

    public record RegistryData<T>(ResourceKey<? extends Registry<T>> key, Codec<T> elementCodec, boolean requiredNonEmpty) {
        RegistryData(ResourceKey<? extends Registry<T>> p_251360_, Codec<T> p_248976_) {
            this(p_251360_, p_248976_, false);
        }

        Loader<T> create(Lifecycle p_251662_, Map<ResourceKey<?>, Exception> p_251565_) {
            MappedRegistry $$2 = new MappedRegistry(this.key, p_251662_);
            return new Loader(this, $$2, p_251565_);
        }

        public void runWithArguments(BiConsumer<ResourceKey<? extends Registry<T>>, Codec<T>> p_312899_) {
            p_312899_.accept(this.key, this.elementCodec);
        }
    }
}

