/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.TagLoader;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import org.slf4j.Logger;

public class ReloadableServerRegistries {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final RegistrationInfo DEFAULT_REGISTRATION_INFO = new RegistrationInfo(Optional.empty(), Lifecycle.experimental());

    public static CompletableFuture<LoadResult> reload(LayeredRegistryAccess<RegistryLayer> p_335950_, List<Registry.PendingTags<?>> p_363295_, ResourceManager p_335786_, Executor p_335516_) {
        List<HolderLookup.RegistryLookup<?>> $$4 = TagLoader.buildUpdatedLookups(p_335950_.getAccessForLoading(RegistryLayer.RELOADABLE), p_363295_);
        HolderLookup.Provider $$5 = HolderLookup.Provider.create($$4.stream());
        RegistryOps $$6 = $$5.createSerializationContext(JsonOps.INSTANCE);
        List<CompletableFuture> $$7 = LootDataType.values().map(p_359506_ -> ReloadableServerRegistries.scheduleRegistryLoad(p_359506_, $$6, p_335786_, p_335516_)).toList();
        CompletableFuture $$8 = Util.sequence($$7);
        return $$8.thenApplyAsync(p_359496_ -> ReloadableServerRegistries.createAndValidateFullContext(p_335950_, $$5, p_359496_), p_335516_);
    }

    private static <T> CompletableFuture<WritableRegistry<?>> scheduleRegistryLoad(LootDataType<T> p_335741_, RegistryOps<JsonElement> p_336173_, ResourceManager p_335893_, Executor p_336104_) {
        return CompletableFuture.supplyAsync(() -> {
            MappedRegistry $$3 = new MappedRegistry(p_335741_.registryKey(), Lifecycle.experimental());
            HashMap<ResourceLocation, Object> $$4 = new HashMap<ResourceLocation, Object>();
            SimpleJsonResourceReloadListener.scanDirectory(p_335893_, p_335741_.registryKey(), (DynamicOps<JsonElement>)p_336173_, p_335741_.codec(), $$4);
            $$4.forEach((p_335721_, p_335683_) -> $$3.register(ResourceKey.create(p_335741_.registryKey(), p_335721_), p_335683_, DEFAULT_REGISTRATION_INFO));
            TagLoader.loadTagsForRegistry(p_335893_, $$3);
            return $$3;
        }, p_336104_);
    }

    private static LoadResult createAndValidateFullContext(LayeredRegistryAccess<RegistryLayer> p_362306_, HolderLookup.Provider p_361687_, List<WritableRegistry<?>> p_361223_) {
        LayeredRegistryAccess<RegistryLayer> $$3 = ReloadableServerRegistries.createUpdatedRegistries(p_362306_, p_361223_);
        HolderLookup.Provider $$4 = ReloadableServerRegistries.concatenateLookups(p_361687_, $$3.getLayer(RegistryLayer.RELOADABLE));
        ReloadableServerRegistries.validateLootRegistries($$4);
        return new LoadResult($$3, $$4);
    }

    private static HolderLookup.Provider concatenateLookups(HolderLookup.Provider p_363853_, HolderLookup.Provider p_363956_) {
        return HolderLookup.Provider.create(Stream.concat(p_363853_.listRegistries(), p_363956_.listRegistries()));
    }

    private static void validateLootRegistries(HolderLookup.Provider p_363971_) {
        ProblemReporter.Collector $$1 = new ProblemReporter.Collector();
        ValidationContext $$2 = new ValidationContext($$1, LootContextParamSets.ALL_PARAMS, p_363971_);
        LootDataType.values().forEach(p_359499_ -> ReloadableServerRegistries.validateRegistry($$2, p_359499_, p_363971_));
        $$1.get().forEach((p_336001_, p_335424_) -> LOGGER.warn("Found loot table element validation problem in {}: {}", p_336001_, p_335424_));
    }

    private static LayeredRegistryAccess<RegistryLayer> createUpdatedRegistries(LayeredRegistryAccess<RegistryLayer> p_335434_, List<WritableRegistry<?>> p_336097_) {
        return p_335434_.replaceFrom(RegistryLayer.RELOADABLE, new RegistryAccess.ImmutableRegistryAccess(p_336097_).freeze());
    }

    private static <T> void validateRegistry(ValidationContext p_335565_, LootDataType<T> p_335997_, HolderLookup.Provider p_360819_) {
        HolderGetter $$3 = p_360819_.lookupOrThrow(p_335997_.registryKey());
        $$3.listElements().forEach(p_335842_ -> p_335997_.runValidation(p_335565_, p_335842_.key(), p_335842_.value()));
    }

    public record LoadResult(LayeredRegistryAccess<RegistryLayer> layers, HolderLookup.Provider lookupWithUpdatedTags) {
    }

    public static class Holder {
        private final HolderLookup.Provider registries;

        public Holder(HolderLookup.Provider p_361288_) {
            this.registries = p_361288_;
        }

        public HolderGetter.Provider lookup() {
            return this.registries;
        }

        public Collection<ResourceLocation> getKeys(ResourceKey<? extends Registry<?>> p_335695_) {
            return this.registries.lookupOrThrow(p_335695_).listElementIds().map(ResourceKey::location).toList();
        }

        public LootTable getLootTable(ResourceKey<LootTable> p_335504_) {
            return this.registries.lookup(Registries.LOOT_TABLE).flatMap(p_335799_ -> p_335799_.get(p_335504_)).map(net.minecraft.core.Holder::value).orElse(LootTable.EMPTY);
        }
    }
}

