/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.commands.arguments.NbtPathArgument;
import net.minecraft.commands.arguments.NbtTagArgument;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.PrimitiveTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.commands.data.BlockDataAccessor;
import net.minecraft.server.commands.data.DataAccessor;
import net.minecraft.server.commands.data.EntityDataAccessor;
import net.minecraft.server.commands.data.StorageDataAccessor;
import net.minecraft.util.Mth;

public class DataCommands {
    private static final SimpleCommandExceptionType ERROR_MERGE_UNCHANGED = new SimpleCommandExceptionType((Message)Component.translatable("commands.data.merge.failed"));
    private static final DynamicCommandExceptionType ERROR_GET_NOT_NUMBER = new DynamicCommandExceptionType(p_304320_ -> Component.translatableEscape("commands.data.get.invalid", p_304320_));
    private static final DynamicCommandExceptionType ERROR_GET_NON_EXISTENT = new DynamicCommandExceptionType(p_304315_ -> Component.translatableEscape("commands.data.get.unknown", p_304315_));
    private static final SimpleCommandExceptionType ERROR_MULTIPLE_TAGS = new SimpleCommandExceptionType((Message)Component.translatable("commands.data.get.multiple"));
    private static final DynamicCommandExceptionType ERROR_EXPECTED_OBJECT = new DynamicCommandExceptionType(p_304316_ -> Component.translatableEscape("commands.data.modify.expected_object", p_304316_));
    private static final DynamicCommandExceptionType ERROR_EXPECTED_VALUE = new DynamicCommandExceptionType(p_304317_ -> Component.translatableEscape("commands.data.modify.expected_value", p_304317_));
    private static final Dynamic2CommandExceptionType ERROR_INVALID_SUBSTRING = new Dynamic2CommandExceptionType((p_304318_, p_304319_) -> Component.translatableEscape("commands.data.modify.invalid_substring", p_304318_, p_304319_));
    public static final List<Function<String, DataProvider>> ALL_PROVIDERS = ImmutableList.of(EntityDataAccessor.PROVIDER, BlockDataAccessor.PROVIDER, StorageDataAccessor.PROVIDER);
    public static final List<DataProvider> TARGET_PROVIDERS = (List)ALL_PROVIDERS.stream().map(p_139450_ -> (DataProvider)p_139450_.apply("target")).collect(ImmutableList.toImmutableList());
    public static final List<DataProvider> SOURCE_PROVIDERS = (List)ALL_PROVIDERS.stream().map(p_139410_ -> (DataProvider)p_139410_.apply("source")).collect(ImmutableList.toImmutableList());

    public static void register(CommandDispatcher<CommandSourceStack> p_139366_) {
        LiteralArgumentBuilder $$1 = (LiteralArgumentBuilder)Commands.literal("data").requires(p_139381_ -> p_139381_.hasPermission(2));
        for (DataProvider $$2 : TARGET_PROVIDERS) {
            ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)$$1.then($$2.wrap((ArgumentBuilder<CommandSourceStack, ?>)Commands.literal("merge"), p_139471_ -> p_139471_.then(Commands.argument("nbt", CompoundTagArgument.compoundTag()).executes(p_142857_ -> DataCommands.mergeData((CommandSourceStack)p_142857_.getSource(), $$2.access((CommandContext<CommandSourceStack>)p_142857_), CompoundTagArgument.getCompoundTag(p_142857_, "nbt"))))))).then($$2.wrap((ArgumentBuilder<CommandSourceStack, ?>)Commands.literal("get"), p_139453_ -> p_139453_.executes(p_142849_ -> DataCommands.getData((CommandSourceStack)p_142849_.getSource(), $$2.access((CommandContext<CommandSourceStack>)p_142849_))).then(((RequiredArgumentBuilder)Commands.argument("path", NbtPathArgument.nbtPath()).executes(p_142841_ -> DataCommands.getData((CommandSourceStack)p_142841_.getSource(), $$2.access((CommandContext<CommandSourceStack>)p_142841_), NbtPathArgument.getPath((CommandContext<CommandSourceStack>)p_142841_, "path")))).then(Commands.argument("scale", DoubleArgumentType.doubleArg()).executes(p_142833_ -> DataCommands.getNumeric((CommandSourceStack)p_142833_.getSource(), $$2.access((CommandContext<CommandSourceStack>)p_142833_), NbtPathArgument.getPath((CommandContext<CommandSourceStack>)p_142833_, "path"), DoubleArgumentType.getDouble((CommandContext)p_142833_, (String)"scale")))))))).then($$2.wrap((ArgumentBuilder<CommandSourceStack, ?>)Commands.literal("remove"), p_139413_ -> p_139413_.then(Commands.argument("path", NbtPathArgument.nbtPath()).executes(p_142820_ -> DataCommands.removeData((CommandSourceStack)p_142820_.getSource(), $$2.access((CommandContext<CommandSourceStack>)p_142820_), NbtPathArgument.getPath((CommandContext<CommandSourceStack>)p_142820_, "path"))))))).then(DataCommands.decorateModification((p_139368_, p_139369_) -> p_139368_.then(Commands.literal("insert").then(Commands.argument("index", IntegerArgumentType.integer()).then(p_139369_.create((p_142859_, p_142860_, p_142861_, p_142862_) -> p_142861_.insert(IntegerArgumentType.getInteger((CommandContext)p_142859_, (String)"index"), p_142860_, p_142862_))))).then(Commands.literal("prepend").then(p_139369_.create((p_142851_, p_142852_, p_142853_, p_142854_) -> p_142853_.insert(0, p_142852_, p_142854_)))).then(Commands.literal("append").then(p_139369_.create((p_142843_, p_142844_, p_142845_, p_142846_) -> p_142845_.insert(-1, p_142844_, p_142846_)))).then(Commands.literal("set").then(p_139369_.create((p_142835_, p_142836_, p_142837_, p_142838_) -> p_142837_.set(p_142836_, (Tag)Iterables.getLast((Iterable)p_142838_))))).then(Commands.literal("merge").then(p_139369_.create((p_142822_, p_142823_, p_142824_, p_142825_) -> {
                CompoundTag $$4 = new CompoundTag();
                for (Tag $$5 : p_142825_) {
                    if (NbtPathArgument.NbtPath.isTooDeep($$5, 0)) {
                        throw NbtPathArgument.ERROR_DATA_TOO_DEEP.create();
                    }
                    if ($$5 instanceof CompoundTag) {
                        CompoundTag $$6 = (CompoundTag)$$5;
                        $$4.merge($$6);
                        continue;
                    }
                    throw ERROR_EXPECTED_OBJECT.create((Object)$$5);
                }
                List<Tag> $$7 = p_142824_.getOrCreate(p_142823_, CompoundTag::new);
                int $$8 = 0;
                for (Tag $$9 : $$7) {
                    void $$11;
                    if (!($$9 instanceof CompoundTag)) {
                        throw ERROR_EXPECTED_OBJECT.create((Object)$$9);
                    }
                    CompoundTag $$10 = (CompoundTag)$$9;
                    CompoundTag $$12 = $$11.copy();
                    $$11.merge($$4);
                    $$8 += $$12.equals($$11) ? 0 : 1;
                }
                return $$8;
            })))));
        }
        p_139366_.register($$1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getAsText(Tag p_265255_) throws CommandSyntaxException {
        Tag tag = p_265255_;
        Objects.requireNonNull(tag);
        Tag tag2 = tag;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{StringTag.class, PrimitiveTag.class}, (Object)tag2, n)) {
            case 0: {
                String string;
                StringTag stringTag = (StringTag)tag2;
                try {
                    String string2;
                    String $$1;
                    string = $$1 = (string2 = stringTag.value());
                    return string;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            case 1: {
                PrimitiveTag $$2 = (PrimitiveTag)tag2;
                String string = $$2.toString();
                return string;
            }
        }
        throw ERROR_EXPECTED_VALUE.create((Object)p_265255_);
    }

    private static List<Tag> stringifyTagList(List<Tag> p_288980_, StringProcessor p_289012_) throws CommandSyntaxException {
        ArrayList<Tag> $$2 = new ArrayList<Tag>(p_288980_.size());
        for (Tag $$3 : p_288980_) {
            String $$4 = DataCommands.getAsText($$3);
            $$2.add(StringTag.valueOf(p_289012_.process($$4)));
        }
        return $$2;
    }

    private static ArgumentBuilder<CommandSourceStack, ?> decorateModification(BiConsumer<ArgumentBuilder<CommandSourceStack, ?>, DataManipulatorDecorator> p_139404_) {
        LiteralArgumentBuilder<CommandSourceStack> $$1 = Commands.literal("modify");
        for (DataProvider $$2 : TARGET_PROVIDERS) {
            $$2.wrap((ArgumentBuilder<CommandSourceStack, ?>)$$1, p_264816_ -> {
                RequiredArgumentBuilder<CommandSourceStack, NbtPathArgument.NbtPath> $$3 = Commands.argument("targetPath", NbtPathArgument.nbtPath());
                for (DataProvider $$4 : SOURCE_PROVIDERS) {
                    p_139404_.accept((ArgumentBuilder<CommandSourceStack, ?>)$$3, p_142807_ -> $$4.wrap((ArgumentBuilder<CommandSourceStack, ?>)Commands.literal("from"), p_142812_ -> p_142812_.executes(p_264829_ -> DataCommands.manipulateData((CommandContext<CommandSourceStack>)p_264829_, $$2, p_142807_, DataCommands.getSingletonSource((CommandContext<CommandSourceStack>)p_264829_, $$4))).then(Commands.argument("sourcePath", NbtPathArgument.nbtPath()).executes(p_264842_ -> DataCommands.manipulateData((CommandContext<CommandSourceStack>)p_264842_, $$2, p_142807_, DataCommands.resolveSourcePath((CommandContext<CommandSourceStack>)p_264842_, $$4))))));
                    p_139404_.accept((ArgumentBuilder<CommandSourceStack, ?>)$$3, p_264836_ -> $$4.wrap((ArgumentBuilder<CommandSourceStack, ?>)Commands.literal("string"), p_287357_ -> p_287357_.executes(p_288732_ -> DataCommands.manipulateData((CommandContext<CommandSourceStack>)p_288732_, $$2, p_264836_, DataCommands.stringifyTagList(DataCommands.getSingletonSource((CommandContext<CommandSourceStack>)p_288732_, $$4), p_264813_ -> p_264813_))).then(((RequiredArgumentBuilder)Commands.argument("sourcePath", NbtPathArgument.nbtPath()).executes(p_288737_ -> DataCommands.manipulateData((CommandContext<CommandSourceStack>)p_288737_, $$2, p_264836_, DataCommands.stringifyTagList(DataCommands.resolveSourcePath((CommandContext<CommandSourceStack>)p_288737_, $$4), p_264821_ -> p_264821_)))).then(((RequiredArgumentBuilder)Commands.argument("start", IntegerArgumentType.integer()).executes(p_288753_ -> DataCommands.manipulateData((CommandContext<CommandSourceStack>)p_288753_, $$2, p_264836_, DataCommands.stringifyTagList(DataCommands.resolveSourcePath((CommandContext<CommandSourceStack>)p_288753_, $$4), p_287353_ -> DataCommands.substring(p_287353_, IntegerArgumentType.getInteger((CommandContext)p_288753_, (String)"start")))))).then(Commands.argument("end", IntegerArgumentType.integer()).executes(p_288749_ -> DataCommands.manipulateData((CommandContext<CommandSourceStack>)p_288749_, $$2, p_264836_, DataCommands.stringifyTagList(DataCommands.resolveSourcePath((CommandContext<CommandSourceStack>)p_288749_, $$4), p_287359_ -> DataCommands.substring(p_287359_, IntegerArgumentType.getInteger((CommandContext)p_288749_, (String)"start"), IntegerArgumentType.getInteger((CommandContext)p_288749_, (String)"end"))))))))));
                }
                p_139404_.accept((ArgumentBuilder<CommandSourceStack, ?>)$$3, p_142799_ -> Commands.literal("value").then(Commands.argument("value", NbtTagArgument.nbtTag()).executes(p_142803_ -> {
                    List<Tag> $$3 = Collections.singletonList(NbtTagArgument.getNbtTag(p_142803_, "value"));
                    return DataCommands.manipulateData((CommandContext<CommandSourceStack>)p_142803_, $$2, p_142799_, $$3);
                })));
                return p_264816_.then($$3);
            });
        }
        return $$1;
    }

    private static String validatedSubstring(String p_288976_, int p_288968_, int p_289018_) throws CommandSyntaxException {
        if (p_288968_ < 0 || p_289018_ > p_288976_.length() || p_288968_ > p_289018_) {
            throw ERROR_INVALID_SUBSTRING.create((Object)p_288968_, (Object)p_289018_);
        }
        return p_288976_.substring(p_288968_, p_289018_);
    }

    private static String substring(String p_287625_, int p_287772_, int p_287598_) throws CommandSyntaxException {
        int $$3 = p_287625_.length();
        int $$4 = DataCommands.getOffset(p_287772_, $$3);
        int $$5 = DataCommands.getOffset(p_287598_, $$3);
        return DataCommands.validatedSubstring(p_287625_, $$4, $$5);
    }

    private static String substring(String p_287744_, int p_287741_) throws CommandSyntaxException {
        int $$2 = p_287744_.length();
        return DataCommands.validatedSubstring(p_287744_, DataCommands.getOffset(p_287741_, $$2), $$2);
    }

    private static int getOffset(int p_287638_, int p_287600_) {
        return p_287638_ >= 0 ? p_287638_ : p_287600_ + p_287638_;
    }

    private static List<Tag> getSingletonSource(CommandContext<CommandSourceStack> p_265108_, DataProvider p_265370_) throws CommandSyntaxException {
        DataAccessor $$2 = p_265370_.access(p_265108_);
        return Collections.singletonList($$2.getData());
    }

    private static List<Tag> resolveSourcePath(CommandContext<CommandSourceStack> p_265468_, DataProvider p_265670_) throws CommandSyntaxException {
        DataAccessor $$2 = p_265670_.access(p_265468_);
        NbtPathArgument.NbtPath $$3 = NbtPathArgument.getPath(p_265468_, "sourcePath");
        return $$3.get($$2.getData());
    }

    private static int manipulateData(CommandContext<CommandSourceStack> p_139376_, DataProvider p_139377_, DataManipulator p_139378_, List<Tag> p_139379_) throws CommandSyntaxException {
        DataAccessor $$4 = p_139377_.access(p_139376_);
        NbtPathArgument.NbtPath $$5 = NbtPathArgument.getPath(p_139376_, "targetPath");
        CompoundTag $$6 = $$4.getData();
        int $$7 = p_139378_.modify(p_139376_, $$6, $$5, p_139379_);
        if ($$7 == 0) {
            throw ERROR_MERGE_UNCHANGED.create();
        }
        $$4.setData($$6);
        ((CommandSourceStack)p_139376_.getSource()).sendSuccess(() -> $$4.getModifiedSuccess(), true);
        return $$7;
    }

    private static int removeData(CommandSourceStack p_139386_, DataAccessor p_139387_, NbtPathArgument.NbtPath p_139388_) throws CommandSyntaxException {
        CompoundTag $$3 = p_139387_.getData();
        int $$4 = p_139388_.remove($$3);
        if ($$4 == 0) {
            throw ERROR_MERGE_UNCHANGED.create();
        }
        p_139387_.setData($$3);
        p_139386_.sendSuccess(() -> p_139387_.getModifiedSuccess(), true);
        return $$4;
    }

    public static Tag getSingleTag(NbtPathArgument.NbtPath p_139399_, DataAccessor p_139400_) throws CommandSyntaxException {
        List<Tag> $$2 = p_139399_.get(p_139400_.getData());
        Iterator $$3 = $$2.iterator();
        Tag $$4 = (Tag)$$3.next();
        if ($$3.hasNext()) {
            throw ERROR_MULTIPLE_TAGS.create();
        }
        return $$4;
    }

    /*
     * Loose catch block
     */
    private static int getData(CommandSourceStack p_139444_, DataAccessor p_139445_, NbtPathArgument.NbtPath p_139446_) throws CommandSyntaxException {
        Tag $$3;
        Tag tag = $$3 = DataCommands.getSingleTag(p_139446_, p_139445_);
        Objects.requireNonNull(tag);
        Tag tag2 = tag;
        int n = 0;
        int $$9 = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{NumericTag.class, CollectionTag.class, CompoundTag.class, StringTag.class, EndTag.class}, (Object)tag2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                NumericTag $$4 = (NumericTag)tag2;
                yield Mth.floor($$4.doubleValue());
            }
            case 1 -> {
                CollectionTag $$5 = (CollectionTag)tag2;
                yield $$5.size();
            }
            case 2 -> {
                CompoundTag $$6 = (CompoundTag)tag2;
                yield $$6.size();
            }
            case 3 -> {
                String var12_11;
                StringTag var10_10 = (StringTag)tag2;
                String $$7 = var12_11 = var10_10.value();
                yield $$7.length();
            }
            case 4 -> {
                EndTag $$8 = (EndTag)tag2;
                throw ERROR_GET_NON_EXISTENT.create((Object)p_139446_.toString());
            }
        };
        p_139444_.sendSuccess(() -> p_139445_.getPrintSuccess($$3), false);
        return $$9;
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    private static int getNumeric(CommandSourceStack p_139390_, DataAccessor p_139391_, NbtPathArgument.NbtPath p_139392_, double p_139393_) throws CommandSyntaxException {
        Tag $$4 = DataCommands.getSingleTag(p_139392_, p_139391_);
        if (!($$4 instanceof NumericTag)) {
            throw ERROR_GET_NOT_NUMBER.create((Object)p_139392_.toString());
        }
        int $$5 = Mth.floor(((NumericTag)$$4).doubleValue() * p_139393_);
        p_139390_.sendSuccess(() -> p_139391_.getPrintSuccess(p_139392_, p_139393_, $$5), false);
        return $$5;
    }

    private static int getData(CommandSourceStack p_139383_, DataAccessor p_139384_) throws CommandSyntaxException {
        CompoundTag $$2 = p_139384_.getData();
        p_139383_.sendSuccess(() -> p_139384_.getPrintSuccess($$2), false);
        return 1;
    }

    private static int mergeData(CommandSourceStack p_139395_, DataAccessor p_139396_, CompoundTag p_139397_) throws CommandSyntaxException {
        CompoundTag $$3 = p_139396_.getData();
        if (NbtPathArgument.NbtPath.isTooDeep(p_139397_, 0)) {
            throw NbtPathArgument.ERROR_DATA_TOO_DEEP.create();
        }
        CompoundTag $$4 = $$3.copy().merge(p_139397_);
        if ($$3.equals($$4)) {
            throw ERROR_MERGE_UNCHANGED.create();
        }
        p_139396_.setData($$4);
        p_139395_.sendSuccess(() -> p_139396_.getModifiedSuccess(), true);
        return 1;
    }

    public static interface DataProvider {
        public DataAccessor access(CommandContext<CommandSourceStack> var1) throws CommandSyntaxException;

        public ArgumentBuilder<CommandSourceStack, ?> wrap(ArgumentBuilder<CommandSourceStack, ?> var1, Function<ArgumentBuilder<CommandSourceStack, ?>, ArgumentBuilder<CommandSourceStack, ?>> var2);
    }

    @FunctionalInterface
    static interface StringProcessor {
        public String process(String var1) throws CommandSyntaxException;
    }

    @FunctionalInterface
    static interface DataManipulator {
        public int modify(CommandContext<CommandSourceStack> var1, CompoundTag var2, NbtPathArgument.NbtPath var3, List<Tag> var4) throws CommandSyntaxException;
    }

    @FunctionalInterface
    static interface DataManipulatorDecorator {
        public ArgumentBuilder<CommandSourceStack, ?> create(DataManipulator var1);
    }
}

