/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteMaps;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntMaps;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongConsumer;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.ChunkTracker;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.LoadingChunkTracker;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.SimulationChunkTracker;
import net.minecraft.server.level.ThrottlingChunkTaskDispatcher;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.TriState;
import net.minecraft.util.thread.TaskScheduler;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.TicketStorage;
import net.minecraft.world.level.chunk.LevelChunk;
import org.slf4j.Logger;

public abstract class DistanceManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    static final int PLAYER_TICKET_LEVEL = ChunkLevel.byStatus(FullChunkStatus.ENTITY_TICKING);
    final Long2ObjectMap<ObjectSet<ServerPlayer>> playersPerChunk = new Long2ObjectOpenHashMap();
    private final LoadingChunkTracker loadingChunkTracker;
    private final SimulationChunkTracker simulationChunkTracker;
    final TicketStorage ticketStorage;
    private final FixedPlayerDistanceChunkTracker naturalSpawnChunkCounter = new FixedPlayerDistanceChunkTracker(8);
    private final PlayerTicketTracker playerTicketManager = new PlayerTicketTracker(32);
    protected final Set<ChunkHolder> chunksToUpdateFutures = new ReferenceOpenHashSet();
    final ThrottlingChunkTaskDispatcher ticketDispatcher;
    final LongSet ticketsToRelease = new LongOpenHashSet();
    final Executor mainThreadExecutor;
    private int simulationDistance = 10;

    protected DistanceManager(TicketStorage p_394060_, Executor p_140774_, Executor p_140775_) {
        this.ticketStorage = p_394060_;
        this.loadingChunkTracker = new LoadingChunkTracker(this, p_394060_);
        this.simulationChunkTracker = new SimulationChunkTracker(p_394060_);
        TaskScheduler<Runnable> $$3 = TaskScheduler.wrapExecutor("player ticket throttler", p_140775_);
        this.ticketDispatcher = new ThrottlingChunkTaskDispatcher($$3, p_140774_, 4);
        this.mainThreadExecutor = p_140775_;
    }

    protected abstract boolean isChunkToRemove(long var1);

    @Nullable
    protected abstract ChunkHolder getChunk(long var1);

    @Nullable
    protected abstract ChunkHolder updateChunkScheduling(long var1, int var3, @Nullable ChunkHolder var4, int var5);

    public boolean runAllUpdates(ChunkMap p_140806_) {
        boolean $$2;
        this.naturalSpawnChunkCounter.runAllUpdates();
        this.simulationChunkTracker.runAllUpdates();
        this.playerTicketManager.runAllUpdates();
        int $$1 = Integer.MAX_VALUE - this.loadingChunkTracker.runDistanceUpdates(Integer.MAX_VALUE);
        boolean bl = $$2 = $$1 != 0;
        if ($$2) {
            // empty if block
        }
        if (!this.chunksToUpdateFutures.isEmpty()) {
            for (ChunkHolder $$3 : this.chunksToUpdateFutures) {
                $$3.updateHighestAllowedStatus(p_140806_);
            }
            for (ChunkHolder $$4 : this.chunksToUpdateFutures) {
                $$4.updateFutures(p_140806_, this.mainThreadExecutor);
            }
            this.chunksToUpdateFutures.clear();
            return true;
        }
        if (!this.ticketsToRelease.isEmpty()) {
            LongIterator $$5 = this.ticketsToRelease.iterator();
            while ($$5.hasNext()) {
                long $$6 = $$5.nextLong();
                if (!this.ticketStorage.getTickets($$6).stream().anyMatch(p_392783_ -> p_392783_.getType() == TicketType.PLAYER_LOADING)) continue;
                ChunkHolder $$7 = p_140806_.getUpdatingChunkIfPresent($$6);
                if ($$7 == null) {
                    throw new IllegalStateException();
                }
                CompletableFuture<ChunkResult<LevelChunk>> $$8 = $$7.getEntityTickingChunkFuture();
                $$8.thenAccept(p_331640_ -> this.mainThreadExecutor.execute(() -> this.ticketDispatcher.release($$6, () -> {}, false)));
            }
            this.ticketsToRelease.clear();
        }
        return $$2;
    }

    public void addPlayer(SectionPos p_140803_, ServerPlayer p_140804_) {
        ChunkPos $$2 = p_140803_.chunk();
        long $$3 = $$2.toLong();
        ((ObjectSet)this.playersPerChunk.computeIfAbsent($$3, p_183921_ -> new ObjectOpenHashSet())).add((Object)p_140804_);
        this.naturalSpawnChunkCounter.update($$3, 0, true);
        this.playerTicketManager.update($$3, 0, true);
        this.ticketStorage.addTicket(new Ticket(TicketType.PLAYER_SIMULATION, this.getPlayerTicketLevel()), $$2);
    }

    public void removePlayer(SectionPos p_140829_, ServerPlayer p_140830_) {
        ChunkPos $$2 = p_140829_.chunk();
        long $$3 = $$2.toLong();
        ObjectSet $$4 = (ObjectSet)this.playersPerChunk.get($$3);
        $$4.remove((Object)p_140830_);
        if ($$4.isEmpty()) {
            this.playersPerChunk.remove($$3);
            this.naturalSpawnChunkCounter.update($$3, Integer.MAX_VALUE, false);
            this.playerTicketManager.update($$3, Integer.MAX_VALUE, false);
            this.ticketStorage.removeTicket(new Ticket(TicketType.PLAYER_SIMULATION, this.getPlayerTicketLevel()), $$2);
        }
    }

    private int getPlayerTicketLevel() {
        return Math.max(0, ChunkLevel.byStatus(FullChunkStatus.ENTITY_TICKING) - this.simulationDistance);
    }

    public boolean inEntityTickingRange(long p_183914_) {
        return ChunkLevel.isEntityTicking(this.simulationChunkTracker.getLevel(p_183914_));
    }

    public boolean inBlockTickingRange(long p_183917_) {
        return ChunkLevel.isBlockTicking(this.simulationChunkTracker.getLevel(p_183917_));
    }

    public int getChunkLevel(long p_394212_, boolean p_394154_) {
        if (p_394154_) {
            return this.simulationChunkTracker.getLevel(p_394212_);
        }
        return this.loadingChunkTracker.getLevel(p_394212_);
    }

    protected void updatePlayerTickets(int p_140778_) {
        this.playerTicketManager.updateViewDistance(p_140778_);
    }

    public void updateSimulationDistance(int p_183912_) {
        if (p_183912_ != this.simulationDistance) {
            this.simulationDistance = p_183912_;
            this.ticketStorage.replaceTicketLevelOfType(this.getPlayerTicketLevel(), TicketType.PLAYER_SIMULATION);
        }
    }

    public int getNaturalSpawnChunkCount() {
        this.naturalSpawnChunkCounter.runAllUpdates();
        return this.naturalSpawnChunkCounter.chunks.size();
    }

    public TriState hasPlayersNearby(long p_140848_) {
        this.naturalSpawnChunkCounter.runAllUpdates();
        int $$1 = this.naturalSpawnChunkCounter.getLevel(p_140848_);
        if ($$1 <= NaturalSpawner.INSCRIBED_SQUARE_SPAWN_DISTANCE_CHUNK) {
            return TriState.TRUE;
        }
        if ($$1 > 8) {
            return TriState.FALSE;
        }
        return TriState.DEFAULT;
    }

    public void forEachEntityTickingChunk(LongConsumer p_410745_) {
        for (Long2ByteMap.Entry $$1 : Long2ByteMaps.fastIterable((Long2ByteMap)this.simulationChunkTracker.chunks)) {
            byte $$2 = $$1.getByteValue();
            long $$3 = $$1.getLongKey();
            if (!ChunkLevel.isEntityTicking($$2)) continue;
            p_410745_.accept($$3);
        }
    }

    public LongIterator getSpawnCandidateChunks() {
        this.naturalSpawnChunkCounter.runAllUpdates();
        return this.naturalSpawnChunkCounter.chunks.keySet().iterator();
    }

    public String getDebugStatus() {
        return this.ticketDispatcher.getDebugStatus();
    }

    public boolean hasTickets() {
        return this.ticketStorage.hasTickets();
    }

    class FixedPlayerDistanceChunkTracker
    extends ChunkTracker {
        protected final Long2ByteMap chunks;
        protected final int maxDistance;

        protected FixedPlayerDistanceChunkTracker(int p_140891_) {
            super(p_140891_ + 2, 16, 256);
            this.chunks = new Long2ByteOpenHashMap();
            this.maxDistance = p_140891_;
            this.chunks.defaultReturnValue((byte)(p_140891_ + 2));
        }

        @Override
        protected int getLevel(long p_140901_) {
            return this.chunks.get(p_140901_);
        }

        @Override
        protected void setLevel(long p_140893_, int p_140894_) {
            byte $$3;
            if (p_140894_ > this.maxDistance) {
                byte $$2 = this.chunks.remove(p_140893_);
            } else {
                $$3 = this.chunks.put(p_140893_, (byte)p_140894_);
            }
            this.onLevelChange(p_140893_, $$3, p_140894_);
        }

        protected void onLevelChange(long p_140895_, int p_140896_, int p_140897_) {
        }

        @Override
        protected int getLevelFromSource(long p_140899_) {
            return this.havePlayer(p_140899_) ? 0 : Integer.MAX_VALUE;
        }

        private boolean havePlayer(long p_140903_) {
            ObjectSet $$1 = (ObjectSet)DistanceManager.this.playersPerChunk.get(p_140903_);
            return $$1 != null && !$$1.isEmpty();
        }

        public void runAllUpdates() {
            this.runUpdates(Integer.MAX_VALUE);
        }
    }

    class PlayerTicketTracker
    extends FixedPlayerDistanceChunkTracker {
        private int viewDistance;
        private final Long2IntMap queueLevels;
        private final LongSet toUpdate;

        protected PlayerTicketTracker(int p_140910_) {
            super(p_140910_);
            this.queueLevels = Long2IntMaps.synchronize((Long2IntMap)new Long2IntOpenHashMap());
            this.toUpdate = new LongOpenHashSet();
            this.viewDistance = 0;
            this.queueLevels.defaultReturnValue(p_140910_ + 2);
        }

        @Override
        protected void onLevelChange(long p_140915_, int p_140916_, int p_140917_) {
            this.toUpdate.add(p_140915_);
        }

        public void updateViewDistance(int p_140913_) {
            for (Long2ByteMap.Entry $$1 : this.chunks.long2ByteEntrySet()) {
                byte $$2 = $$1.getByteValue();
                long $$3 = $$1.getLongKey();
                this.onLevelChange($$3, $$2, this.haveTicketFor($$2), $$2 <= p_140913_);
            }
            this.viewDistance = p_140913_;
        }

        private void onLevelChange(long p_140919_, int p_140920_, boolean p_140921_, boolean p_140922_) {
            if (p_140921_ != p_140922_) {
                Ticket $$4 = new Ticket(TicketType.PLAYER_LOADING, PLAYER_TICKET_LEVEL);
                if (p_140922_) {
                    DistanceManager.this.ticketDispatcher.submit(() -> DistanceManager.this.mainThreadExecutor.execute(() -> {
                        if (this.haveTicketFor(this.getLevel(p_140919_))) {
                            DistanceManager.this.ticketStorage.addTicket(p_140919_, $$4);
                            DistanceManager.this.ticketsToRelease.add(p_140919_);
                        } else {
                            DistanceManager.this.ticketDispatcher.release(p_140919_, () -> {}, false);
                        }
                    }), p_140919_, () -> p_140920_);
                } else {
                    DistanceManager.this.ticketDispatcher.release(p_140919_, () -> DistanceManager.this.mainThreadExecutor.execute(() -> DistanceManager.this.ticketStorage.removeTicket(p_140919_, $$4)), true);
                }
            }
        }

        @Override
        public void runAllUpdates() {
            super.runAllUpdates();
            if (!this.toUpdate.isEmpty()) {
                LongIterator $$0 = this.toUpdate.iterator();
                while ($$0.hasNext()) {
                    int $$3;
                    long $$1 = $$0.nextLong();
                    int $$2 = this.queueLevels.get($$1);
                    if ($$2 == ($$3 = this.getLevel($$1))) continue;
                    DistanceManager.this.ticketDispatcher.onLevelChange(new ChunkPos($$1), () -> this.queueLevels.get($$1), $$3, p_140928_ -> {
                        if (p_140928_ >= this.queueLevels.defaultReturnValue()) {
                            this.queueLevels.remove($$1);
                        } else {
                            this.queueLevels.put($$1, p_140928_);
                        }
                    });
                    this.onLevelChange($$1, $$3, this.haveTicketFor($$2), this.haveTicketFor($$3));
                }
                this.toUpdate.clear();
            }
        }

        private boolean haveTicketFor(int p_140933_) {
            return p_140933_ <= this.viewDistance;
        }
    }
}

