/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkTracker;
import net.minecraft.server.level.DistanceManager;
import net.minecraft.world.level.TicketStorage;

class LoadingChunkTracker
extends ChunkTracker {
    private static final int MAX_LEVEL = ChunkLevel.MAX_LEVEL + 1;
    private final DistanceManager distanceManager;
    private final TicketStorage ticketStorage;

    public LoadingChunkTracker(DistanceManager p_393579_, TicketStorage p_394246_) {
        super(MAX_LEVEL + 1, 16, 256);
        this.distanceManager = p_393579_;
        this.ticketStorage = p_394246_;
        p_394246_.setLoadingChunkUpdatedListener(this::update);
    }

    @Override
    protected int getLevelFromSource(long p_394127_) {
        return this.ticketStorage.getTicketLevelAt(p_394127_, false);
    }

    @Override
    protected int getLevel(long p_394558_) {
        ChunkHolder $$1;
        if (!this.distanceManager.isChunkToRemove(p_394558_) && ($$1 = this.distanceManager.getChunk(p_394558_)) != null) {
            return $$1.getTicketLevel();
        }
        return MAX_LEVEL;
    }

    @Override
    protected void setLevel(long p_394407_, int p_393818_) {
        int $$3;
        ChunkHolder $$2 = this.distanceManager.getChunk(p_394407_);
        int n = $$3 = $$2 == null ? MAX_LEVEL : $$2.getTicketLevel();
        if ($$3 == p_393818_) {
            return;
        }
        if (($$2 = this.distanceManager.updateChunkScheduling(p_394407_, p_393818_, $$2, $$3)) != null) {
            this.distanceManager.chunksToUpdateFutures.add($$2);
        }
    }

    public int runDistanceUpdates(int p_393751_) {
        return this.runUpdates(p_393751_);
    }
}

