/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.FileUtil;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.DistanceManager;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.LocalMobCapCalculator;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.TicketStorage;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LightChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.entity.ChunkStatusUpdateListener;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.slf4j.Logger;

public class ServerChunkCache
extends ChunkSource {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final DistanceManager distanceManager;
    private final ServerLevel level;
    final Thread mainThread;
    final ThreadedLevelLightEngine lightEngine;
    private final MainThreadExecutor mainThreadProcessor;
    public final ChunkMap chunkMap;
    private final DimensionDataStorage dataStorage;
    private final TicketStorage ticketStorage;
    private long lastInhabitedUpdate;
    private boolean spawnEnemies = true;
    private boolean spawnFriendlies = true;
    private static final int CACHE_SIZE = 4;
    private final long[] lastChunkPos = new long[4];
    private final ChunkStatus[] lastChunkStatus = new ChunkStatus[4];
    private final ChunkAccess[] lastChunk = new ChunkAccess[4];
    private final List<LevelChunk> spawningChunks = new ObjectArrayList();
    private final Set<ChunkHolder> chunkHoldersToBroadcast = new ReferenceOpenHashSet();
    @Nullable
    @VisibleForDebug
    private NaturalSpawner.SpawnState lastSpawnState;

    public ServerChunkCache(ServerLevel p_214982_, LevelStorageSource.LevelStorageAccess p_214983_, DataFixer p_214984_, StructureTemplateManager p_214985_, Executor p_214986_, ChunkGenerator p_214987_, int p_214988_, int p_214989_, boolean p_214990_, ChunkProgressListener p_214991_, ChunkStatusUpdateListener p_214992_, Supplier<DimensionDataStorage> p_214993_) {
        this.level = p_214982_;
        this.mainThreadProcessor = new MainThreadExecutor(p_214982_);
        this.mainThread = Thread.currentThread();
        Path $$12 = p_214983_.getDimensionPath(p_214982_.dimension()).resolve("data");
        try {
            FileUtil.createDirectoriesSafe($$12);
        }
        catch (IOException $$13) {
            LOGGER.error("Failed to create dimension data storage directory", (Throwable)$$13);
        }
        this.dataStorage = new DimensionDataStorage(new SavedData.Context(p_214982_), $$12, p_214984_, p_214982_.registryAccess());
        this.ticketStorage = this.dataStorage.computeIfAbsent(TicketStorage.TYPE);
        this.chunkMap = new ChunkMap(p_214982_, p_214983_, p_214984_, p_214985_, p_214986_, this.mainThreadProcessor, this, p_214987_, p_214991_, p_214992_, p_214993_, this.ticketStorage, p_214988_, p_214990_);
        this.lightEngine = this.chunkMap.getLightEngine();
        this.distanceManager = this.chunkMap.getDistanceManager();
        this.distanceManager.updateSimulationDistance(p_214989_);
        this.clearCache();
    }

    @Override
    public ThreadedLevelLightEngine getLightEngine() {
        return this.lightEngine;
    }

    @Nullable
    private ChunkHolder getVisibleChunkIfPresent(long p_8365_) {
        return this.chunkMap.getVisibleChunkIfPresent(p_8365_);
    }

    public int getTickingGenerated() {
        return this.chunkMap.getTickingGenerated();
    }

    private void storeInCache(long p_8367_, @Nullable ChunkAccess p_8368_, ChunkStatus p_331839_) {
        for (int $$3 = 3; $$3 > 0; --$$3) {
            this.lastChunkPos[$$3] = this.lastChunkPos[$$3 - 1];
            this.lastChunkStatus[$$3] = this.lastChunkStatus[$$3 - 1];
            this.lastChunk[$$3] = this.lastChunk[$$3 - 1];
        }
        this.lastChunkPos[0] = p_8367_;
        this.lastChunkStatus[0] = p_331839_;
        this.lastChunk[0] = p_8368_;
    }

    @Override
    @Nullable
    public ChunkAccess getChunk(int p_8360_, int p_8361_, ChunkStatus p_330876_, boolean p_8363_) {
        if (Thread.currentThread() != this.mainThread) {
            return CompletableFuture.supplyAsync(() -> this.getChunk(p_8360_, p_8361_, p_330876_, p_8363_), this.mainThreadProcessor).join();
        }
        ProfilerFiller $$4 = Profiler.get();
        $$4.incrementCounter("getChunk");
        long $$5 = ChunkPos.asLong(p_8360_, p_8361_);
        for (int $$6 = 0; $$6 < 4; ++$$6) {
            ChunkAccess $$7;
            if ($$5 != this.lastChunkPos[$$6] || p_330876_ != this.lastChunkStatus[$$6] || ($$7 = this.lastChunk[$$6]) == null && p_8363_) continue;
            return $$7;
        }
        $$4.incrementCounter("getChunkCacheMiss");
        CompletableFuture<ChunkResult<ChunkAccess>> $$8 = this.getChunkFutureMainThread(p_8360_, p_8361_, p_330876_, p_8363_);
        this.mainThreadProcessor.managedBlock($$8::isDone);
        ChunkResult<ChunkAccess> $$9 = $$8.join();
        ChunkAccess $$10 = $$9.orElse(null);
        if ($$10 == null && p_8363_) {
            throw Util.pauseInIde(new IllegalStateException("Chunk not there when requested: " + $$9.getError()));
        }
        this.storeInCache($$5, $$10, p_330876_);
        return $$10;
    }

    @Override
    @Nullable
    public LevelChunk getChunkNow(int p_8357_, int p_8358_) {
        if (Thread.currentThread() != this.mainThread) {
            return null;
        }
        Profiler.get().incrementCounter("getChunkNow");
        long $$2 = ChunkPos.asLong(p_8357_, p_8358_);
        for (int $$3 = 0; $$3 < 4; ++$$3) {
            if ($$2 != this.lastChunkPos[$$3] || this.lastChunkStatus[$$3] != ChunkStatus.FULL) continue;
            ChunkAccess $$4 = this.lastChunk[$$3];
            return $$4 instanceof LevelChunk ? (LevelChunk)$$4 : null;
        }
        ChunkHolder $$5 = this.getVisibleChunkIfPresent($$2);
        if ($$5 == null) {
            return null;
        }
        ChunkAccess $$6 = $$5.getChunkIfPresent(ChunkStatus.FULL);
        if ($$6 != null) {
            this.storeInCache($$2, $$6, ChunkStatus.FULL);
            if ($$6 instanceof LevelChunk) {
                return (LevelChunk)$$6;
            }
        }
        return null;
    }

    private void clearCache() {
        Arrays.fill(this.lastChunkPos, ChunkPos.INVALID_CHUNK_POS);
        Arrays.fill(this.lastChunkStatus, null);
        Arrays.fill(this.lastChunk, null);
    }

    public CompletableFuture<ChunkResult<ChunkAccess>> getChunkFuture(int p_8432_, int p_8433_, ChunkStatus p_330326_, boolean p_8435_) {
        CompletionStage $$6;
        boolean $$4;
        boolean bl = $$4 = Thread.currentThread() == this.mainThread;
        if ($$4) {
            CompletableFuture<ChunkResult<ChunkAccess>> $$5 = this.getChunkFutureMainThread(p_8432_, p_8433_, p_330326_, p_8435_);
            this.mainThreadProcessor.managedBlock($$5::isDone);
        } else {
            $$6 = CompletableFuture.supplyAsync(() -> this.getChunkFutureMainThread(p_8432_, p_8433_, p_330326_, p_8435_), this.mainThreadProcessor).thenCompose(p_331360_ -> p_331360_);
        }
        return $$6;
    }

    private CompletableFuture<ChunkResult<ChunkAccess>> getChunkFutureMainThread(int p_8457_, int p_8458_, ChunkStatus p_331599_, boolean p_8460_) {
        ChunkPos $$4 = new ChunkPos(p_8457_, p_8458_);
        long $$5 = $$4.toLong();
        int $$6 = ChunkLevel.byStatus(p_331599_);
        ChunkHolder $$7 = this.getVisibleChunkIfPresent($$5);
        if (p_8460_) {
            this.addTicket(new Ticket(TicketType.UNKNOWN, $$6), $$4);
            if (this.chunkAbsent($$7, $$6)) {
                ProfilerFiller $$8 = Profiler.get();
                $$8.push("chunkLoad");
                this.runDistanceManagerUpdates();
                $$7 = this.getVisibleChunkIfPresent($$5);
                $$8.pop();
                if (this.chunkAbsent($$7, $$6)) {
                    throw Util.pauseInIde(new IllegalStateException("No chunk holder after ticket has been added"));
                }
            }
        }
        if (this.chunkAbsent($$7, $$6)) {
            return GenerationChunkHolder.UNLOADED_CHUNK_FUTURE;
        }
        return $$7.scheduleChunkGenerationTask(p_331599_, this.chunkMap);
    }

    private boolean chunkAbsent(@Nullable ChunkHolder p_8417_, int p_8418_) {
        return p_8417_ == null || p_8417_.getTicketLevel() > p_8418_;
    }

    @Override
    public boolean hasChunk(int p_8429_, int p_8430_) {
        int $$3;
        ChunkHolder $$2 = this.getVisibleChunkIfPresent(new ChunkPos(p_8429_, p_8430_).toLong());
        return !this.chunkAbsent($$2, $$3 = ChunkLevel.byStatus(ChunkStatus.FULL));
    }

    @Override
    @Nullable
    public LightChunk getChunkForLighting(int p_8454_, int p_8455_) {
        long $$2 = ChunkPos.asLong(p_8454_, p_8455_);
        ChunkHolder $$3 = this.getVisibleChunkIfPresent($$2);
        if ($$3 == null) {
            return null;
        }
        return $$3.getChunkIfPresentUnchecked(ChunkStatus.INITIALIZE_LIGHT.getParent());
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    public boolean pollTask() {
        return this.mainThreadProcessor.pollTask();
    }

    boolean runDistanceManagerUpdates() {
        boolean $$0 = this.distanceManager.runAllUpdates(this.chunkMap);
        boolean $$1 = this.chunkMap.promoteChunkMap();
        this.chunkMap.runGenerationTasks();
        if ($$0 || $$1) {
            this.clearCache();
            return true;
        }
        return false;
    }

    public boolean isPositionTicking(long p_143240_) {
        if (!this.level.shouldTickBlocksAt(p_143240_)) {
            return false;
        }
        ChunkHolder $$1 = this.getVisibleChunkIfPresent(p_143240_);
        if ($$1 == null) {
            return false;
        }
        return $$1.getTickingChunkFuture().getNow(ChunkHolder.UNLOADED_LEVEL_CHUNK).isSuccess();
    }

    public void save(boolean p_8420_) {
        this.runDistanceManagerUpdates();
        this.chunkMap.saveAllChunks(p_8420_);
    }

    @Override
    public void close() throws IOException {
        this.save(true);
        this.dataStorage.close();
        this.lightEngine.close();
        this.chunkMap.close();
    }

    @Override
    public void tick(BooleanSupplier p_201913_, boolean p_201914_) {
        ProfilerFiller $$2 = Profiler.get();
        $$2.push("purge");
        if (this.level.tickRateManager().runsNormally() || !p_201914_) {
            this.ticketStorage.purgeStaleTickets();
        }
        this.runDistanceManagerUpdates();
        $$2.popPush("chunks");
        if (p_201914_) {
            this.tickChunks();
            this.chunkMap.tick();
        }
        $$2.popPush("unload");
        this.chunkMap.tick(p_201913_);
        $$2.pop();
        this.clearCache();
    }

    private void tickChunks() {
        long $$0 = this.level.getGameTime();
        long $$1 = $$0 - this.lastInhabitedUpdate;
        this.lastInhabitedUpdate = $$0;
        if (this.level.isDebug()) {
            return;
        }
        ProfilerFiller $$2 = Profiler.get();
        $$2.push("pollingChunks");
        if (this.level.tickRateManager().runsNormally()) {
            $$2.push("tickingChunks");
            this.tickChunks($$2, $$1);
            $$2.pop();
        }
        this.broadcastChangedChunks($$2);
        $$2.pop();
    }

    private void broadcastChangedChunks(ProfilerFiller p_360525_) {
        p_360525_.push("broadcast");
        for (ChunkHolder $$1 : this.chunkHoldersToBroadcast) {
            LevelChunk $$2 = $$1.getTickingChunk();
            if ($$2 == null) continue;
            $$1.broadcastChanges($$2);
        }
        this.chunkHoldersToBroadcast.clear();
        p_360525_.pop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tickChunks(ProfilerFiller p_364065_, long p_361343_) {
        List<MobCategory> $$8;
        NaturalSpawner.SpawnState $$3;
        p_364065_.popPush("naturalSpawnCount");
        int $$2 = this.distanceManager.getNaturalSpawnChunkCount();
        this.lastSpawnState = $$3 = NaturalSpawner.createState($$2, this.level.getAllEntities(), this::getFullChunk, new LocalMobCapCalculator(this.chunkMap));
        p_364065_.popPush("spawnAndTick");
        boolean $$4 = this.level.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING);
        int $$5 = this.level.getGameRules().getInt(GameRules.RULE_RANDOMTICKING);
        if ($$4 && (this.spawnEnemies || this.spawnFriendlies)) {
            boolean $$6 = this.level.getLevelData().getGameTime() % 400L == 0L;
            List<MobCategory> $$7 = NaturalSpawner.getFilteredSpawningCategories($$3, this.spawnFriendlies, this.spawnEnemies, $$6);
        } else {
            $$8 = List.of();
        }
        List<LevelChunk> $$9 = this.spawningChunks;
        try {
            p_364065_.push("filteringSpawningChunks");
            this.chunkMap.collectSpawningChunks($$9);
            p_364065_.popPush("shuffleSpawningChunks");
            Util.shuffle($$9, this.level.random);
            p_364065_.popPush("tickSpawningChunks");
            for (LevelChunk $$10 : $$9) {
                this.tickSpawningChunk($$10, p_361343_, $$8, $$3);
            }
        }
        finally {
            $$9.clear();
        }
        p_364065_.popPush("tickTickingChunks");
        this.chunkMap.forEachBlockTickingChunk(p_401730_ -> this.level.tickChunk((LevelChunk)p_401730_, $$5));
        p_364065_.pop();
        p_364065_.popPush("customSpawners");
        if ($$4) {
            this.level.tickCustomSpawners(this.spawnEnemies, this.spawnFriendlies);
        }
    }

    private void tickSpawningChunk(LevelChunk p_401862_, long p_401787_, List<MobCategory> p_401800_, NaturalSpawner.SpawnState p_401847_) {
        ChunkPos $$4 = p_401862_.getPos();
        p_401862_.incrementInhabitedTime(p_401787_);
        if (this.distanceManager.inEntityTickingRange($$4.toLong())) {
            this.level.tickThunder(p_401862_);
        }
        if (p_401800_.isEmpty()) {
            return;
        }
        if (this.level.canSpawnEntitiesInChunk($$4)) {
            NaturalSpawner.spawnForChunk(this.level, p_401862_, p_401847_, p_401800_);
        }
    }

    private void getFullChunk(long p_8371_, Consumer<LevelChunk> p_8372_) {
        ChunkHolder $$2 = this.getVisibleChunkIfPresent(p_8371_);
        if ($$2 != null) {
            $$2.getFullChunkFuture().getNow(ChunkHolder.UNLOADED_LEVEL_CHUNK).ifSuccess(p_8372_);
        }
    }

    @Override
    public String gatherStats() {
        return Integer.toString(this.getLoadedChunksCount());
    }

    @VisibleForTesting
    public int getPendingTasksCount() {
        return this.mainThreadProcessor.getPendingTasksCount();
    }

    public ChunkGenerator getGenerator() {
        return this.chunkMap.generator();
    }

    public ChunkGeneratorStructureState getGeneratorState() {
        return this.chunkMap.generatorState();
    }

    public RandomState randomState() {
        return this.chunkMap.randomState();
    }

    @Override
    public int getLoadedChunksCount() {
        return this.chunkMap.size();
    }

    public void blockChanged(BlockPos p_8451_) {
        int $$2;
        int $$1 = SectionPos.blockToSectionCoord(p_8451_.getX());
        ChunkHolder $$3 = this.getVisibleChunkIfPresent(ChunkPos.asLong($$1, $$2 = SectionPos.blockToSectionCoord(p_8451_.getZ())));
        if ($$3 != null && $$3.blockChanged(p_8451_)) {
            this.chunkHoldersToBroadcast.add($$3);
        }
    }

    @Override
    public void onLightUpdate(LightLayer p_8403_, SectionPos p_8404_) {
        this.mainThreadProcessor.execute(() -> {
            ChunkHolder $$2 = this.getVisibleChunkIfPresent(p_8404_.chunk().toLong());
            if ($$2 != null && $$2.sectionLightChanged(p_8403_, p_8404_.y())) {
                this.chunkHoldersToBroadcast.add($$2);
            }
        });
    }

    public void addTicket(Ticket p_394043_, ChunkPos p_394514_) {
        this.ticketStorage.addTicket(p_394043_, p_394514_);
    }

    public void addTicketWithRadius(TicketType p_394166_, ChunkPos p_394235_, int p_393501_) {
        this.ticketStorage.addTicketWithRadius(p_394166_, p_394235_, p_393501_);
    }

    public void removeTicketWithRadius(TicketType p_393514_, ChunkPos p_394302_, int p_393914_) {
        this.ticketStorage.removeTicketWithRadius(p_393514_, p_394302_, p_393914_);
    }

    @Override
    public boolean updateChunkForced(ChunkPos p_8400_, boolean p_8401_) {
        return this.ticketStorage.updateChunkForced(p_8400_, p_8401_);
    }

    @Override
    public LongSet getForceLoadedChunks() {
        return this.ticketStorage.getForceLoadedChunks();
    }

    public void move(ServerPlayer p_8386_) {
        if (!p_8386_.isRemoved()) {
            this.chunkMap.move(p_8386_);
        }
    }

    public void removeEntity(Entity p_8444_) {
        this.chunkMap.removeEntity(p_8444_);
    }

    public void addEntity(Entity p_8464_) {
        this.chunkMap.addEntity(p_8464_);
    }

    public void broadcastAndSend(Entity p_8395_, Packet<?> p_8396_) {
        this.chunkMap.broadcastAndSend(p_8395_, p_8396_);
    }

    public void broadcast(Entity p_8446_, Packet<?> p_8447_) {
        this.chunkMap.broadcast(p_8446_, p_8447_);
    }

    public void setViewDistance(int p_8355_) {
        this.chunkMap.setServerViewDistance(p_8355_);
    }

    public void setSimulationDistance(int p_184027_) {
        this.distanceManager.updateSimulationDistance(p_184027_);
    }

    @Override
    public void setSpawnSettings(boolean p_8425_) {
        this.spawnEnemies = p_8425_;
        this.spawnFriendlies = this.spawnFriendlies;
    }

    public String getChunkDebugData(ChunkPos p_8449_) {
        return this.chunkMap.getChunkDebugData(p_8449_);
    }

    public DimensionDataStorage getDataStorage() {
        return this.dataStorage;
    }

    public PoiManager getPoiManager() {
        return this.chunkMap.getPoiManager();
    }

    public ChunkScanAccess chunkScanner() {
        return this.chunkMap.chunkScanner();
    }

    @Nullable
    @VisibleForDebug
    public NaturalSpawner.SpawnState getLastSpawnState() {
        return this.lastSpawnState;
    }

    public void deactivateTicketsOnClosing() {
        this.ticketStorage.deactivateTicketsOnClosing();
    }

    public void onChunkReadyToSend(ChunkHolder p_381768_) {
        if (p_381768_.hasChangesToBroadcast()) {
            this.chunkHoldersToBroadcast.add(p_381768_);
        }
    }

    @Override
    public /* synthetic */ LevelLightEngine getLightEngine() {
        return this.getLightEngine();
    }

    @Override
    public /* synthetic */ BlockGetter getLevel() {
        return this.getLevel();
    }

    final class MainThreadExecutor
    extends BlockableEventLoop<Runnable> {
        MainThreadExecutor(Level p_8494_) {
            super("Chunk source main thread executor for " + String.valueOf(p_8494_.dimension().location()));
        }

        @Override
        public void managedBlock(BooleanSupplier p_347606_) {
            super.managedBlock(() -> MinecraftServer.throwIfFatalException() && p_347606_.getAsBoolean());
        }

        @Override
        public Runnable wrapRunnable(Runnable p_8506_) {
            return p_8506_;
        }

        @Override
        protected boolean shouldRun(Runnable p_8504_) {
            return true;
        }

        @Override
        protected boolean scheduleExecutables() {
            return true;
        }

        @Override
        protected Thread getRunningThread() {
            return ServerChunkCache.this.mainThread;
        }

        @Override
        protected void doRunTask(Runnable p_8502_) {
            Profiler.get().incrementCounter("runTask");
            super.doRunTask(p_8502_);
        }

        @Override
        protected boolean pollTask() {
            if (ServerChunkCache.this.runDistanceManagerUpdates()) {
                return true;
            }
            ServerChunkCache.this.lightEngine.tryScheduleUpdate();
            return super.pollTask();
        }
    }
}

