/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.ClientboundEntityPositionSyncPacket;
import net.minecraft.network.protocol.game.ClientboundMoveEntityPacket;
import net.minecraft.network.protocol.game.ClientboundMoveMinecartPacket;
import net.minecraft.network.protocol.game.ClientboundProjectilePowerPacket;
import net.minecraft.network.protocol.game.ClientboundRemoveEntitiesPacket;
import net.minecraft.network.protocol.game.ClientboundRotateHeadPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityLinkPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.protocol.game.ClientboundSetEquipmentPacket;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateAttributesPacket;
import net.minecraft.network.protocol.game.VecDeltaCodec;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.MinecartBehavior;
import net.minecraft.world.entity.vehicle.NewMinecartBehavior;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;

public class ServerEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int TOLERANCE_LEVEL_ROTATION = 1;
    private static final double TOLERANCE_LEVEL_POSITION = 7.62939453125E-6;
    public static final int FORCED_POS_UPDATE_PERIOD = 60;
    private static final int FORCED_TELEPORT_PERIOD = 400;
    private final ServerLevel level;
    private final Entity entity;
    private final int updateInterval;
    private final boolean trackDelta;
    private final Consumer<Packet<?>> broadcast;
    private final BiConsumer<Packet<?>, List<UUID>> broadcastWithIgnore;
    private final VecDeltaCodec positionCodec = new VecDeltaCodec();
    private byte lastSentYRot;
    private byte lastSentXRot;
    private byte lastSentYHeadRot;
    private Vec3 lastSentMovement;
    private int tickCount;
    private int teleportDelay;
    private List<Entity> lastPassengers = Collections.emptyList();
    private boolean wasRiding;
    private boolean wasOnGround;
    @Nullable
    private List<SynchedEntityData.DataValue<?>> trackedDataValues;

    public ServerEntity(ServerLevel p_8528_, Entity p_8529_, int p_8530_, boolean p_8531_, Consumer<Packet<?>> p_8532_, BiConsumer<Packet<?>, List<UUID>> p_394447_) {
        this.level = p_8528_;
        this.broadcast = p_8532_;
        this.entity = p_8529_;
        this.updateInterval = p_8530_;
        this.trackDelta = p_8531_;
        this.broadcastWithIgnore = p_394447_;
        this.positionCodec.setBase(p_8529_.trackingPosition());
        this.lastSentMovement = p_8529_.getDeltaMovement();
        this.lastSentYRot = Mth.packDegrees(p_8529_.getYRot());
        this.lastSentXRot = Mth.packDegrees(p_8529_.getXRot());
        this.lastSentYHeadRot = Mth.packDegrees(p_8529_.getYHeadRot());
        this.wasOnGround = p_8529_.onGround();
        this.trackedDataValues = p_8529_.getEntityData().getNonDefaultValues();
    }

    public void sendChanges() {
        Entity entity;
        List<Entity> $$0 = this.entity.getPassengers();
        if (!$$0.equals(this.lastPassengers)) {
            List<UUID> $$1 = this.mountedOrDismounted($$0).map(Entity::getUUID).toList();
            this.broadcastWithIgnore.accept(new ClientboundSetPassengersPacket(this.entity), $$1);
            this.lastPassengers = $$0;
        }
        if ((entity = this.entity) instanceof ItemFrame) {
            ItemFrame $$2 = (ItemFrame)entity;
            if (this.tickCount % 10 == 0) {
                MapId $$4;
                MapItemSavedData $$5;
                ItemStack $$3 = $$2.getItem();
                if ($$3.getItem() instanceof MapItem && ($$5 = MapItem.getSavedData($$4 = $$3.get(DataComponents.MAP_ID), (Level)this.level)) != null) {
                    for (ServerPlayer serverPlayer : this.level.players()) {
                        $$5.tickCarriedBy(serverPlayer, $$3);
                        Packet<?> $$7 = $$5.getUpdatePacket($$4, serverPlayer);
                        if ($$7 == null) continue;
                        serverPlayer.connection.send($$7);
                    }
                }
                this.sendDirtyEntityData();
            }
        }
        if (this.tickCount % this.updateInterval == 0 || this.entity.hasImpulse || this.entity.getEntityData().isDirty()) {
            boolean $$10;
            byte $$8 = Mth.packDegrees(this.entity.getYRot());
            byte $$9 = Mth.packDegrees(this.entity.getXRot());
            boolean bl = $$10 = Math.abs($$8 - this.lastSentYRot) >= 1 || Math.abs($$9 - this.lastSentXRot) >= 1;
            if (this.entity.isPassenger()) {
                if ($$10) {
                    this.broadcast.accept(new ClientboundMoveEntityPacket.Rot(this.entity.getId(), $$8, $$9, this.entity.onGround()));
                    this.lastSentYRot = $$8;
                    this.lastSentXRot = $$9;
                }
                this.positionCodec.setBase(this.entity.trackingPosition());
                this.sendDirtyEntityData();
                this.wasRiding = true;
            } else {
                AbstractMinecart $$11;
                MinecartBehavior minecartBehavior;
                Entity entity2 = this.entity;
                if (entity2 instanceof AbstractMinecart && (minecartBehavior = ($$11 = (AbstractMinecart)entity2).getBehavior()) instanceof NewMinecartBehavior) {
                    NewMinecartBehavior $$12 = (NewMinecartBehavior)minecartBehavior;
                    this.handleMinecartPosRot($$12, $$8, $$9, $$10);
                } else {
                    Vec3 $$23;
                    double $$24;
                    boolean $$22;
                    ++this.teleportDelay;
                    Vec3 vec3 = this.entity.trackingPosition();
                    boolean $$14 = this.positionCodec.delta(vec3).lengthSqr() >= 7.62939453125E-6;
                    Packet<ClientGamePacketListener> $$15 = null;
                    boolean $$16 = $$14 || this.tickCount % 60 == 0;
                    boolean $$17 = false;
                    boolean $$18 = false;
                    long $$19 = this.positionCodec.encodeX(vec3);
                    long $$20 = this.positionCodec.encodeY(vec3);
                    long $$21 = this.positionCodec.encodeZ(vec3);
                    boolean bl2 = $$22 = $$19 < -32768L || $$19 > 32767L || $$20 < -32768L || $$20 > 32767L || $$21 < -32768L || $$21 > 32767L;
                    if ($$22 || this.teleportDelay > 400 || this.wasRiding || this.wasOnGround != this.entity.onGround()) {
                        this.wasOnGround = this.entity.onGround();
                        this.teleportDelay = 0;
                        $$15 = ClientboundEntityPositionSyncPacket.of(this.entity);
                        $$17 = true;
                        $$18 = true;
                    } else if ($$16 && $$10 || this.entity instanceof AbstractArrow) {
                        $$15 = new ClientboundMoveEntityPacket.PosRot(this.entity.getId(), (short)$$19, (short)$$20, (short)$$21, $$8, $$9, this.entity.onGround());
                        $$17 = true;
                        $$18 = true;
                    } else if ($$16) {
                        $$15 = new ClientboundMoveEntityPacket.Pos(this.entity.getId(), (short)$$19, (short)$$20, (short)$$21, this.entity.onGround());
                        $$17 = true;
                    } else if ($$10) {
                        $$15 = new ClientboundMoveEntityPacket.Rot(this.entity.getId(), $$8, $$9, this.entity.onGround());
                        $$18 = true;
                    }
                    if ((this.entity.hasImpulse || this.trackDelta || this.entity instanceof LivingEntity && ((LivingEntity)this.entity).isFallFlying()) && (($$24 = ($$23 = this.entity.getDeltaMovement()).distanceToSqr(this.lastSentMovement)) > 1.0E-7 || $$24 > 0.0 && $$23.lengthSqr() == 0.0)) {
                        this.lastSentMovement = $$23;
                        Entity entity3 = this.entity;
                        if (entity3 instanceof AbstractHurtingProjectile) {
                            AbstractHurtingProjectile $$25 = (AbstractHurtingProjectile)entity3;
                            this.broadcast.accept(new ClientboundBundlePacket((Iterable<Packet<? super ClientGamePacketListener>>)List.of(new ClientboundSetEntityMotionPacket(this.entity.getId(), this.lastSentMovement), new ClientboundProjectilePowerPacket($$25.getId(), $$25.accelerationPower))));
                        } else {
                            this.broadcast.accept(new ClientboundSetEntityMotionPacket(this.entity.getId(), this.lastSentMovement));
                        }
                    }
                    if ($$15 != null) {
                        this.broadcast.accept($$15);
                    }
                    this.sendDirtyEntityData();
                    if ($$17) {
                        this.positionCodec.setBase(vec3);
                    }
                    if ($$18) {
                        this.lastSentYRot = $$8;
                        this.lastSentXRot = $$9;
                    }
                    this.wasRiding = false;
                }
            }
            byte $$26 = Mth.packDegrees(this.entity.getYHeadRot());
            if (Math.abs($$26 - this.lastSentYHeadRot) >= 1) {
                this.broadcast.accept(new ClientboundRotateHeadPacket(this.entity, $$26));
                this.lastSentYHeadRot = $$26;
            }
            this.entity.hasImpulse = false;
        }
        ++this.tickCount;
        if (this.entity.hurtMarked) {
            this.entity.hurtMarked = false;
            this.broadcastAndSend(new ClientboundSetEntityMotionPacket(this.entity));
        }
    }

    private Stream<Entity> mountedOrDismounted(List<Entity> p_394226_) {
        return Streams.concat((Stream[])new Stream[]{this.lastPassengers.stream().filter(p_275361_ -> !p_394226_.contains(p_275361_)), p_394226_.stream().filter(p_392788_ -> !this.lastPassengers.contains(p_392788_))});
    }

    private void handleMinecartPosRot(NewMinecartBehavior p_364284_, byte p_368668_, byte p_368551_, boolean p_368717_) {
        this.sendDirtyEntityData();
        if (p_364284_.lerpSteps.isEmpty()) {
            boolean $$8;
            Vec3 $$4 = this.entity.getDeltaMovement();
            double $$5 = $$4.distanceToSqr(this.lastSentMovement);
            Vec3 $$6 = this.entity.trackingPosition();
            boolean $$7 = this.positionCodec.delta($$6).lengthSqr() >= 7.62939453125E-6;
            boolean bl = $$8 = $$7 || this.tickCount % 60 == 0;
            if ($$8 || p_368717_ || $$5 > 1.0E-7) {
                this.broadcast.accept(new ClientboundMoveMinecartPacket(this.entity.getId(), List.of(new NewMinecartBehavior.MinecartStep(this.entity.position(), this.entity.getDeltaMovement(), this.entity.getYRot(), this.entity.getXRot(), 1.0f))));
            }
        } else {
            this.broadcast.accept(new ClientboundMoveMinecartPacket(this.entity.getId(), List.copyOf(p_364284_.lerpSteps)));
            p_364284_.lerpSteps.clear();
        }
        this.lastSentYRot = p_368668_;
        this.lastSentXRot = p_368551_;
        this.positionCodec.setBase(this.entity.position());
    }

    public void removePairing(ServerPlayer p_8535_) {
        this.entity.stopSeenByPlayer(p_8535_);
        p_8535_.connection.send(new ClientboundRemoveEntitiesPacket(this.entity.getId()));
    }

    public void addPairing(ServerPlayer p_8542_) {
        ArrayList<Packet<? super ClientGamePacketListener>> $$1 = new ArrayList<Packet<? super ClientGamePacketListener>>();
        this.sendPairingData(p_8542_, $$1::add);
        p_8542_.connection.send(new ClientboundBundlePacket((Iterable<Packet<? super ClientGamePacketListener>>)$$1));
        this.entity.startSeenByPlayer(p_8542_);
    }

    public void sendPairingData(ServerPlayer p_289562_, Consumer<Packet<ClientGamePacketListener>> p_289563_) {
        Leashable $$9;
        Entity entity;
        if (this.entity.isRemoved()) {
            LOGGER.warn("Fetching packet for removed entity {}", (Object)this.entity);
        }
        Packet<ClientGamePacketListener> $$2 = this.entity.getAddEntityPacket(this);
        p_289563_.accept($$2);
        if (this.trackedDataValues != null) {
            p_289563_.accept(new ClientboundSetEntityDataPacket(this.entity.getId(), this.trackedDataValues));
        }
        boolean $$3 = this.trackDelta;
        if (this.entity instanceof LivingEntity) {
            Collection<AttributeInstance> $$4 = ((LivingEntity)this.entity).getAttributes().getSyncableAttributes();
            if (!$$4.isEmpty()) {
                p_289563_.accept(new ClientboundUpdateAttributesPacket(this.entity.getId(), $$4));
            }
            if (((LivingEntity)this.entity).isFallFlying()) {
                $$3 = true;
            }
        }
        if ($$3 && !(this.entity instanceof LivingEntity)) {
            p_289563_.accept(new ClientboundSetEntityMotionPacket(this.entity.getId(), this.lastSentMovement));
        }
        if ((entity = this.entity) instanceof LivingEntity) {
            LivingEntity $$5 = (LivingEntity)entity;
            ArrayList $$6 = Lists.newArrayList();
            for (EquipmentSlot $$7 : EquipmentSlot.VALUES) {
                ItemStack $$8 = $$5.getItemBySlot($$7);
                if ($$8.isEmpty()) continue;
                $$6.add(Pair.of((Object)$$7, (Object)$$8.copy()));
            }
            if (!$$6.isEmpty()) {
                p_289563_.accept(new ClientboundSetEquipmentPacket(this.entity.getId(), $$6));
            }
        }
        if (!this.entity.getPassengers().isEmpty()) {
            p_289563_.accept(new ClientboundSetPassengersPacket(this.entity));
        }
        if (this.entity.isPassenger()) {
            p_289563_.accept(new ClientboundSetPassengersPacket(this.entity.getVehicle()));
        }
        if ((entity = this.entity) instanceof Leashable && ($$9 = (Leashable)((Object)entity)).isLeashed()) {
            p_289563_.accept(new ClientboundSetEntityLinkPacket(this.entity, $$9.getLeashHolder()));
        }
    }

    public Vec3 getPositionBase() {
        return this.positionCodec.getBase();
    }

    public Vec3 getLastSentMovement() {
        return this.lastSentMovement;
    }

    public float getLastSentXRot() {
        return Mth.unpackDegrees(this.lastSentXRot);
    }

    public float getLastSentYRot() {
        return Mth.unpackDegrees(this.lastSentYRot);
    }

    public float getLastSentYHeadRot() {
        return Mth.unpackDegrees(this.lastSentYHeadRot);
    }

    private void sendDirtyEntityData() {
        SynchedEntityData $$0 = this.entity.getEntityData();
        List<SynchedEntityData.DataValue<?>> $$1 = $$0.packDirty();
        if ($$1 != null) {
            this.trackedDataValues = $$0.getNonDefaultValues();
            this.broadcastAndSend(new ClientboundSetEntityDataPacket(this.entity.getId(), $$1));
        }
        if (this.entity instanceof LivingEntity) {
            Set<AttributeInstance> $$2 = ((LivingEntity)this.entity).getAttributes().getAttributesToSync();
            if (!$$2.isEmpty()) {
                this.broadcastAndSend(new ClientboundUpdateAttributesPacket(this.entity.getId(), $$2));
            }
            $$2.clear();
        }
    }

    private void broadcastAndSend(Packet<?> p_8539_) {
        this.broadcast.accept(p_8539_);
        if (this.entity instanceof ServerPlayer) {
            ((ServerPlayer)this.entity).connection.send(p_8539_);
        }
    }
}

