/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportType;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockDestructionPacket;
import net.minecraft.network.protocol.game.ClientboundBlockEventPacket;
import net.minecraft.network.protocol.game.ClientboundDamageEventPacket;
import net.minecraft.network.protocol.game.ClientboundEntityEventPacket;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.protocol.game.ClientboundLevelEventPacket;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.network.protocol.game.ClientboundSetDefaultSpawnPositionPacket;
import net.minecraft.network.protocol.game.ClientboundSoundEntityPacket;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerEntityGetter;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.server.players.SleepStatus;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.util.CsvOutput;
import net.minecraft.util.Mth;
import net.minecraft.util.ProgressListener;
import net.minecraft.util.RandomSource;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.RandomSequences;
import net.minecraft.world.TickRateManager;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ReputationEventHandler;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.village.ReputationEventType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.animal.horse.SkeletonHorse;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raids;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.crafting.RecipeAccess;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.BlockEventData;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerExplosion;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.entity.FuelValues;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.storage.EntityStorage;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.chunk.storage.SimpleRegionStorage;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.dimension.end.EndDragonFight;
import net.minecraft.world.level.entity.EntityTickList;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelCallback;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.entity.PersistentEntitySectionManager;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventDispatcher;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureCheck;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathTypeCache;
import net.minecraft.world.level.portal.PortalForcer;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapIndex;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.ticks.LevelTickAccess;
import net.minecraft.world.ticks.LevelTicks;
import org.slf4j.Logger;

public class ServerLevel
extends Level
implements ServerEntityGetter,
WorldGenLevel {
    public static final BlockPos END_SPAWN_POINT = new BlockPos(100, 50, 0);
    public static final IntProvider RAIN_DELAY = UniformInt.of(12000, 180000);
    public static final IntProvider RAIN_DURATION = UniformInt.of(12000, 24000);
    private static final IntProvider THUNDER_DELAY = UniformInt.of(12000, 180000);
    public static final IntProvider THUNDER_DURATION = UniformInt.of(3600, 15600);
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int EMPTY_TIME_NO_TICK = 300;
    private static final int MAX_SCHEDULED_TICKS_PER_TICK = 65536;
    final List<ServerPlayer> players = Lists.newArrayList();
    private final ServerChunkCache chunkSource;
    private final MinecraftServer server;
    private final ServerLevelData serverLevelData;
    private int lastSpawnChunkRadius;
    final EntityTickList entityTickList = new EntityTickList();
    private final PersistentEntitySectionManager<Entity> entityManager;
    private final GameEventDispatcher gameEventDispatcher;
    public boolean noSave;
    private final SleepStatus sleepStatus;
    private int emptyTime;
    private final PortalForcer portalForcer;
    private final LevelTicks<Block> blockTicks = new LevelTicks(this::isPositionTickingWithEntitiesLoaded);
    private final LevelTicks<Fluid> fluidTicks = new LevelTicks(this::isPositionTickingWithEntitiesLoaded);
    private final PathTypeCache pathTypesByPosCache = new PathTypeCache();
    final Set<Mob> navigatingMobs = new ObjectOpenHashSet();
    volatile boolean isUpdatingNavigations;
    protected final Raids raids;
    private final ObjectLinkedOpenHashSet<BlockEventData> blockEvents = new ObjectLinkedOpenHashSet();
    private final List<BlockEventData> blockEventsToReschedule = new ArrayList<BlockEventData>(64);
    private boolean handlingTick;
    private final List<CustomSpawner> customSpawners;
    @Nullable
    private EndDragonFight dragonFight;
    final Int2ObjectMap<EnderDragonPart> dragonParts = new Int2ObjectOpenHashMap();
    private final StructureManager structureManager;
    private final StructureCheck structureCheck;
    private final boolean tickTime;
    private final RandomSequences randomSequences;

    public ServerLevel(MinecraftServer p_214999_, Executor p_215000_, LevelStorageSource.LevelStorageAccess p_215001_, ServerLevelData p_215002_, ResourceKey<Level> p_215003_, LevelStem p_215004_, ChunkProgressListener p_215005_, boolean p_215006_, long p_215007_, List<CustomSpawner> p_215008_, boolean p_215009_, @Nullable RandomSequences p_288977_) {
        super(p_215002_, p_215003_, p_214999_.registryAccess(), p_215004_.type(), false, p_215006_, p_215007_, p_214999_.getMaxChainedNeighborUpdates());
        this.tickTime = p_215009_;
        this.server = p_214999_;
        this.customSpawners = p_215008_;
        this.serverLevelData = p_215002_;
        ChunkGenerator $$12 = p_215004_.generator();
        boolean $$13 = p_214999_.forceSynchronousWrites();
        DataFixer $$14 = p_214999_.getFixerUpper();
        EntityStorage $$15 = new EntityStorage(new SimpleRegionStorage(new RegionStorageInfo(p_215001_.getLevelId(), p_215003_, "entities"), p_215001_.getDimensionPath(p_215003_).resolve("entities"), $$14, $$13, DataFixTypes.ENTITY_CHUNK), this, p_214999_);
        this.entityManager = new PersistentEntitySectionManager<Entity>(Entity.class, new EntityCallbacks(), $$15);
        this.chunkSource = new ServerChunkCache(this, p_215001_, $$14, p_214999_.getStructureManager(), p_215000_, $$12, p_214999_.getPlayerList().getViewDistance(), p_214999_.getPlayerList().getSimulationDistance(), $$13, p_215005_, this.entityManager::updateChunkStatus, () -> p_214999_.overworld().getDataStorage());
        this.chunkSource.getGeneratorState().ensureStructuresGenerated();
        this.portalForcer = new PortalForcer(this);
        this.updateSkyBrightness();
        this.prepareWeather();
        this.getWorldBorder().setAbsoluteMaxSize(p_214999_.getAbsoluteMaxWorldSize());
        this.raids = this.getDataStorage().computeIfAbsent(Raids.getType(this.dimensionTypeRegistration()));
        if (!p_214999_.isSingleplayer()) {
            p_215002_.setGameType(p_214999_.getDefaultGameType());
        }
        long $$16 = p_214999_.getWorldData().worldGenOptions().seed();
        this.structureCheck = new StructureCheck(this.chunkSource.chunkScanner(), this.registryAccess(), p_214999_.getStructureManager(), p_215003_, $$12, this.chunkSource.randomState(), this, $$12.getBiomeSource(), $$16, $$14);
        this.structureManager = new StructureManager(this, p_214999_.getWorldData().worldGenOptions(), this.structureCheck);
        this.dragonFight = this.dimension() == Level.END && this.dimensionTypeRegistration().is(BuiltinDimensionTypes.END) ? new EndDragonFight(this, $$16, p_214999_.getWorldData().endDragonFightData()) : null;
        this.sleepStatus = new SleepStatus();
        this.gameEventDispatcher = new GameEventDispatcher(this);
        this.randomSequences = Objects.requireNonNullElseGet(p_288977_, () -> this.getDataStorage().computeIfAbsent(RandomSequences.TYPE));
    }

    @Deprecated
    @VisibleForTesting
    public void setDragonFight(@Nullable EndDragonFight p_287779_) {
        this.dragonFight = p_287779_;
    }

    public void setWeatherParameters(int p_8607_, int p_8608_, boolean p_8609_, boolean p_8610_) {
        this.serverLevelData.setClearWeatherTime(p_8607_);
        this.serverLevelData.setRainTime(p_8608_);
        this.serverLevelData.setThunderTime(p_8608_);
        this.serverLevelData.setRaining(p_8609_);
        this.serverLevelData.setThundering(p_8610_);
    }

    @Override
    public Holder<Biome> getUncachedNoiseBiome(int p_203775_, int p_203776_, int p_203777_) {
        return this.getChunkSource().getGenerator().getBiomeSource().getNoiseBiome(p_203775_, p_203776_, p_203777_, this.getChunkSource().randomState().sampler());
    }

    public StructureManager structureManager() {
        return this.structureManager;
    }

    public void tick(BooleanSupplier p_8794_) {
        boolean $$7;
        int $$4;
        ProfilerFiller $$1 = Profiler.get();
        this.handlingTick = true;
        TickRateManager $$2 = this.tickRateManager();
        boolean $$3 = $$2.runsNormally();
        if ($$3) {
            $$1.push("world border");
            this.getWorldBorder().tick();
            $$1.popPush("weather");
            this.advanceWeatherCycle();
            $$1.pop();
        }
        if (this.sleepStatus.areEnoughSleeping($$4 = this.getGameRules().getInt(GameRules.RULE_PLAYERS_SLEEPING_PERCENTAGE)) && this.sleepStatus.areEnoughDeepSleeping($$4, this.players)) {
            if (this.getGameRules().getBoolean(GameRules.RULE_DAYLIGHT)) {
                long $$5 = this.levelData.getDayTime() + 24000L;
                this.setDayTime($$5 - $$5 % 24000L);
            }
            this.wakeUpAllPlayers();
            if (this.getGameRules().getBoolean(GameRules.RULE_WEATHER_CYCLE) && this.isRaining()) {
                this.resetWeatherCycle();
            }
        }
        this.updateSkyBrightness();
        if ($$3) {
            this.tickTime();
        }
        $$1.push("tickPending");
        if (!this.isDebug() && $$3) {
            long $$6 = this.getGameTime();
            $$1.push("blockTicks");
            this.blockTicks.tick($$6, 65536, this::tickBlock);
            $$1.popPush("fluidTicks");
            this.fluidTicks.tick($$6, 65536, this::tickFluid);
            $$1.pop();
        }
        $$1.popPush("raid");
        if ($$3) {
            this.raids.tick(this);
        }
        $$1.popPush("chunkSource");
        this.getChunkSource().tick(p_8794_, true);
        $$1.popPush("blockEvents");
        if ($$3) {
            this.runBlockEvents();
        }
        this.handlingTick = false;
        $$1.pop();
        boolean bl = $$7 = !this.players.isEmpty() || !this.getForceLoadedChunks().isEmpty();
        if ($$7) {
            this.resetEmptyTime();
        }
        if ($$7 || this.emptyTime++ < 300) {
            $$1.push("entities");
            if (this.dragonFight != null && $$3) {
                $$1.push("dragonFight");
                this.dragonFight.tick();
                $$1.pop();
            }
            this.entityTickList.forEach(p_359620_ -> {
                if (p_359620_.isRemoved()) {
                    return;
                }
                if ($$2.isEntityFrozen((Entity)p_359620_)) {
                    return;
                }
                $$1.push("checkDespawn");
                p_359620_.checkDespawn();
                $$1.pop();
                if (!(p_359620_ instanceof ServerPlayer) && !this.chunkSource.chunkMap.getDistanceManager().inEntityTickingRange(p_359620_.chunkPosition().toLong())) {
                    return;
                }
                Entity $$3 = p_359620_.getVehicle();
                if ($$3 != null) {
                    if ($$3.isRemoved() || !$$3.hasPassenger((Entity)p_359620_)) {
                        p_359620_.stopRiding();
                    } else {
                        return;
                    }
                }
                $$1.push("tick");
                this.guardEntityTick(this::tickNonPassenger, p_359620_);
                $$1.pop();
            });
            $$1.pop();
            this.tickBlockEntities();
        }
        $$1.push("entityManagement");
        this.entityManager.tick();
        $$1.pop();
    }

    @Override
    public boolean shouldTickBlocksAt(long p_184059_) {
        return this.chunkSource.chunkMap.getDistanceManager().inBlockTickingRange(p_184059_);
    }

    protected void tickTime() {
        if (!this.tickTime) {
            return;
        }
        long $$0 = this.levelData.getGameTime() + 1L;
        this.serverLevelData.setGameTime($$0);
        Profiler.get().push("scheduledFunctions");
        this.serverLevelData.getScheduledEvents().tick(this.server, $$0);
        Profiler.get().pop();
        if (this.serverLevelData.getGameRules().getBoolean(GameRules.RULE_DAYLIGHT)) {
            this.setDayTime(this.levelData.getDayTime() + 1L);
        }
    }

    public void setDayTime(long p_8616_) {
        this.serverLevelData.setDayTime(p_8616_);
    }

    public void tickCustomSpawners(boolean p_8800_, boolean p_8801_) {
        for (CustomSpawner $$2 : this.customSpawners) {
            $$2.tick(this, p_8800_, p_8801_);
        }
    }

    private void wakeUpAllPlayers() {
        this.sleepStatus.removeAllSleepers();
        this.players.stream().filter(LivingEntity::isSleeping).collect(Collectors.toList()).forEach(p_184116_ -> p_184116_.stopSleepInBed(false, false));
    }

    public void tickChunk(LevelChunk p_8715_, int p_8716_) {
        ChunkPos $$2 = p_8715_.getPos();
        int $$3 = $$2.getMinBlockX();
        int $$4 = $$2.getMinBlockZ();
        ProfilerFiller $$5 = Profiler.get();
        $$5.push("iceandsnow");
        for (int $$6 = 0; $$6 < p_8716_; ++$$6) {
            if (this.random.nextInt(48) != 0) continue;
            this.tickPrecipitation(this.getBlockRandomPos($$3, 0, $$4, 15));
        }
        $$5.popPush("tickBlocks");
        if (p_8716_ > 0) {
            LevelChunkSection[] $$7 = p_8715_.getSections();
            for (int $$8 = 0; $$8 < $$7.length; ++$$8) {
                LevelChunkSection $$9 = $$7[$$8];
                if (!$$9.isRandomlyTicking()) continue;
                int $$10 = p_8715_.getSectionYFromSectionIndex($$8);
                int $$11 = SectionPos.sectionToBlockCoord($$10);
                for (int $$12 = 0; $$12 < p_8716_; ++$$12) {
                    FluidState $$15;
                    BlockPos $$13 = this.getBlockRandomPos($$3, $$11, $$4, 15);
                    $$5.push("randomTick");
                    BlockState $$14 = $$9.getBlockState($$13.getX() - $$3, $$13.getY() - $$11, $$13.getZ() - $$4);
                    if ($$14.isRandomlyTicking()) {
                        $$14.randomTick(this, $$13, this.random);
                    }
                    if (($$15 = $$14.getFluidState()).isRandomlyTicking()) {
                        $$15.randomTick(this, $$13, this.random);
                    }
                    $$5.pop();
                }
            }
        }
        $$5.pop();
    }

    public void tickThunder(LevelChunk p_401824_) {
        BlockPos $$6;
        ChunkPos $$1 = p_401824_.getPos();
        boolean $$2 = this.isRaining();
        int $$3 = $$1.getMinBlockX();
        int $$4 = $$1.getMinBlockZ();
        ProfilerFiller $$5 = Profiler.get();
        $$5.push("thunder");
        if ($$2 && this.isThundering() && this.random.nextInt(100000) == 0 && this.isRainingAt($$6 = this.findLightningTargetAround(this.getBlockRandomPos($$3, 0, $$4, 15)))) {
            LightningBolt $$10;
            SkeletonHorse $$9;
            boolean $$8;
            DifficultyInstance $$7 = this.getCurrentDifficultyAt($$6);
            boolean bl = $$8 = this.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING) && this.random.nextDouble() < (double)$$7.getEffectiveDifficulty() * 0.01 && !this.getBlockState($$6.below()).is(Blocks.LIGHTNING_ROD);
            if ($$8 && ($$9 = EntityType.SKELETON_HORSE.create(this, EntitySpawnReason.EVENT)) != null) {
                $$9.setTrap(true);
                $$9.setAge(0);
                $$9.setPos($$6.getX(), $$6.getY(), $$6.getZ());
                this.addFreshEntity($$9);
            }
            if (($$10 = EntityType.LIGHTNING_BOLT.create(this, EntitySpawnReason.EVENT)) != null) {
                $$10.snapTo(Vec3.atBottomCenterOf($$6));
                $$10.setVisualOnly($$8);
                this.addFreshEntity($$10);
            }
        }
        $$5.pop();
    }

    @VisibleForTesting
    public void tickPrecipitation(BlockPos p_295060_) {
        BlockPos $$1 = this.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, p_295060_);
        BlockPos $$2 = $$1.below();
        Biome $$3 = this.getBiome($$1).value();
        if ($$3.shouldFreeze(this, $$2)) {
            this.setBlockAndUpdate($$2, Blocks.ICE.defaultBlockState());
        }
        if (this.isRaining()) {
            Biome.Precipitation $$8;
            int $$4 = this.getGameRules().getInt(GameRules.RULE_SNOW_ACCUMULATION_HEIGHT);
            if ($$4 > 0 && $$3.shouldSnow(this, $$1)) {
                BlockState $$5 = this.getBlockState($$1);
                if ($$5.is(Blocks.SNOW)) {
                    int $$6 = $$5.getValue(SnowLayerBlock.LAYERS);
                    if ($$6 < Math.min($$4, 8)) {
                        BlockState $$7 = (BlockState)$$5.setValue(SnowLayerBlock.LAYERS, $$6 + 1);
                        Block.pushEntitiesUp($$5, $$7, this, $$1);
                        this.setBlockAndUpdate($$1, $$7);
                    }
                } else {
                    this.setBlockAndUpdate($$1, Blocks.SNOW.defaultBlockState());
                }
            }
            if (($$8 = $$3.getPrecipitationAt($$2, this.getSeaLevel())) != Biome.Precipitation.NONE) {
                BlockState $$9 = this.getBlockState($$2);
                $$9.getBlock().handlePrecipitation($$9, this, $$2, $$8);
            }
        }
    }

    private Optional<BlockPos> findLightningRod(BlockPos p_143249_) {
        Optional<BlockPos> $$1 = this.getPoiManager().findClosest(p_215059_ -> p_215059_.is(PoiTypes.LIGHTNING_ROD), p_184055_ -> p_184055_.getY() == this.getHeight(Heightmap.Types.WORLD_SURFACE, p_184055_.getX(), p_184055_.getZ()) - 1, p_143249_, 128, PoiManager.Occupancy.ANY);
        return $$1.map(p_184053_ -> p_184053_.above(1));
    }

    protected BlockPos findLightningTargetAround(BlockPos p_143289_) {
        BlockPos $$1 = this.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, p_143289_);
        Optional<BlockPos> $$2 = this.findLightningRod($$1);
        if ($$2.isPresent()) {
            return $$2.get();
        }
        AABB $$3 = AABB.encapsulatingFullBlocks($$1, $$1.atY(this.getMaxY() + 1)).inflate(3.0);
        List<LivingEntity> $$4 = this.getEntitiesOfClass(LivingEntity.class, $$3, p_409172_ -> p_409172_ != null && p_409172_.isAlive() && this.canSeeSky(p_409172_.blockPosition()));
        if (!$$4.isEmpty()) {
            return $$4.get(this.random.nextInt($$4.size())).blockPosition();
        }
        if ($$1.getY() == this.getMinY() - 1) {
            $$1 = $$1.above(2);
        }
        return $$1;
    }

    public boolean isHandlingTick() {
        return this.handlingTick;
    }

    public boolean canSleepThroughNights() {
        return this.getGameRules().getInt(GameRules.RULE_PLAYERS_SLEEPING_PERCENTAGE) <= 100;
    }

    private void announceSleepStatus() {
        MutableComponent $$2;
        if (!this.canSleepThroughNights()) {
            return;
        }
        if (this.getServer().isSingleplayer() && !this.getServer().isPublished()) {
            return;
        }
        int $$0 = this.getGameRules().getInt(GameRules.RULE_PLAYERS_SLEEPING_PERCENTAGE);
        if (this.sleepStatus.areEnoughSleeping($$0)) {
            MutableComponent $$1 = Component.translatable("sleep.skipping_night");
        } else {
            $$2 = Component.translatable("sleep.players_sleeping", this.sleepStatus.amountSleeping(), this.sleepStatus.sleepersNeeded($$0));
        }
        for (ServerPlayer $$3 : this.players) {
            $$3.displayClientMessage($$2, true);
        }
    }

    public void updateSleepingPlayerList() {
        if (!this.players.isEmpty() && this.sleepStatus.update(this.players)) {
            this.announceSleepStatus();
        }
    }

    @Override
    public ServerScoreboard getScoreboard() {
        return this.server.getScoreboard();
    }

    private void advanceWeatherCycle() {
        boolean $$0 = this.isRaining();
        if (this.dimensionType().hasSkyLight()) {
            if (this.getGameRules().getBoolean(GameRules.RULE_WEATHER_CYCLE)) {
                int $$1 = this.serverLevelData.getClearWeatherTime();
                int $$2 = this.serverLevelData.getThunderTime();
                int $$3 = this.serverLevelData.getRainTime();
                boolean $$4 = this.levelData.isThundering();
                boolean $$5 = this.levelData.isRaining();
                if ($$1 > 0) {
                    --$$1;
                    $$2 = $$4 ? 0 : 1;
                    $$3 = $$5 ? 0 : 1;
                    $$4 = false;
                    $$5 = false;
                } else {
                    if ($$2 > 0) {
                        if (--$$2 == 0) {
                            $$4 = !$$4;
                        }
                    } else {
                        $$2 = $$4 ? THUNDER_DURATION.sample(this.random) : THUNDER_DELAY.sample(this.random);
                    }
                    if ($$3 > 0) {
                        if (--$$3 == 0) {
                            $$5 = !$$5;
                        }
                    } else {
                        $$3 = $$5 ? RAIN_DURATION.sample(this.random) : RAIN_DELAY.sample(this.random);
                    }
                }
                this.serverLevelData.setThunderTime($$2);
                this.serverLevelData.setRainTime($$3);
                this.serverLevelData.setClearWeatherTime($$1);
                this.serverLevelData.setThundering($$4);
                this.serverLevelData.setRaining($$5);
            }
            this.oThunderLevel = this.thunderLevel;
            this.thunderLevel = this.levelData.isThundering() ? (this.thunderLevel += 0.01f) : (this.thunderLevel -= 0.01f);
            this.thunderLevel = Mth.clamp(this.thunderLevel, 0.0f, 1.0f);
            this.oRainLevel = this.rainLevel;
            this.rainLevel = this.levelData.isRaining() ? (this.rainLevel += 0.01f) : (this.rainLevel -= 0.01f);
            this.rainLevel = Mth.clamp(this.rainLevel, 0.0f, 1.0f);
        }
        if (this.oRainLevel != this.rainLevel) {
            this.server.getPlayerList().broadcastAll(new ClientboundGameEventPacket(ClientboundGameEventPacket.RAIN_LEVEL_CHANGE, this.rainLevel), this.dimension());
        }
        if (this.oThunderLevel != this.thunderLevel) {
            this.server.getPlayerList().broadcastAll(new ClientboundGameEventPacket(ClientboundGameEventPacket.THUNDER_LEVEL_CHANGE, this.thunderLevel), this.dimension());
        }
        if ($$0 != this.isRaining()) {
            if ($$0) {
                this.server.getPlayerList().broadcastAll(new ClientboundGameEventPacket(ClientboundGameEventPacket.STOP_RAINING, 0.0f));
            } else {
                this.server.getPlayerList().broadcastAll(new ClientboundGameEventPacket(ClientboundGameEventPacket.START_RAINING, 0.0f));
            }
            this.server.getPlayerList().broadcastAll(new ClientboundGameEventPacket(ClientboundGameEventPacket.RAIN_LEVEL_CHANGE, this.rainLevel));
            this.server.getPlayerList().broadcastAll(new ClientboundGameEventPacket(ClientboundGameEventPacket.THUNDER_LEVEL_CHANGE, this.thunderLevel));
        }
    }

    @VisibleForTesting
    public void resetWeatherCycle() {
        this.serverLevelData.setRainTime(0);
        this.serverLevelData.setRaining(false);
        this.serverLevelData.setThunderTime(0);
        this.serverLevelData.setThundering(false);
    }

    public void resetEmptyTime() {
        this.emptyTime = 0;
    }

    private void tickFluid(BlockPos p_184077_, Fluid p_184078_) {
        BlockState $$2 = this.getBlockState(p_184077_);
        FluidState $$3 = $$2.getFluidState();
        if ($$3.is(p_184078_)) {
            $$3.tick(this, p_184077_, $$2);
        }
    }

    private void tickBlock(BlockPos p_184113_, Block p_184114_) {
        BlockState $$2 = this.getBlockState(p_184113_);
        if ($$2.is(p_184114_)) {
            $$2.tick(this, p_184113_, this.random);
        }
    }

    public void tickNonPassenger(Entity p_8648_) {
        p_8648_.setOldPosAndRot();
        ProfilerFiller $$1 = Profiler.get();
        ++p_8648_.tickCount;
        $$1.push(() -> BuiltInRegistries.ENTITY_TYPE.getKey(p_8648_.getType()).toString());
        $$1.incrementCounter("tickNonPassenger");
        p_8648_.tick();
        $$1.pop();
        for (Entity $$2 : p_8648_.getPassengers()) {
            this.tickPassenger(p_8648_, $$2);
        }
    }

    private void tickPassenger(Entity p_8663_, Entity p_8664_) {
        if (p_8664_.isRemoved() || p_8664_.getVehicle() != p_8663_) {
            p_8664_.stopRiding();
            return;
        }
        if (!(p_8664_ instanceof Player) && !this.entityTickList.contains(p_8664_)) {
            return;
        }
        p_8664_.setOldPosAndRot();
        ++p_8664_.tickCount;
        ProfilerFiller $$2 = Profiler.get();
        $$2.push(() -> BuiltInRegistries.ENTITY_TYPE.getKey(p_8664_.getType()).toString());
        $$2.incrementCounter("tickPassenger");
        p_8664_.rideTick();
        $$2.pop();
        for (Entity $$3 : p_8664_.getPassengers()) {
            this.tickPassenger(p_8664_, $$3);
        }
    }

    @Override
    public boolean mayInteract(Entity p_393624_, BlockPos p_8697_) {
        Player $$2;
        return !(p_393624_ instanceof Player) || !this.server.isUnderSpawnProtection(this, p_8697_, $$2 = (Player)p_393624_) && this.getWorldBorder().isWithinBounds(p_8697_);
    }

    public void save(@Nullable ProgressListener p_8644_, boolean p_8645_, boolean p_8646_) {
        ServerChunkCache $$3 = this.getChunkSource();
        if (p_8646_) {
            return;
        }
        if (p_8644_ != null) {
            p_8644_.progressStartNoAbort(Component.translatable("menu.savingLevel"));
        }
        this.saveLevelData(p_8645_);
        if (p_8644_ != null) {
            p_8644_.progressStage(Component.translatable("menu.savingChunks"));
        }
        $$3.save(p_8645_);
        if (p_8645_) {
            this.entityManager.saveAll();
        } else {
            this.entityManager.autoSave();
        }
    }

    private void saveLevelData(boolean p_364073_) {
        if (this.dragonFight != null) {
            this.server.getWorldData().setEndDragonFightData(this.dragonFight.saveData());
        }
        DimensionDataStorage $$1 = this.getChunkSource().getDataStorage();
        if (p_364073_) {
            $$1.saveAndJoin();
        } else {
            $$1.scheduleSave();
        }
    }

    public <T extends Entity> List<? extends T> getEntities(EntityTypeTest<Entity, T> p_143281_, Predicate<? super T> p_143282_) {
        ArrayList $$2 = Lists.newArrayList();
        this.getEntities(p_143281_, p_143282_, $$2);
        return $$2;
    }

    public <T extends Entity> void getEntities(EntityTypeTest<Entity, T> p_262152_, Predicate<? super T> p_261808_, List<? super T> p_261583_) {
        this.getEntities(p_262152_, p_261808_, p_261583_, Integer.MAX_VALUE);
    }

    public <T extends Entity> void getEntities(EntityTypeTest<Entity, T> p_261842_, Predicate<? super T> p_262091_, List<? super T> p_261703_, int p_261907_) {
        this.getEntities().get(p_261842_, p_261428_ -> {
            if (p_262091_.test(p_261428_)) {
                p_261703_.add((Object)p_261428_);
                if (p_261703_.size() >= p_261907_) {
                    return AbortableIterationConsumer.Continuation.ABORT;
                }
            }
            return AbortableIterationConsumer.Continuation.CONTINUE;
        });
    }

    public List<? extends EnderDragon> getDragons() {
        return this.getEntities(EntityType.ENDER_DRAGON, LivingEntity::isAlive);
    }

    public List<ServerPlayer> getPlayers(Predicate<? super ServerPlayer> p_8796_) {
        return this.getPlayers(p_8796_, Integer.MAX_VALUE);
    }

    public List<ServerPlayer> getPlayers(Predicate<? super ServerPlayer> p_261698_, int p_262035_) {
        ArrayList $$2 = Lists.newArrayList();
        for (ServerPlayer $$3 : this.players) {
            if (!p_261698_.test($$3)) continue;
            $$2.add($$3);
            if ($$2.size() < p_262035_) continue;
            return $$2;
        }
        return $$2;
    }

    @Nullable
    public ServerPlayer getRandomPlayer() {
        List<ServerPlayer> $$0 = this.getPlayers(LivingEntity::isAlive);
        if ($$0.isEmpty()) {
            return null;
        }
        return $$0.get(this.random.nextInt($$0.size()));
    }

    @Override
    public boolean addFreshEntity(Entity p_8837_) {
        return this.addEntity(p_8837_);
    }

    public boolean addWithUUID(Entity p_8848_) {
        return this.addEntity(p_8848_);
    }

    public void addDuringTeleport(Entity p_143335_) {
        if (p_143335_ instanceof ServerPlayer) {
            ServerPlayer $$1 = (ServerPlayer)p_143335_;
            this.addPlayer($$1);
        } else {
            this.addEntity(p_143335_);
        }
    }

    public void addNewPlayer(ServerPlayer p_8835_) {
        this.addPlayer(p_8835_);
    }

    public void addRespawnedPlayer(ServerPlayer p_8846_) {
        this.addPlayer(p_8846_);
    }

    private void addPlayer(ServerPlayer p_8854_) {
        Entity $$1 = this.getEntity(p_8854_.getUUID());
        if ($$1 != null) {
            LOGGER.warn("Force-added player with duplicate UUID {}", (Object)p_8854_.getUUID());
            $$1.unRide();
            this.removePlayerImmediately((ServerPlayer)$$1, Entity.RemovalReason.DISCARDED);
        }
        this.entityManager.addNewEntity(p_8854_);
    }

    private boolean addEntity(Entity p_8873_) {
        if (p_8873_.isRemoved()) {
            LOGGER.warn("Tried to add entity {} but it was marked as removed already", (Object)EntityType.getKey(p_8873_.getType()));
            return false;
        }
        return this.entityManager.addNewEntity(p_8873_);
    }

    public boolean tryAddFreshEntityWithPassengers(Entity p_8861_) {
        if (p_8861_.getSelfAndPassengers().map(Entity::getUUID).anyMatch(this.entityManager::isLoaded)) {
            return false;
        }
        this.addFreshEntityWithPassengers(p_8861_);
        return true;
    }

    public void unload(LevelChunk p_8713_) {
        p_8713_.clearAllBlockEntities();
        p_8713_.unregisterTickContainerFromLevel(this);
    }

    public void removePlayerImmediately(ServerPlayer p_143262_, Entity.RemovalReason p_143263_) {
        p_143262_.remove(p_143263_);
    }

    @Override
    public void destroyBlockProgress(int p_8612_, BlockPos p_8613_, int p_8614_) {
        for (ServerPlayer $$3 : this.server.getPlayerList().getPlayers()) {
            double $$6;
            double $$5;
            double $$4;
            if ($$3 == null || $$3.level() != this || $$3.getId() == p_8612_ || !(($$4 = (double)p_8613_.getX() - $$3.getX()) * $$4 + ($$5 = (double)p_8613_.getY() - $$3.getY()) * $$5 + ($$6 = (double)p_8613_.getZ() - $$3.getZ()) * $$6 < 1024.0)) continue;
            $$3.connection.send(new ClientboundBlockDestructionPacket(p_8612_, p_8613_, p_8614_));
        }
    }

    @Override
    public void playSeededSound(@Nullable Entity p_393855_, double p_263393_, double p_263369_, double p_263354_, Holder<SoundEvent> p_263412_, SoundSource p_263338_, float p_263352_, float p_263390_, long p_263403_) {
        Player $$9;
        this.server.getPlayerList().broadcast(p_393855_ instanceof Player ? ($$9 = (Player)p_393855_) : null, p_263393_, p_263369_, p_263354_, p_263412_.value().getRange(p_263352_), this.dimension(), new ClientboundSoundPacket(p_263412_, p_263338_, p_263393_, p_263369_, p_263354_, p_263352_, p_263390_, p_263403_));
    }

    @Override
    public void playSeededSound(@Nullable Entity p_263544_, Entity p_394316_, Holder<SoundEvent> p_263491_, SoundSource p_263542_, float p_263530_, float p_263520_, long p_263490_) {
        Player $$7;
        this.server.getPlayerList().broadcast(p_263544_ instanceof Player ? ($$7 = (Player)p_263544_) : null, p_394316_.getX(), p_394316_.getY(), p_394316_.getZ(), p_263491_.value().getRange(p_263530_), this.dimension(), new ClientboundSoundEntityPacket(p_263491_, p_263542_, p_394316_, p_263530_, p_263520_, p_263490_));
    }

    @Override
    public void globalLevelEvent(int p_8811_, BlockPos p_8812_, int p_8813_) {
        if (this.getGameRules().getBoolean(GameRules.RULE_GLOBAL_SOUND_EVENTS)) {
            this.server.getPlayerList().getPlayers().forEach(p_381695_ -> {
                Vec3 $$8;
                if (p_381695_.level() == this) {
                    Vec3 $$4 = Vec3.atCenterOf(p_8812_);
                    if (p_381695_.distanceToSqr($$4) < (double)Mth.square(32)) {
                        Vec3 $$5 = $$4;
                    } else {
                        Vec3 $$6 = $$4.subtract(p_381695_.position()).normalize();
                        Vec3 $$7 = p_381695_.position().add($$6.scale(32.0));
                    }
                } else {
                    $$8 = p_381695_.position();
                }
                p_381695_.connection.send(new ClientboundLevelEventPacket(p_8811_, BlockPos.containing($$8), p_8813_, true));
            });
        } else {
            this.levelEvent(null, p_8811_, p_8812_, p_8813_);
        }
    }

    @Override
    public void levelEvent(@Nullable Entity p_393790_, int p_8685_, BlockPos p_8686_, int p_8687_) {
        Player $$4;
        this.server.getPlayerList().broadcast(p_393790_ instanceof Player ? ($$4 = (Player)p_393790_) : null, p_8686_.getX(), p_8686_.getY(), p_8686_.getZ(), 64.0, this.dimension(), new ClientboundLevelEventPacket(p_8685_, p_8686_, p_8687_, false));
    }

    public int getLogicalHeight() {
        return this.dimensionType().logicalHeight();
    }

    @Override
    public void gameEvent(Holder<GameEvent> p_316597_, Vec3 p_215042_, GameEvent.Context p_215043_) {
        this.gameEventDispatcher.post(p_316597_, p_215042_, p_215043_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendBlockUpdated(BlockPos p_8755_, BlockState p_8756_, BlockState p_8757_, int p_8758_) {
        if (this.isUpdatingNavigations) {
            String $$4 = "recursive call to sendBlockUpdated";
            Util.logAndPauseIfInIde("recursive call to sendBlockUpdated", new IllegalStateException("recursive call to sendBlockUpdated"));
        }
        this.getChunkSource().blockChanged(p_8755_);
        this.pathTypesByPosCache.invalidate(p_8755_);
        VoxelShape $$5 = p_8756_.getCollisionShape(this, p_8755_);
        VoxelShape $$6 = p_8757_.getCollisionShape(this, p_8755_);
        if (!Shapes.joinIsNotEmpty($$5, $$6, BooleanOp.NOT_SAME)) {
            return;
        }
        ObjectArrayList $$7 = new ObjectArrayList();
        for (Mob $$8 : this.navigatingMobs) {
            PathNavigation $$9 = $$8.getNavigation();
            if (!$$9.shouldRecomputePath(p_8755_)) continue;
            $$7.add($$9);
        }
        try {
            this.isUpdatingNavigations = true;
            for (PathNavigation $$10 : $$7) {
                $$10.recomputePath();
            }
        }
        finally {
            this.isUpdatingNavigations = false;
        }
    }

    @Override
    public void updateNeighborsAt(BlockPos p_215045_, Block p_215046_) {
        this.updateNeighborsAt(p_215045_, p_215046_, ExperimentalRedstoneUtils.initialOrientation(this, null, null));
    }

    @Override
    public void updateNeighborsAt(BlockPos p_363893_, Block p_362383_, @Nullable Orientation p_364696_) {
        this.neighborUpdater.updateNeighborsAtExceptFromFacing(p_363893_, p_362383_, null, p_364696_);
    }

    @Override
    public void updateNeighborsAtExceptFromFacing(BlockPos p_215052_, Block p_215053_, Direction p_215054_, @Nullable Orientation p_365231_) {
        this.neighborUpdater.updateNeighborsAtExceptFromFacing(p_215052_, p_215053_, p_215054_, p_365231_);
    }

    @Override
    public void neighborChanged(BlockPos p_215036_, Block p_215037_, @Nullable Orientation p_363242_) {
        this.neighborUpdater.neighborChanged(p_215036_, p_215037_, p_363242_);
    }

    @Override
    public void neighborChanged(BlockState p_362490_, BlockPos p_215048_, Block p_215049_, @Nullable Orientation p_363197_, boolean p_365415_) {
        this.neighborUpdater.neighborChanged(p_362490_, p_215048_, p_215049_, p_363197_, p_365415_);
    }

    @Override
    public void broadcastEntityEvent(Entity p_8650_, byte p_8651_) {
        this.getChunkSource().broadcastAndSend(p_8650_, new ClientboundEntityEventPacket(p_8650_, p_8651_));
    }

    @Override
    public void broadcastDamageEvent(Entity p_270420_, DamageSource p_270311_) {
        this.getChunkSource().broadcastAndSend(p_270420_, new ClientboundDamageEventPacket(p_270420_, p_270311_));
    }

    @Override
    public ServerChunkCache getChunkSource() {
        return this.chunkSource;
    }

    @Override
    public void explode(@Nullable Entity p_256039_, @Nullable DamageSource p_255778_, @Nullable ExplosionDamageCalculator p_256002_, double p_256067_, double p_256370_, double p_256153_, float p_256045_, boolean p_255686_, Level.ExplosionInteraction p_255827_, ParticleOptions p_312436_, ParticleOptions p_312391_, Holder<SoundEvent> p_320497_) {
        Explosion.BlockInteraction $$12 = switch (p_255827_) {
            default -> throw new MatchException(null, null);
            case Level.ExplosionInteraction.NONE -> Explosion.BlockInteraction.KEEP;
            case Level.ExplosionInteraction.BLOCK -> this.getDestroyType(GameRules.RULE_BLOCK_EXPLOSION_DROP_DECAY);
            case Level.ExplosionInteraction.MOB -> {
                if (this.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
                    yield this.getDestroyType(GameRules.RULE_MOB_EXPLOSION_DROP_DECAY);
                }
                yield Explosion.BlockInteraction.KEEP;
            }
            case Level.ExplosionInteraction.TNT -> this.getDestroyType(GameRules.RULE_TNT_EXPLOSION_DROP_DECAY);
            case Level.ExplosionInteraction.TRIGGER -> Explosion.BlockInteraction.TRIGGER_BLOCK;
        };
        Vec3 $$13 = new Vec3(p_256067_, p_256370_, p_256153_);
        ServerExplosion $$14 = new ServerExplosion(this, p_256039_, p_255778_, p_256002_, $$13, p_256045_, p_255686_, $$12);
        $$14.explode();
        ParticleOptions $$15 = $$14.isSmall() ? p_312436_ : p_312391_;
        for (ServerPlayer $$16 : this.players) {
            if (!($$16.distanceToSqr($$13) < 4096.0)) continue;
            Optional<Vec3> $$17 = Optional.ofNullable($$14.getHitPlayers().get($$16));
            $$16.connection.send(new ClientboundExplodePacket($$13, $$17, $$15, p_320497_));
        }
    }

    private Explosion.BlockInteraction getDestroyType(GameRules.Key<GameRules.BooleanValue> p_361991_) {
        return this.getGameRules().getBoolean(p_361991_) ? Explosion.BlockInteraction.DESTROY_WITH_DECAY : Explosion.BlockInteraction.DESTROY;
    }

    @Override
    public void blockEvent(BlockPos p_8746_, Block p_8747_, int p_8748_, int p_8749_) {
        this.blockEvents.add((Object)new BlockEventData(p_8746_, p_8747_, p_8748_, p_8749_));
    }

    private void runBlockEvents() {
        this.blockEventsToReschedule.clear();
        while (!this.blockEvents.isEmpty()) {
            BlockEventData $$0 = (BlockEventData)this.blockEvents.removeFirst();
            if (this.shouldTickBlocksAt($$0.pos())) {
                if (!this.doBlockEvent($$0)) continue;
                this.server.getPlayerList().broadcast(null, $$0.pos().getX(), $$0.pos().getY(), $$0.pos().getZ(), 64.0, this.dimension(), new ClientboundBlockEventPacket($$0.pos(), $$0.block(), $$0.paramA(), $$0.paramB()));
                continue;
            }
            this.blockEventsToReschedule.add($$0);
        }
        this.blockEvents.addAll(this.blockEventsToReschedule);
    }

    private boolean doBlockEvent(BlockEventData p_8699_) {
        BlockState $$1 = this.getBlockState(p_8699_.pos());
        if ($$1.is(p_8699_.block())) {
            return $$1.triggerEvent(this, p_8699_.pos(), p_8699_.paramA(), p_8699_.paramB());
        }
        return false;
    }

    public LevelTicks<Block> getBlockTicks() {
        return this.blockTicks;
    }

    public LevelTicks<Fluid> getFluidTicks() {
        return this.fluidTicks;
    }

    @Override
    @Nonnull
    public MinecraftServer getServer() {
        return this.server;
    }

    public PortalForcer getPortalForcer() {
        return this.portalForcer;
    }

    public StructureTemplateManager getStructureManager() {
        return this.server.getStructureManager();
    }

    public <T extends ParticleOptions> int sendParticles(T p_8768_, double p_8769_, double p_8770_, double p_8771_, int p_8772_, double p_8773_, double p_8774_, double p_8775_, double p_8776_) {
        return this.sendParticles(p_8768_, false, false, p_8769_, p_8770_, p_8771_, p_8772_, p_8773_, p_8774_, p_8775_, p_8776_);
    }

    public <T extends ParticleOptions> int sendParticles(T p_383163_, boolean p_382791_, boolean p_383241_, double p_382894_, double p_383049_, double p_382861_, int p_382789_, double p_382818_, double p_382875_, double p_383002_, double p_383103_) {
        ClientboundLevelParticlesPacket $$11 = new ClientboundLevelParticlesPacket(p_383163_, p_382791_, p_383241_, p_382894_, p_383049_, p_382861_, (float)p_382818_, (float)p_382875_, (float)p_383002_, (float)p_383103_, p_382789_);
        int $$12 = 0;
        for (int $$13 = 0; $$13 < this.players.size(); ++$$13) {
            ServerPlayer $$14 = this.players.get($$13);
            if (!this.sendParticles($$14, p_382791_, p_382894_, p_383049_, p_382861_, $$11)) continue;
            ++$$12;
        }
        return $$12;
    }

    public <T extends ParticleOptions> boolean sendParticles(ServerPlayer p_8625_, T p_8626_, boolean p_8627_, boolean p_382903_, double p_8628_, double p_8629_, double p_8630_, int p_8631_, double p_8632_, double p_8633_, double p_8634_, double p_8635_) {
        ClientboundLevelParticlesPacket $$12 = new ClientboundLevelParticlesPacket(p_8626_, p_8627_, p_382903_, p_8628_, p_8629_, p_8630_, (float)p_8632_, (float)p_8633_, (float)p_8634_, (float)p_8635_, p_8631_);
        return this.sendParticles(p_8625_, p_8627_, p_8628_, p_8629_, p_8630_, $$12);
    }

    private boolean sendParticles(ServerPlayer p_8637_, boolean p_8638_, double p_8639_, double p_8640_, double p_8641_, Packet<?> p_8642_) {
        if (p_8637_.level() != this) {
            return false;
        }
        BlockPos $$6 = p_8637_.blockPosition();
        if ($$6.closerToCenterThan(new Vec3(p_8639_, p_8640_, p_8641_), p_8638_ ? 512.0 : 32.0)) {
            p_8637_.connection.send(p_8642_);
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public Entity getEntity(int p_8597_) {
        return this.getEntities().get(p_8597_);
    }

    @Deprecated
    @Nullable
    public Entity getEntityOrPart(int p_143318_) {
        Entity $$1 = this.getEntities().get(p_143318_);
        if ($$1 != null) {
            return $$1;
        }
        return (Entity)this.dragonParts.get(p_143318_);
    }

    @Override
    public Collection<EnderDragonPart> dragonParts() {
        return this.dragonParts.values();
    }

    @Nullable
    public BlockPos findNearestMapStructure(TagKey<Structure> p_215012_, BlockPos p_215013_, int p_215014_, boolean p_215015_) {
        if (!this.server.getWorldData().worldGenOptions().generateStructures()) {
            return null;
        }
        Optional $$4 = this.registryAccess().lookupOrThrow(Registries.STRUCTURE).get(p_215012_);
        if ($$4.isEmpty()) {
            return null;
        }
        Pair<BlockPos, Holder<Structure>> $$5 = this.getChunkSource().getGenerator().findNearestMapStructure(this, (HolderSet)$$4.get(), p_215013_, p_215014_, p_215015_);
        return $$5 != null ? (BlockPos)$$5.getFirst() : null;
    }

    @Nullable
    public Pair<BlockPos, Holder<Biome>> findClosestBiome3d(Predicate<Holder<Biome>> p_215070_, BlockPos p_215071_, int p_215072_, int p_215073_, int p_215074_) {
        return this.getChunkSource().getGenerator().getBiomeSource().findClosestBiome3d(p_215071_, p_215072_, p_215073_, p_215074_, p_215070_, this.getChunkSource().randomState().sampler(), this);
    }

    @Override
    public RecipeManager recipeAccess() {
        return this.server.getRecipeManager();
    }

    @Override
    public TickRateManager tickRateManager() {
        return this.server.tickRateManager();
    }

    @Override
    public boolean noSave() {
        return this.noSave;
    }

    public DimensionDataStorage getDataStorage() {
        return this.getChunkSource().getDataStorage();
    }

    @Override
    @Nullable
    public MapItemSavedData getMapData(MapId p_323746_) {
        return this.getServer().overworld().getDataStorage().get(MapItemSavedData.type(p_323746_));
    }

    public void setMapData(MapId p_323697_, MapItemSavedData p_143306_) {
        this.getServer().overworld().getDataStorage().set(MapItemSavedData.type(p_323697_), p_143306_);
    }

    public MapId getFreeMapId() {
        return this.getServer().overworld().getDataStorage().computeIfAbsent(MapIndex.TYPE).getNextMapId();
    }

    public void setDefaultSpawnPos(BlockPos p_8734_, float p_8735_) {
        int $$4;
        BlockPos $$2 = this.levelData.getSpawnPos();
        float $$3 = this.levelData.getSpawnAngle();
        if (!$$2.equals(p_8734_) || $$3 != p_8735_) {
            this.levelData.setSpawn(p_8734_, p_8735_);
            this.getServer().getPlayerList().broadcastAll(new ClientboundSetDefaultSpawnPositionPacket(p_8734_, p_8735_));
        }
        if (this.lastSpawnChunkRadius > 1) {
            this.getChunkSource().removeTicketWithRadius(TicketType.START, new ChunkPos($$2), this.lastSpawnChunkRadius);
        }
        if (($$4 = this.getGameRules().getInt(GameRules.RULE_SPAWN_CHUNK_RADIUS) + 1) > 1) {
            this.getChunkSource().addTicketWithRadius(TicketType.START, new ChunkPos(p_8734_), $$4);
        }
        this.lastSpawnChunkRadius = $$4;
    }

    public LongSet getForceLoadedChunks() {
        return this.chunkSource.getForceLoadedChunks();
    }

    public boolean setChunkForced(int p_8603_, int p_8604_, boolean p_8605_) {
        boolean $$3 = this.chunkSource.updateChunkForced(new ChunkPos(p_8603_, p_8604_), p_8605_);
        if (p_8605_ && $$3) {
            this.getChunk(p_8603_, p_8604_);
        }
        return $$3;
    }

    public List<ServerPlayer> players() {
        return this.players;
    }

    @Override
    public void updatePOIOnBlockStateChange(BlockPos p_8751_, BlockState p_8752_, BlockState p_8753_) {
        Optional<Holder<PoiType>> $$4;
        Optional<Holder<PoiType>> $$3 = PoiTypes.forState(p_8752_);
        if (Objects.equals($$3, $$4 = PoiTypes.forState(p_8753_))) {
            return;
        }
        BlockPos $$5 = p_8751_.immutable();
        $$3.ifPresent(p_215081_ -> this.getServer().execute(() -> {
            this.getPoiManager().remove($$5);
            DebugPackets.sendPoiRemovedPacket(this, $$5);
        }));
        $$4.ifPresent(p_215057_ -> this.getServer().execute(() -> {
            this.getPoiManager().add($$5, (Holder<PoiType>)p_215057_);
            DebugPackets.sendPoiAddedPacket(this, $$5);
        }));
    }

    public PoiManager getPoiManager() {
        return this.getChunkSource().getPoiManager();
    }

    public boolean isVillage(BlockPos p_8803_) {
        return this.isCloseToVillage(p_8803_, 1);
    }

    public boolean isVillage(SectionPos p_8763_) {
        return this.isVillage(p_8763_.center());
    }

    public boolean isCloseToVillage(BlockPos p_8737_, int p_8738_) {
        if (p_8738_ > 6) {
            return false;
        }
        return this.sectionsToVillage(SectionPos.of(p_8737_)) <= p_8738_;
    }

    public int sectionsToVillage(SectionPos p_8829_) {
        return this.getPoiManager().sectionsToVillage(p_8829_);
    }

    public Raids getRaids() {
        return this.raids;
    }

    @Nullable
    public Raid getRaidAt(BlockPos p_8833_) {
        return this.raids.getNearbyRaid(p_8833_, 9216);
    }

    public boolean isRaided(BlockPos p_8844_) {
        return this.getRaidAt(p_8844_) != null;
    }

    public void onReputationEvent(ReputationEventType p_8671_, Entity p_8672_, ReputationEventHandler p_8673_) {
        p_8673_.onReputationEventFrom(p_8671_, p_8672_);
    }

    public void saveDebugReport(Path p_8787_) throws IOException {
        ChunkMap $$1 = this.getChunkSource().chunkMap;
        try (BufferedWriter $$2 = Files.newBufferedWriter(p_8787_.resolve("stats.txt"), new OpenOption[0]);){
            $$2.write(String.format(Locale.ROOT, "spawning_chunks: %d\n", $$1.getDistanceManager().getNaturalSpawnChunkCount()));
            NaturalSpawner.SpawnState $$3 = this.getChunkSource().getLastSpawnState();
            if ($$3 != null) {
                for (Object2IntMap.Entry $$4 : $$3.getMobCategoryCounts().object2IntEntrySet()) {
                    $$2.write(String.format(Locale.ROOT, "spawn_count.%s: %d\n", ((MobCategory)$$4.getKey()).getName(), $$4.getIntValue()));
                }
            }
            $$2.write(String.format(Locale.ROOT, "entities: %s\n", this.entityManager.gatherStats()));
            $$2.write(String.format(Locale.ROOT, "block_entity_tickers: %d\n", this.blockEntityTickers.size()));
            $$2.write(String.format(Locale.ROOT, "block_ticks: %d\n", ((LevelTicks)this.getBlockTicks()).count()));
            $$2.write(String.format(Locale.ROOT, "fluid_ticks: %d\n", ((LevelTicks)this.getFluidTicks()).count()));
            $$2.write("distance_manager: " + $$1.getDistanceManager().getDebugStatus() + "\n");
            $$2.write(String.format(Locale.ROOT, "pending_tasks: %d\n", this.getChunkSource().getPendingTasksCount()));
        }
        CrashReport $$5 = new CrashReport("Level dump", new Exception("dummy"));
        this.fillReportDetails($$5);
        try (BufferedWriter $$6 = Files.newBufferedWriter(p_8787_.resolve("example_crash.txt"), new OpenOption[0]);){
            $$6.write($$5.getFriendlyReport(ReportType.TEST));
        }
        Path $$7 = p_8787_.resolve("chunks.csv");
        try (BufferedWriter $$8 = Files.newBufferedWriter($$7, new OpenOption[0]);){
            $$1.dumpChunks($$8);
        }
        Path $$9 = p_8787_.resolve("entity_chunks.csv");
        try (BufferedWriter $$10 = Files.newBufferedWriter($$9, new OpenOption[0]);){
            this.entityManager.dumpSections($$10);
        }
        Path $$11 = p_8787_.resolve("entities.csv");
        try (BufferedWriter $$12 = Files.newBufferedWriter($$11, new OpenOption[0]);){
            ServerLevel.dumpEntities($$12, this.getEntities().getAll());
        }
        Path $$13 = p_8787_.resolve("block_entities.csv");
        try (BufferedWriter $$14 = Files.newBufferedWriter($$13, new OpenOption[0]);){
            this.dumpBlockEntityTickers($$14);
        }
    }

    private static void dumpEntities(Writer p_8782_, Iterable<Entity> p_8783_) throws IOException {
        CsvOutput $$2 = CsvOutput.builder().addColumn("x").addColumn("y").addColumn("z").addColumn("uuid").addColumn("type").addColumn("alive").addColumn("display_name").addColumn("custom_name").build(p_8782_);
        for (Entity $$3 : p_8783_) {
            Component $$4 = $$3.getCustomName();
            Component $$5 = $$3.getDisplayName();
            $$2.writeRow($$3.getX(), $$3.getY(), $$3.getZ(), $$3.getUUID(), BuiltInRegistries.ENTITY_TYPE.getKey($$3.getType()), $$3.isAlive(), $$5.getString(), $$4 != null ? $$4.getString() : null);
        }
    }

    private void dumpBlockEntityTickers(Writer p_143300_) throws IOException {
        CsvOutput $$1 = CsvOutput.builder().addColumn("x").addColumn("y").addColumn("z").addColumn("type").build(p_143300_);
        for (TickingBlockEntity $$2 : this.blockEntityTickers) {
            BlockPos $$3 = $$2.getPos();
            $$1.writeRow($$3.getX(), $$3.getY(), $$3.getZ(), $$2.getType());
        }
    }

    @VisibleForTesting
    public void clearBlockEvents(BoundingBox p_8723_) {
        this.blockEvents.removeIf(p_207568_ -> p_8723_.isInside(p_207568_.pos()));
    }

    @Override
    public float getShade(Direction p_8760_, boolean p_8761_) {
        return 1.0f;
    }

    public Iterable<Entity> getAllEntities() {
        return this.getEntities().getAll();
    }

    public String toString() {
        return "ServerLevel[" + this.serverLevelData.getLevelName() + "]";
    }

    public boolean isFlat() {
        return this.server.getWorldData().isFlatWorld();
    }

    @Override
    public long getSeed() {
        return this.server.getWorldData().worldGenOptions().seed();
    }

    @Nullable
    public EndDragonFight getDragonFight() {
        return this.dragonFight;
    }

    @Override
    public ServerLevel getLevel() {
        return this;
    }

    @VisibleForTesting
    public String getWatchdogStats() {
        return String.format(Locale.ROOT, "players: %s, entities: %s [%s], block_entities: %d [%s], block_ticks: %d, fluid_ticks: %d, chunk_source: %s", this.players.size(), this.entityManager.gatherStats(), ServerLevel.getTypeCount(this.entityManager.getEntityGetter().getAll(), p_258244_ -> BuiltInRegistries.ENTITY_TYPE.getKey(p_258244_.getType()).toString()), this.blockEntityTickers.size(), ServerLevel.getTypeCount(this.blockEntityTickers, TickingBlockEntity::getType), ((LevelTicks)this.getBlockTicks()).count(), ((LevelTicks)this.getFluidTicks()).count(), this.gatherChunkSourceStats());
    }

    private static <T> String getTypeCount(Iterable<T> p_143302_, Function<T, String> p_143303_) {
        try {
            Object2IntOpenHashMap $$2 = new Object2IntOpenHashMap();
            for (T $$3 : p_143302_) {
                String $$4 = p_143303_.apply($$3);
                $$2.addTo((Object)$$4, 1);
            }
            return $$2.object2IntEntrySet().stream().sorted(Comparator.comparing(Object2IntMap.Entry::getIntValue).reversed()).limit(5L).map(p_207570_ -> (String)p_207570_.getKey() + ":" + p_207570_.getIntValue()).collect(Collectors.joining(","));
        }
        catch (Exception $$5) {
            return "";
        }
    }

    @Override
    protected LevelEntityGetter<Entity> getEntities() {
        return this.entityManager.getEntityGetter();
    }

    public void addLegacyChunkEntities(Stream<Entity> p_143312_) {
        this.entityManager.addLegacyChunkEntities(p_143312_);
    }

    public void addWorldGenChunkEntities(Stream<Entity> p_143328_) {
        this.entityManager.addWorldGenChunkEntities(p_143328_);
    }

    public void startTickingChunk(LevelChunk p_184103_) {
        p_184103_.unpackTicks(this.getLevelData().getGameTime());
    }

    public void onStructureStartsAvailable(ChunkAccess p_196558_) {
        this.server.execute(() -> this.structureCheck.onStructureLoad(p_196558_.getPos(), p_196558_.getAllStarts()));
    }

    public PathTypeCache getPathTypeCache() {
        return this.pathTypesByPosCache;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.entityManager.close();
    }

    @Override
    public String gatherChunkSourceStats() {
        return "Chunks[S] W: " + this.chunkSource.gatherStats() + " E: " + this.entityManager.gatherStats();
    }

    public boolean areEntitiesLoaded(long p_143320_) {
        return this.entityManager.areEntitiesLoaded(p_143320_);
    }

    public boolean isPositionTickingWithEntitiesLoaded(long p_184111_) {
        return this.areEntitiesLoaded(p_184111_) && this.chunkSource.isPositionTicking(p_184111_);
    }

    public boolean isPositionEntityTicking(BlockPos p_143341_) {
        return this.entityManager.canPositionTick(p_143341_) && this.chunkSource.chunkMap.getDistanceManager().inEntityTickingRange(ChunkPos.asLong(p_143341_));
    }

    public boolean areEntitiesActuallyLoadedAndTicking(ChunkPos p_411044_) {
        return this.entityManager.isTicking(p_411044_) && this.entityManager.areEntitiesLoaded(p_411044_.toLong());
    }

    public boolean anyPlayerCloseEnoughForSpawning(BlockPos p_401859_) {
        return this.anyPlayerCloseEnoughForSpawning(new ChunkPos(p_401859_));
    }

    public boolean anyPlayerCloseEnoughForSpawning(ChunkPos p_401797_) {
        return this.chunkSource.chunkMap.anyPlayerCloseEnoughForSpawning(p_401797_);
    }

    public boolean canSpawnEntitiesInChunk(ChunkPos p_401897_) {
        return this.entityManager.canPositionTick(p_401897_) && this.getWorldBorder().isWithinBounds(p_401897_);
    }

    @Override
    public FeatureFlagSet enabledFeatures() {
        return this.server.getWorldData().enabledFeatures();
    }

    @Override
    public PotionBrewing potionBrewing() {
        return this.server.potionBrewing();
    }

    @Override
    public FuelValues fuelValues() {
        return this.server.fuelValues();
    }

    public RandomSource getRandomSequence(ResourceLocation p_287689_) {
        return this.randomSequences.get(p_287689_);
    }

    public RandomSequences getRandomSequences() {
        return this.randomSequences;
    }

    public GameRules getGameRules() {
        return this.serverLevelData.getGameRules();
    }

    @Override
    public CrashReportCategory fillReportDetails(CrashReport p_307518_) {
        CrashReportCategory $$1 = super.fillReportDetails(p_307518_);
        $$1.setDetail("Loaded entity count", () -> String.valueOf(this.entityManager.count()));
        return $$1;
    }

    @Override
    public int getSeaLevel() {
        return this.chunkSource.getGenerator().getSeaLevel();
    }

    @Override
    public /* synthetic */ RecipeAccess recipeAccess() {
        return this.recipeAccess();
    }

    @Override
    public /* synthetic */ Scoreboard getScoreboard() {
        return this.getScoreboard();
    }

    @Override
    public /* synthetic */ ChunkSource getChunkSource() {
        return this.getChunkSource();
    }

    public /* synthetic */ LevelTickAccess getFluidTicks() {
        return this.getFluidTicks();
    }

    public /* synthetic */ LevelTickAccess getBlockTicks() {
        return this.getBlockTicks();
    }

    final class EntityCallbacks
    implements LevelCallback<Entity> {
        EntityCallbacks() {
        }

        @Override
        public void onCreated(Entity p_143355_) {
        }

        @Override
        public void onDestroyed(Entity p_143359_) {
            ServerLevel.this.getScoreboard().entityRemoved(p_143359_);
        }

        @Override
        public void onTickingStart(Entity p_143363_) {
            ServerLevel.this.entityTickList.add(p_143363_);
        }

        @Override
        public void onTickingEnd(Entity p_143367_) {
            ServerLevel.this.entityTickList.remove(p_143367_);
        }

        @Override
        public void onTrackingStart(Entity p_143371_) {
            ServerLevel.this.getChunkSource().addEntity(p_143371_);
            if (p_143371_ instanceof ServerPlayer) {
                ServerPlayer $$1 = (ServerPlayer)p_143371_;
                ServerLevel.this.players.add($$1);
                ServerLevel.this.updateSleepingPlayerList();
            }
            if (p_143371_ instanceof Mob) {
                Mob $$2 = (Mob)p_143371_;
                if (ServerLevel.this.isUpdatingNavigations) {
                    String $$3 = "onTrackingStart called during navigation iteration";
                    Util.logAndPauseIfInIde("onTrackingStart called during navigation iteration", new IllegalStateException("onTrackingStart called during navigation iteration"));
                }
                ServerLevel.this.navigatingMobs.add($$2);
            }
            if (p_143371_ instanceof EnderDragon) {
                EnderDragon $$4 = (EnderDragon)p_143371_;
                for (EnderDragonPart $$5 : $$4.getSubEntities()) {
                    ServerLevel.this.dragonParts.put($$5.getId(), (Object)$$5);
                }
            }
            p_143371_.updateDynamicGameEventListener(DynamicGameEventListener::add);
        }

        @Override
        public void onTrackingEnd(Entity p_143375_) {
            ServerLevel.this.getChunkSource().removeEntity(p_143375_);
            if (p_143375_ instanceof ServerPlayer) {
                ServerPlayer $$1 = (ServerPlayer)p_143375_;
                ServerLevel.this.players.remove($$1);
                ServerLevel.this.updateSleepingPlayerList();
            }
            if (p_143375_ instanceof Mob) {
                Mob $$2 = (Mob)p_143375_;
                if (ServerLevel.this.isUpdatingNavigations) {
                    String $$3 = "onTrackingStart called during navigation iteration";
                    Util.logAndPauseIfInIde("onTrackingStart called during navigation iteration", new IllegalStateException("onTrackingStart called during navigation iteration"));
                }
                ServerLevel.this.navigatingMobs.remove($$2);
            }
            if (p_143375_ instanceof EnderDragon) {
                EnderDragon $$4 = (EnderDragon)p_143375_;
                for (EnderDragonPart $$5 : $$4.getSubEntities()) {
                    ServerLevel.this.dragonParts.remove($$5.getId());
                }
            }
            p_143375_.updateDynamicGameEventListener(DynamicGameEventListener::remove);
        }

        @Override
        public void onSectionChange(Entity p_215086_) {
            p_215086_.updateDynamicGameEventListener(DynamicGameEventListener::move);
        }

        @Override
        public /* synthetic */ void onSectionChange(Object object) {
            this.onSectionChange((Entity)object);
        }

        @Override
        public /* synthetic */ void onTrackingEnd(Object object) {
            this.onTrackingEnd((Entity)object);
        }

        @Override
        public /* synthetic */ void onTrackingStart(Object object) {
            this.onTrackingStart((Entity)object);
        }

        @Override
        public /* synthetic */ void onTickingStart(Object object) {
            this.onTickingStart((Entity)object);
        }

        @Override
        public /* synthetic */ void onDestroyed(Object object) {
            this.onDestroyed((Entity)object);
        }

        @Override
        public /* synthetic */ void onCreated(Object object) {
            this.onCreated((Entity)object);
        }
    }
}

