/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.mojang.logging.LogUtils;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StaticCache2D;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkStep;
import net.minecraft.world.level.chunk.status.ChunkType;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.ticks.LevelTickAccess;
import net.minecraft.world.ticks.WorldGenTickAccess;
import org.slf4j.Logger;

public class WorldGenRegion
implements WorldGenLevel {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final StaticCache2D<GenerationChunkHolder> cache;
    private final ChunkAccess center;
    private final ServerLevel level;
    private final long seed;
    private final LevelData levelData;
    private final RandomSource random;
    private final DimensionType dimensionType;
    private final WorldGenTickAccess<Block> blockTicks = new WorldGenTickAccess(p_399403_ -> this.getChunk((BlockPos)p_399403_).getBlockTicks());
    private final WorldGenTickAccess<Fluid> fluidTicks = new WorldGenTickAccess(p_399402_ -> this.getChunk((BlockPos)p_399402_).getFluidTicks());
    private final BiomeManager biomeManager;
    private final ChunkStep generatingStep;
    @Nullable
    private Supplier<String> currentlyGenerating;
    private final AtomicLong subTickCount = new AtomicLong();
    private static final ResourceLocation WORLDGEN_REGION_RANDOM = ResourceLocation.withDefaultNamespace("worldgen_region_random");

    public WorldGenRegion(ServerLevel p_143484_, StaticCache2D<GenerationChunkHolder> p_347548_, ChunkStep p_347626_, ChunkAccess p_347663_) {
        this.generatingStep = p_347626_;
        this.cache = p_347548_;
        this.center = p_347663_;
        this.level = p_143484_;
        this.seed = p_143484_.getSeed();
        this.levelData = p_143484_.getLevelData();
        this.random = p_143484_.getChunkSource().randomState().getOrCreateRandomFactory(WORLDGEN_REGION_RANDOM).at(this.center.getPos().getWorldPosition());
        this.dimensionType = p_143484_.dimensionType();
        this.biomeManager = new BiomeManager(this, BiomeManager.obfuscateSeed(this.seed));
    }

    public boolean isOldChunkAround(ChunkPos p_215160_, int p_215161_) {
        return this.level.getChunkSource().chunkMap.isOldChunkAround(p_215160_, p_215161_);
    }

    public ChunkPos getCenter() {
        return this.center.getPos();
    }

    @Override
    public void setCurrentlyGenerating(@Nullable Supplier<String> p_143498_) {
        this.currentlyGenerating = p_143498_;
    }

    @Override
    public ChunkAccess getChunk(int p_9507_, int p_9508_) {
        return this.getChunk(p_9507_, p_9508_, ChunkStatus.EMPTY);
    }

    @Override
    @Nullable
    public ChunkAccess getChunk(int p_9514_, int p_9515_, ChunkStatus p_331853_, boolean p_9517_) {
        GenerationChunkHolder $$8;
        ChunkStatus $$5;
        int $$4 = this.center.getPos().getChessboardDistance(p_9514_, p_9515_);
        ChunkStatus chunkStatus = $$5 = $$4 >= this.generatingStep.directDependencies().size() ? null : this.generatingStep.directDependencies().get($$4);
        if ($$5 != null) {
            ChunkAccess $$7;
            GenerationChunkHolder $$6 = this.cache.get(p_9514_, p_9515_);
            if (p_331853_.isOrBefore($$5) && ($$7 = $$6.getChunkIfPresentUnchecked($$5)) != null) {
                return $$7;
            }
        } else {
            $$8 = null;
        }
        CrashReport $$9 = CrashReport.forThrowable(new IllegalStateException("Requested chunk unavailable during world generation"), "Exception generating new chunk");
        CrashReportCategory $$10 = $$9.addCategory("Chunk request details");
        $$10.setDetail("Requested chunk", String.format(Locale.ROOT, "%d, %d", p_9514_, p_9515_));
        $$10.setDetail("Generating status", () -> this.generatingStep.targetStatus().getName());
        $$10.setDetail("Requested status", p_331853_::getName);
        $$10.setDetail("Actual status", () -> $$8 == null ? "[out of cache bounds]" : $$8.getPersistedStatus().getName());
        $$10.setDetail("Maximum allowed status", () -> $$5 == null ? "null" : $$5.getName());
        $$10.setDetail("Dependencies", this.generatingStep.directDependencies()::toString);
        $$10.setDetail("Requested distance", $$4);
        $$10.setDetail("Generating chunk", this.center.getPos()::toString);
        throw new ReportedException($$9);
    }

    @Override
    public boolean hasChunk(int p_9574_, int p_9575_) {
        int $$2 = this.center.getPos().getChessboardDistance(p_9574_, p_9575_);
        return $$2 < this.generatingStep.directDependencies().size();
    }

    @Override
    public BlockState getBlockState(BlockPos p_9587_) {
        return this.getChunk(SectionPos.blockToSectionCoord(p_9587_.getX()), SectionPos.blockToSectionCoord(p_9587_.getZ())).getBlockState(p_9587_);
    }

    @Override
    public FluidState getFluidState(BlockPos p_9577_) {
        return this.getChunk(p_9577_).getFluidState(p_9577_);
    }

    @Override
    @Nullable
    public Player getNearestPlayer(double p_9501_, double p_9502_, double p_9503_, double p_9504_, Predicate<Entity> p_9505_) {
        return null;
    }

    @Override
    public int getSkyDarken() {
        return 0;
    }

    @Override
    public BiomeManager getBiomeManager() {
        return this.biomeManager;
    }

    @Override
    public Holder<Biome> getUncachedNoiseBiome(int p_203787_, int p_203788_, int p_203789_) {
        return this.level.getUncachedNoiseBiome(p_203787_, p_203788_, p_203789_);
    }

    @Override
    public float getShade(Direction p_9555_, boolean p_9556_) {
        return 1.0f;
    }

    @Override
    public LevelLightEngine getLightEngine() {
        return this.level.getLightEngine();
    }

    @Override
    public boolean destroyBlock(BlockPos p_9550_, boolean p_9551_, @Nullable Entity p_9552_, int p_9553_) {
        BlockState $$4 = this.getBlockState(p_9550_);
        if ($$4.isAir()) {
            return false;
        }
        if (p_9551_) {
            BlockEntity $$5 = $$4.hasBlockEntity() ? this.getBlockEntity(p_9550_) : null;
            Block.dropResources($$4, this.level, p_9550_, $$5, p_9552_, ItemStack.EMPTY);
        }
        return this.setBlock(p_9550_, Blocks.AIR.defaultBlockState(), 3, p_9553_);
    }

    @Override
    @Nullable
    public BlockEntity getBlockEntity(BlockPos p_9582_) {
        ChunkAccess $$1 = this.getChunk(p_9582_);
        BlockEntity $$2 = $$1.getBlockEntity(p_9582_);
        if ($$2 != null) {
            return $$2;
        }
        CompoundTag $$3 = $$1.getBlockEntityNbt(p_9582_);
        BlockState $$4 = $$1.getBlockState(p_9582_);
        if ($$3 != null) {
            if ("DUMMY".equals($$3.getStringOr("id", ""))) {
                if (!$$4.hasBlockEntity()) {
                    return null;
                }
                $$2 = ((EntityBlock)((Object)$$4.getBlock())).newBlockEntity(p_9582_, $$4);
            } else {
                $$2 = BlockEntity.loadStatic(p_9582_, $$4, $$3, this.level.registryAccess());
            }
            if ($$2 != null) {
                $$1.setBlockEntity($$2);
                return $$2;
            }
        }
        if ($$4.hasBlockEntity()) {
            LOGGER.warn("Tried to access a block entity before it was created. {}", (Object)p_9582_);
        }
        return null;
    }

    @Override
    public boolean ensureCanWrite(BlockPos p_181031_) {
        LevelHeightAccessor $$6;
        int $$1 = SectionPos.blockToSectionCoord(p_181031_.getX());
        int $$2 = SectionPos.blockToSectionCoord(p_181031_.getZ());
        ChunkPos $$3 = this.getCenter();
        int $$4 = Math.abs($$3.x - $$1);
        int $$5 = Math.abs($$3.z - $$2);
        if ($$4 > this.generatingStep.blockStateWriteRadius() || $$5 > this.generatingStep.blockStateWriteRadius()) {
            Util.logAndPauseIfInIde("Detected setBlock in a far chunk [" + $$1 + ", " + $$2 + "], pos: " + String.valueOf(p_181031_) + ", status: " + String.valueOf(this.generatingStep.targetStatus()) + (String)(this.currentlyGenerating == null ? "" : ", currently generating: " + this.currentlyGenerating.get()));
            return false;
        }
        return !this.center.isUpgrading() || !($$6 = this.center.getHeightAccessorForGeneration()).isOutsideBuildHeight(p_181031_.getY());
    }

    @Override
    public boolean setBlock(BlockPos p_9539_, BlockState p_9540_, int p_9541_, int p_9542_) {
        if (!this.ensureCanWrite(p_9539_)) {
            return false;
        }
        ChunkAccess $$4 = this.getChunk(p_9539_);
        BlockState $$5 = $$4.setBlockState(p_9539_, p_9540_, p_9541_);
        if ($$5 != null) {
            this.level.updatePOIOnBlockStateChange(p_9539_, $$5, p_9540_);
        }
        if (p_9540_.hasBlockEntity()) {
            if ($$4.getPersistedStatus().getChunkType() == ChunkType.LEVELCHUNK) {
                BlockEntity $$6 = ((EntityBlock)((Object)p_9540_.getBlock())).newBlockEntity(p_9539_, p_9540_);
                if ($$6 != null) {
                    $$4.setBlockEntity($$6);
                } else {
                    $$4.removeBlockEntity(p_9539_);
                }
            } else {
                CompoundTag $$7 = new CompoundTag();
                $$7.putInt("x", p_9539_.getX());
                $$7.putInt("y", p_9539_.getY());
                $$7.putInt("z", p_9539_.getZ());
                $$7.putString("id", "DUMMY");
                $$4.setBlockEntityNbt($$7);
            }
        } else if ($$5 != null && $$5.hasBlockEntity()) {
            $$4.removeBlockEntity(p_9539_);
        }
        if (p_9540_.hasPostProcess(this, p_9539_) && (p_9541_ & 0x10) == 0) {
            this.markPosForPostprocessing(p_9539_);
        }
        return true;
    }

    private void markPosForPostprocessing(BlockPos p_9592_) {
        this.getChunk(p_9592_).markPosForPostprocessing(p_9592_);
    }

    @Override
    public boolean addFreshEntity(Entity p_9580_) {
        int $$1 = SectionPos.blockToSectionCoord(p_9580_.getBlockX());
        int $$2 = SectionPos.blockToSectionCoord(p_9580_.getBlockZ());
        this.getChunk($$1, $$2).addEntity(p_9580_);
        return true;
    }

    @Override
    public boolean removeBlock(BlockPos p_9547_, boolean p_9548_) {
        return this.setBlock(p_9547_, Blocks.AIR.defaultBlockState(), 3);
    }

    @Override
    public WorldBorder getWorldBorder() {
        return this.level.getWorldBorder();
    }

    @Override
    public boolean isClientSide() {
        return false;
    }

    @Override
    @Deprecated
    public ServerLevel getLevel() {
        return this.level;
    }

    @Override
    public RegistryAccess registryAccess() {
        return this.level.registryAccess();
    }

    @Override
    public FeatureFlagSet enabledFeatures() {
        return this.level.enabledFeatures();
    }

    @Override
    public LevelData getLevelData() {
        return this.levelData;
    }

    @Override
    public DifficultyInstance getCurrentDifficultyAt(BlockPos p_9585_) {
        if (!this.hasChunk(SectionPos.blockToSectionCoord(p_9585_.getX()), SectionPos.blockToSectionCoord(p_9585_.getZ()))) {
            throw new RuntimeException("We are asking a region for a chunk out of bound");
        }
        return new DifficultyInstance(this.level.getDifficulty(), this.level.getDayTime(), 0L, this.level.getMoonBrightness());
    }

    @Override
    @Nullable
    public MinecraftServer getServer() {
        return this.level.getServer();
    }

    @Override
    public ChunkSource getChunkSource() {
        return this.level.getChunkSource();
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @Override
    public LevelTickAccess<Block> getBlockTicks() {
        return this.blockTicks;
    }

    @Override
    public LevelTickAccess<Fluid> getFluidTicks() {
        return this.fluidTicks;
    }

    @Override
    public int getSeaLevel() {
        return this.level.getSeaLevel();
    }

    @Override
    public RandomSource getRandom() {
        return this.random;
    }

    @Override
    public int getHeight(Heightmap.Types p_9535_, int p_9536_, int p_9537_) {
        return this.getChunk(SectionPos.blockToSectionCoord(p_9536_), SectionPos.blockToSectionCoord(p_9537_)).getHeight(p_9535_, p_9536_ & 0xF, p_9537_ & 0xF) + 1;
    }

    @Override
    public void playSound(@Nullable Entity p_394194_, BlockPos p_9529_, SoundEvent p_9530_, SoundSource p_9531_, float p_9532_, float p_9533_) {
    }

    @Override
    public void addParticle(ParticleOptions p_9561_, double p_9562_, double p_9563_, double p_9564_, double p_9565_, double p_9566_, double p_9567_) {
    }

    @Override
    public void levelEvent(@Nullable Entity p_394406_, int p_9524_, BlockPos p_9525_, int p_9526_) {
    }

    @Override
    public void gameEvent(Holder<GameEvent> p_316792_, Vec3 p_215164_, GameEvent.Context p_215165_) {
    }

    @Override
    public DimensionType dimensionType() {
        return this.dimensionType;
    }

    @Override
    public boolean isStateAtPosition(BlockPos p_9544_, Predicate<BlockState> p_9545_) {
        return p_9545_.test(this.getBlockState(p_9544_));
    }

    @Override
    public boolean isFluidAtPosition(BlockPos p_143500_, Predicate<FluidState> p_143501_) {
        return p_143501_.test(this.getFluidState(p_143500_));
    }

    @Override
    public <T extends Entity> List<T> getEntities(EntityTypeTest<Entity, T> p_143494_, AABB p_143495_, Predicate<? super T> p_143496_) {
        return Collections.emptyList();
    }

    @Override
    public List<Entity> getEntities(@Nullable Entity p_9519_, AABB p_9520_, @Nullable Predicate<? super Entity> p_9521_) {
        return Collections.emptyList();
    }

    public List<Player> players() {
        return Collections.emptyList();
    }

    @Override
    public int getMinY() {
        return this.level.getMinY();
    }

    @Override
    public int getHeight() {
        return this.level.getHeight();
    }

    @Override
    public long nextSubTickCount() {
        return this.subTickCount.getAndIncrement();
    }
}

