/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.protocol.game.ClientboundAwardStatsPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.stats.StatsCounter;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;

public class ServerStatsCounter
extends StatsCounter {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Codec<Map<Stat<?>, Integer>> STATS_CODEC = Codec.dispatchedMap(BuiltInRegistries.STAT_TYPE.byNameCodec(), Util.memoize(ServerStatsCounter::createTypedStatsCodec)).xmap(p_404237_ -> {
        HashMap $$1 = new HashMap();
        p_404237_.forEach((p_404229_, p_404230_) -> $$1.putAll(p_404230_));
        return $$1;
    }, p_404234_ -> p_404234_.entrySet().stream().collect(Collectors.groupingBy(p_404238_ -> ((Stat)p_404238_.getKey()).getType(), Util.toMap())));
    private final MinecraftServer server;
    private final File file;
    private final Set<Stat<?>> dirty = Sets.newHashSet();

    private static <T> Codec<Map<Stat<?>, Integer>> createTypedStatsCodec(StatType<T> p_405859_) {
        Codec<T> $$1 = p_405859_.getRegistry().byNameCodec();
        Codec $$2 = $$1.flatComapMap(p_405859_::get, p_404236_ -> {
            if (p_404236_.getType() == p_405859_) {
                return DataResult.success(p_404236_.getValue());
            }
            return DataResult.error(() -> "Expected type " + String.valueOf(p_405859_) + ", but got " + String.valueOf(p_404236_.getType()));
        });
        return Codec.unboundedMap((Codec)$$2, (Codec)Codec.INT);
    }

    public ServerStatsCounter(MinecraftServer p_12816_, File p_12817_) {
        this.server = p_12816_;
        this.file = p_12817_;
        if (p_12817_.isFile()) {
            try {
                this.parseLocal(p_12816_.getFixerUpper(), FileUtils.readFileToString((File)p_12817_));
            }
            catch (IOException $$2) {
                LOGGER.error("Couldn't read statistics file {}", (Object)p_12817_, (Object)$$2);
            }
            catch (JsonParseException $$3) {
                LOGGER.error("Couldn't parse statistics file {}", (Object)p_12817_, (Object)$$3);
            }
        }
    }

    public void save() {
        try {
            FileUtils.writeStringToFile((File)this.file, (String)this.toJson());
        }
        catch (IOException $$0) {
            LOGGER.error("Couldn't save stats", (Throwable)$$0);
        }
    }

    @Override
    public void setValue(Player p_12827_, Stat<?> p_12828_, int p_12829_) {
        super.setValue(p_12827_, p_12828_, p_12829_);
        this.dirty.add(p_12828_);
    }

    private Set<Stat<?>> getDirty() {
        HashSet $$0 = Sets.newHashSet(this.dirty);
        this.dirty.clear();
        return $$0;
    }

    public void parseLocal(DataFixer p_12833_, String p_12834_) {
        try (JsonReader $$2 = new JsonReader((Reader)new StringReader(p_12834_));){
            $$2.setLenient(false);
            JsonElement $$3 = Streams.parse((JsonReader)$$2);
            if ($$3.isJsonNull()) {
                LOGGER.error("Unable to parse Stat data from {}", (Object)this.file);
                return;
            }
            Dynamic $$4 = new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)$$3);
            $$4 = DataFixTypes.STATS.updateToCurrentVersion(p_12833_, $$4, NbtUtils.getDataVersion($$4, 1343));
            this.stats.putAll(STATS_CODEC.parse($$4.get("stats").orElseEmptyMap()).resultOrPartial(p_404233_ -> LOGGER.error("Failed to parse statistics for {}: {}", (Object)this.file, p_404233_)).orElse(Map.of()));
        }
        catch (JsonParseException | IOException $$5) {
            LOGGER.error("Unable to parse Stat data from {}", (Object)this.file, (Object)$$5);
        }
    }

    protected String toJson() {
        JsonObject $$0 = new JsonObject();
        $$0.add("stats", (JsonElement)STATS_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.stats).getOrThrow());
        $$0.addProperty("DataVersion", (Number)SharedConstants.getCurrentVersion().getDataVersion().getVersion());
        return $$0.toString();
    }

    public void markAllDirty() {
        this.dirty.addAll((Collection<Stat<?>>)this.stats.keySet());
    }

    public void sendStats(ServerPlayer p_12820_) {
        Object2IntOpenHashMap $$1 = new Object2IntOpenHashMap();
        for (Stat<?> $$2 : this.getDirty()) {
            $$1.put($$2, this.getValue($$2));
        }
        p_12820_.connection.send(new ClientboundAwardStatsPacket((Object2IntMap<Stat<?>>)$$1));
    }
}

