/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.ListBuilder;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import java.lang.runtime.SwitchBootstraps;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import net.minecraft.util.AbstractListBuilder;

public class HashOps
implements DynamicOps<HashCode> {
    private static final byte TAG_EMPTY = 1;
    private static final byte TAG_MAP_START = 2;
    private static final byte TAG_MAP_END = 3;
    private static final byte TAG_LIST_START = 4;
    private static final byte TAG_LIST_END = 5;
    private static final byte TAG_BYTE = 6;
    private static final byte TAG_SHORT = 7;
    private static final byte TAG_INT = 8;
    private static final byte TAG_LONG = 9;
    private static final byte TAG_FLOAT = 10;
    private static final byte TAG_DOUBLE = 11;
    private static final byte TAG_STRING = 12;
    private static final byte TAG_BOOLEAN = 13;
    private static final byte TAG_BYTE_ARRAY_START = 14;
    private static final byte TAG_BYTE_ARRAY_END = 15;
    private static final byte TAG_INT_ARRAY_START = 16;
    private static final byte TAG_INT_ARRAY_END = 17;
    private static final byte TAG_LONG_ARRAY_START = 18;
    private static final byte TAG_LONG_ARRAY_END = 19;
    private static final byte[] EMPTY_PAYLOAD = new byte[]{1};
    private static final byte[] FALSE_PAYLOAD = new byte[]{13, 0};
    private static final byte[] TRUE_PAYLOAD = new byte[]{13, 1};
    public static final byte[] EMPTY_MAP_PAYLOAD = new byte[]{2, 3};
    public static final byte[] EMPTY_LIST_PAYLOAD = new byte[]{4, 5};
    private static final DataResult<Object> UNSUPPORTED_OPERATION_ERROR = DataResult.error(() -> "Unsupported operation");
    private static final Comparator<HashCode> HASH_COMPARATOR = Comparator.comparingLong(HashCode::padToLong);
    private static final Comparator<Map.Entry<HashCode, HashCode>> MAP_ENTRY_ORDER = Map.Entry.comparingByKey(HASH_COMPARATOR).thenComparing(Map.Entry.comparingByValue(HASH_COMPARATOR));
    private static final Comparator<Pair<HashCode, HashCode>> MAPLIKE_ENTRY_ORDER = Comparator.comparing(Pair::getFirst, HASH_COMPARATOR).thenComparing(Pair::getSecond, HASH_COMPARATOR);
    public static final HashOps CRC32C_INSTANCE = new HashOps(Hashing.crc32c());
    final HashFunction hashFunction;
    final HashCode empty;
    private final HashCode emptyMap;
    private final HashCode emptyList;
    private final HashCode trueHash;
    private final HashCode falseHash;

    public HashOps(HashFunction p_412557_) {
        this.hashFunction = p_412557_;
        this.empty = p_412557_.hashBytes(EMPTY_PAYLOAD);
        this.emptyMap = p_412557_.hashBytes(EMPTY_MAP_PAYLOAD);
        this.emptyList = p_412557_.hashBytes(EMPTY_LIST_PAYLOAD);
        this.falseHash = p_412557_.hashBytes(FALSE_PAYLOAD);
        this.trueHash = p_412557_.hashBytes(TRUE_PAYLOAD);
    }

    public HashCode empty() {
        return this.empty;
    }

    public HashCode emptyMap() {
        return this.emptyMap;
    }

    public HashCode emptyList() {
        return this.emptyList;
    }

    public HashCode createNumeric(Number p_412443_) {
        Number number = p_412443_;
        Objects.requireNonNull(number);
        Number number2 = number;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Byte.class, Short.class, Integer.class, Long.class, Double.class, Float.class}, (Object)number2, n)) {
            case 0 -> {
                Byte $$1 = (Byte)number2;
                yield this.createByte($$1);
            }
            case 1 -> {
                Short $$2 = (Short)number2;
                yield this.createShort($$2);
            }
            case 2 -> {
                Integer $$3 = (Integer)number2;
                yield this.createInt($$3);
            }
            case 3 -> {
                Long $$4 = (Long)number2;
                yield this.createLong($$4);
            }
            case 4 -> {
                Double $$5 = (Double)number2;
                yield this.createDouble($$5);
            }
            case 5 -> {
                Float $$6 = (Float)number2;
                yield this.createFloat($$6.floatValue());
            }
            default -> this.createDouble(p_412443_.doubleValue());
        };
    }

    public HashCode createByte(byte p_412636_) {
        return this.hashFunction.newHasher(2).putByte((byte)6).putByte(p_412636_).hash();
    }

    public HashCode createShort(short p_412616_) {
        return this.hashFunction.newHasher(3).putByte((byte)7).putShort(p_412616_).hash();
    }

    public HashCode createInt(int p_412683_) {
        return this.hashFunction.newHasher(5).putByte((byte)8).putInt(p_412683_).hash();
    }

    public HashCode createLong(long p_412271_) {
        return this.hashFunction.newHasher(9).putByte((byte)9).putLong(p_412271_).hash();
    }

    public HashCode createFloat(float p_412641_) {
        return this.hashFunction.newHasher(5).putByte((byte)10).putFloat(p_412641_).hash();
    }

    public HashCode createDouble(double p_412066_) {
        return this.hashFunction.newHasher(9).putByte((byte)11).putDouble(p_412066_).hash();
    }

    public HashCode createString(String p_412211_) {
        return this.hashFunction.newHasher().putByte((byte)12).putInt(p_412211_.length()).putUnencodedChars((CharSequence)p_412211_).hash();
    }

    public HashCode createBoolean(boolean p_412649_) {
        return p_412649_ ? this.trueHash : this.falseHash;
    }

    private static Hasher hashMap(Hasher p_412213_, Map<HashCode, HashCode> p_412494_) {
        p_412213_.putByte((byte)2);
        p_412494_.entrySet().stream().sorted(MAP_ENTRY_ORDER).forEach(p_412485_ -> p_412213_.putBytes(((HashCode)p_412485_.getKey()).asBytes()).putBytes(((HashCode)p_412485_.getValue()).asBytes()));
        p_412213_.putByte((byte)3);
        return p_412213_;
    }

    static Hasher hashMap(Hasher p_412189_, Stream<Pair<HashCode, HashCode>> p_412324_) {
        p_412189_.putByte((byte)2);
        p_412324_.sorted(MAPLIKE_ENTRY_ORDER).forEach(p_412404_ -> p_412189_.putBytes(((HashCode)p_412404_.getFirst()).asBytes()).putBytes(((HashCode)p_412404_.getSecond()).asBytes()));
        p_412189_.putByte((byte)3);
        return p_412189_;
    }

    public HashCode createMap(Stream<Pair<HashCode, HashCode>> p_412416_) {
        return HashOps.hashMap(this.hashFunction.newHasher(), p_412416_).hash();
    }

    public HashCode createMap(Map<HashCode, HashCode> p_412512_) {
        return HashOps.hashMap(this.hashFunction.newHasher(), p_412512_).hash();
    }

    public HashCode createList(Stream<HashCode> p_412225_) {
        Hasher $$1 = this.hashFunction.newHasher();
        $$1.putByte((byte)4);
        p_412225_.forEach(p_412370_ -> $$1.putBytes(p_412370_.asBytes()));
        $$1.putByte((byte)5);
        return $$1.hash();
    }

    public HashCode createByteList(ByteBuffer p_412081_) {
        Hasher $$1 = this.hashFunction.newHasher();
        $$1.putByte((byte)14);
        $$1.putBytes(p_412081_);
        $$1.putByte((byte)15);
        return $$1.hash();
    }

    public HashCode createIntList(IntStream p_412517_) {
        Hasher $$1 = this.hashFunction.newHasher();
        $$1.putByte((byte)16);
        p_412517_.forEach(arg_0 -> ((Hasher)$$1).putInt(arg_0));
        $$1.putByte((byte)17);
        return $$1.hash();
    }

    public HashCode createLongList(LongStream p_412654_) {
        Hasher $$1 = this.hashFunction.newHasher();
        $$1.putByte((byte)18);
        p_412654_.forEach(arg_0 -> ((Hasher)$$1).putLong(arg_0));
        $$1.putByte((byte)19);
        return $$1.hash();
    }

    public HashCode remove(HashCode p_412437_, String p_412123_) {
        return p_412437_;
    }

    public RecordBuilder<HashCode> mapBuilder() {
        return new MapHashBuilder();
    }

    public ListBuilder<HashCode> listBuilder() {
        return new ListHashBuilder();
    }

    public String toString() {
        return "Hash " + String.valueOf(this.hashFunction);
    }

    public <U> U convertTo(DynamicOps<U> p_412264_, HashCode p_412248_) {
        throw new UnsupportedOperationException("Can't convert from this type");
    }

    public Number getNumberValue(HashCode p_412545_, Number p_412129_) {
        return p_412129_;
    }

    public HashCode set(HashCode p_412708_, String p_412229_, HashCode p_412577_) {
        return p_412708_;
    }

    public HashCode update(HashCode p_412258_, String p_412582_, Function<HashCode, HashCode> p_412141_) {
        return p_412258_;
    }

    public HashCode updateGeneric(HashCode p_412276_, HashCode p_412115_, Function<HashCode, HashCode> p_412233_) {
        return p_412276_;
    }

    private static <T> DataResult<T> unsupported() {
        return UNSUPPORTED_OPERATION_ERROR;
    }

    public DataResult<HashCode> get(HashCode p_412426_, String p_412356_) {
        return HashOps.unsupported();
    }

    public DataResult<HashCode> getGeneric(HashCode p_412138_, HashCode p_412331_) {
        return HashOps.unsupported();
    }

    public DataResult<Number> getNumberValue(HashCode p_412281_) {
        return HashOps.unsupported();
    }

    public DataResult<Boolean> getBooleanValue(HashCode p_412639_) {
        return HashOps.unsupported();
    }

    public DataResult<String> getStringValue(HashCode p_412375_) {
        return HashOps.unsupported();
    }

    public DataResult<HashCode> mergeToList(HashCode p_412567_, HashCode p_412638_) {
        return HashOps.unsupported();
    }

    public DataResult<HashCode> mergeToList(HashCode p_412195_, List<HashCode> p_412670_) {
        return HashOps.unsupported();
    }

    public DataResult<HashCode> mergeToMap(HashCode p_412061_, HashCode p_412446_, HashCode p_412770_) {
        return HashOps.unsupported();
    }

    public DataResult<HashCode> mergeToMap(HashCode p_412263_, Map<HashCode, HashCode> p_412681_) {
        return HashOps.unsupported();
    }

    public DataResult<HashCode> mergeToMap(HashCode p_412371_, MapLike<HashCode> p_412753_) {
        return HashOps.unsupported();
    }

    public DataResult<Stream<Pair<HashCode, HashCode>>> getMapValues(HashCode p_412515_) {
        return HashOps.unsupported();
    }

    public DataResult<Consumer<BiConsumer<HashCode, HashCode>>> getMapEntries(HashCode p_412308_) {
        return HashOps.unsupported();
    }

    public DataResult<Stream<HashCode>> getStream(HashCode p_412047_) {
        return HashOps.unsupported();
    }

    public DataResult<Consumer<Consumer<HashCode>>> getList(HashCode p_412386_) {
        return HashOps.unsupported();
    }

    public DataResult<MapLike<HashCode>> getMap(HashCode p_412339_) {
        return HashOps.unsupported();
    }

    public DataResult<ByteBuffer> getByteBuffer(HashCode p_412476_) {
        return HashOps.unsupported();
    }

    public DataResult<IntStream> getIntStream(HashCode p_412744_) {
        return HashOps.unsupported();
    }

    public DataResult<LongStream> getLongStream(HashCode p_412105_) {
        return HashOps.unsupported();
    }

    public /* synthetic */ Object updateGeneric(Object object, Object object2, Function function) {
        return this.updateGeneric((HashCode)object, (HashCode)object2, (Function<HashCode, HashCode>)function);
    }

    public /* synthetic */ Object update(Object object, String string, Function function) {
        return this.update((HashCode)object, string, (Function<HashCode, HashCode>)function);
    }

    public /* synthetic */ Object set(Object object, String string, Object object2) {
        return this.set((HashCode)object, string, (HashCode)object2);
    }

    public /* synthetic */ DataResult getGeneric(Object object, Object object2) {
        return this.getGeneric((HashCode)object, (HashCode)object2);
    }

    public /* synthetic */ DataResult get(Object object, String string) {
        return this.get((HashCode)object, string);
    }

    public /* synthetic */ Object remove(Object object, String string) {
        return this.remove((HashCode)object, string);
    }

    public /* synthetic */ Object createLongList(LongStream longStream) {
        return this.createLongList(longStream);
    }

    public /* synthetic */ DataResult getLongStream(Object object) {
        return this.getLongStream((HashCode)object);
    }

    public /* synthetic */ Object createIntList(IntStream intStream) {
        return this.createIntList(intStream);
    }

    public /* synthetic */ DataResult getIntStream(Object object) {
        return this.getIntStream((HashCode)object);
    }

    public /* synthetic */ Object createByteList(ByteBuffer byteBuffer) {
        return this.createByteList(byteBuffer);
    }

    public /* synthetic */ DataResult getByteBuffer(Object object) {
        return this.getByteBuffer((HashCode)object);
    }

    public /* synthetic */ Object createList(Stream stream) {
        return this.createList((Stream<HashCode>)stream);
    }

    public /* synthetic */ DataResult getList(Object object) {
        return this.getList((HashCode)object);
    }

    public /* synthetic */ DataResult getStream(Object object) {
        return this.getStream((HashCode)object);
    }

    public /* synthetic */ Object createMap(Map map) {
        return this.createMap((Map<HashCode, HashCode>)map);
    }

    public /* synthetic */ DataResult getMap(Object object) {
        return this.getMap((HashCode)object);
    }

    public /* synthetic */ Object createMap(Stream stream) {
        return this.createMap((Stream<Pair<HashCode, HashCode>>)stream);
    }

    public /* synthetic */ DataResult getMapEntries(Object object) {
        return this.getMapEntries((HashCode)object);
    }

    public /* synthetic */ DataResult getMapValues(Object object) {
        return this.getMapValues((HashCode)object);
    }

    public /* synthetic */ DataResult mergeToMap(Object object, MapLike mapLike) {
        return this.mergeToMap((HashCode)object, (MapLike<HashCode>)mapLike);
    }

    public /* synthetic */ DataResult mergeToMap(Object object, Map map) {
        return this.mergeToMap((HashCode)object, (Map<HashCode, HashCode>)map);
    }

    public /* synthetic */ DataResult mergeToMap(Object object, Object object2, Object object3) {
        return this.mergeToMap((HashCode)object, (HashCode)object2, (HashCode)object3);
    }

    public /* synthetic */ DataResult mergeToList(Object object, List list) {
        return this.mergeToList((HashCode)object, (List<HashCode>)list);
    }

    public /* synthetic */ DataResult mergeToList(Object object, Object object2) {
        return this.mergeToList((HashCode)object, (HashCode)object2);
    }

    public /* synthetic */ Object createString(String string) {
        return this.createString(string);
    }

    public /* synthetic */ DataResult getStringValue(Object object) {
        return this.getStringValue((HashCode)object);
    }

    public /* synthetic */ Object createBoolean(boolean bl) {
        return this.createBoolean(bl);
    }

    public /* synthetic */ DataResult getBooleanValue(Object object) {
        return this.getBooleanValue((HashCode)object);
    }

    public /* synthetic */ Object createDouble(double d) {
        return this.createDouble(d);
    }

    public /* synthetic */ Object createFloat(float f) {
        return this.createFloat(f);
    }

    public /* synthetic */ Object createLong(long l) {
        return this.createLong(l);
    }

    public /* synthetic */ Object createInt(int n) {
        return this.createInt(n);
    }

    public /* synthetic */ Object createShort(short s) {
        return this.createShort(s);
    }

    public /* synthetic */ Object createByte(byte by) {
        return this.createByte(by);
    }

    public /* synthetic */ Object createNumeric(Number number) {
        return this.createNumeric(number);
    }

    public /* synthetic */ Number getNumberValue(Object object, Number number) {
        return this.getNumberValue((HashCode)object, number);
    }

    public /* synthetic */ DataResult getNumberValue(Object object) {
        return this.getNumberValue((HashCode)object);
    }

    public /* synthetic */ Object convertTo(DynamicOps dynamicOps, Object object) {
        return this.convertTo(dynamicOps, (HashCode)object);
    }

    public /* synthetic */ Object emptyList() {
        return this.emptyList();
    }

    public /* synthetic */ Object emptyMap() {
        return this.emptyMap();
    }

    public /* synthetic */ Object empty() {
        return this.empty();
    }

    final class MapHashBuilder
    extends RecordBuilder.AbstractUniversalBuilder<HashCode, List<Pair<HashCode, HashCode>>> {
        public MapHashBuilder() {
            super((DynamicOps)HashOps.this);
        }

        protected List<Pair<HashCode, HashCode>> initBuilder() {
            return new ArrayList<Pair<HashCode, HashCode>>();
        }

        protected List<Pair<HashCode, HashCode>> append(HashCode p_412594_, HashCode p_412246_, List<Pair<HashCode, HashCode>> p_412564_) {
            p_412564_.add((Pair<HashCode, HashCode>)Pair.of((Object)p_412594_, (Object)p_412246_));
            return p_412564_;
        }

        protected DataResult<HashCode> build(List<Pair<HashCode, HashCode>> p_412648_, HashCode p_412523_) {
            assert (p_412523_.equals((Object)HashOps.this.empty()));
            return DataResult.success((Object)HashOps.hashMap(HashOps.this.hashFunction.newHasher(), p_412648_.stream()).hash());
        }

        protected /* synthetic */ Object append(Object object, Object object2, Object object3) {
            return this.append((HashCode)object, (HashCode)object2, (List)object3);
        }

        protected /* synthetic */ DataResult build(Object object, Object object2) {
            return this.build((List)object, (HashCode)object2);
        }

        protected /* synthetic */ Object initBuilder() {
            return this.initBuilder();
        }
    }

    class ListHashBuilder
    extends AbstractListBuilder<HashCode, Hasher> {
        public ListHashBuilder() {
            super(HashOps.this);
        }

        @Override
        protected Hasher initBuilder() {
            return HashOps.this.hashFunction.newHasher().putByte((byte)4);
        }

        @Override
        protected Hasher append(Hasher p_412586_, HashCode p_412043_) {
            return p_412586_.putBytes(p_412043_.asBytes());
        }

        @Override
        protected DataResult<HashCode> build(Hasher p_412335_, HashCode p_412267_) {
            assert (p_412267_.equals((Object)HashOps.this.empty));
            p_412335_.putByte((byte)5);
            return DataResult.success((Object)p_412335_.hash());
        }

        @Override
        protected /* synthetic */ Object initBuilder() {
            return this.initBuilder();
        }
    }
}

