/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import net.minecraft.util.GsonHelper;

public class LegacyComponentDataFixUtils {
    private static final String EMPTY_CONTENTS = LegacyComponentDataFixUtils.createTextComponentJson("");

    public static <T> Dynamic<T> createPlainTextComponent(DynamicOps<T> p_394303_, String p_393613_) {
        String $$2 = LegacyComponentDataFixUtils.createTextComponentJson(p_393613_);
        return new Dynamic(p_394303_, p_394303_.createString($$2));
    }

    public static <T> Dynamic<T> createEmptyComponent(DynamicOps<T> p_393609_) {
        return new Dynamic(p_393609_, p_393609_.createString(EMPTY_CONTENTS));
    }

    public static String createTextComponentJson(String p_394314_) {
        JsonObject $$1 = new JsonObject();
        $$1.addProperty("text", p_394314_);
        return GsonHelper.toStableString((JsonElement)$$1);
    }

    public static String createTranslatableComponentJson(String p_393777_) {
        JsonObject $$1 = new JsonObject();
        $$1.addProperty("translate", p_393777_);
        return GsonHelper.toStableString((JsonElement)$$1);
    }

    public static <T> Dynamic<T> createTranslatableComponent(DynamicOps<T> p_393546_, String p_394262_) {
        String $$2 = LegacyComponentDataFixUtils.createTranslatableComponentJson(p_394262_);
        return new Dynamic(p_393546_, p_393546_.createString($$2));
    }

    public static String rewriteFromLenient(String p_393742_) {
        if (p_393742_.isEmpty() || p_393742_.equals("null")) {
            return EMPTY_CONTENTS;
        }
        char $$1 = p_393742_.charAt(0);
        char $$2 = p_393742_.charAt(p_393742_.length() - 1);
        if ($$1 == '\"' && $$2 == '\"' || $$1 == '{' && $$2 == '}' || $$1 == '[' && $$2 == ']') {
            try {
                JsonElement $$3 = JsonParser.parseString((String)p_393742_);
                if ($$3.isJsonPrimitive()) {
                    return LegacyComponentDataFixUtils.createTextComponentJson($$3.getAsString());
                }
                return GsonHelper.toStableString($$3);
            }
            catch (JsonParseException jsonParseException) {
                // empty catch block
            }
        }
        return LegacyComponentDataFixUtils.createTextComponentJson(p_393742_);
    }

    public static Optional<String> extractTranslationString(String p_393970_) {
        try {
            JsonObject $$2;
            JsonElement $$3;
            JsonElement $$1 = JsonParser.parseString((String)p_393970_);
            if ($$1.isJsonObject() && ($$3 = ($$2 = $$1.getAsJsonObject()).get("translate")) != null && $$3.isJsonPrimitive()) {
                return Optional.of($$3.getAsString());
            }
        }
        catch (JsonParseException jsonParseException) {
            // empty catch block
        }
        return Optional.empty();
    }
}

