/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.OptionalDynamic;
import java.util.List;
import net.minecraft.util.datafix.fixes.References;

public class DropChancesFormatFix
extends DataFix {
    private static final List<String> ARMOR_SLOT_NAMES = List.of("feet", "legs", "chest", "head");
    private static final List<String> HAND_SLOT_NAMES = List.of("mainhand", "offhand");
    private static final float DEFAULT_CHANCE = 0.085f;

    public DropChancesFormatFix(Schema p_393639_) {
        super(p_393639_, false);
    }

    protected TypeRewriteRule makeRule() {
        return this.fixTypeEverywhereTyped("DropChancesFormatFix", this.getInputSchema().getType(References.ENTITY), p_394049_ -> p_394049_.update(DSL.remainderFinder(), p_394520_ -> {
            List<Float> $$1 = DropChancesFormatFix.parseDropChances(p_394520_.get("ArmorDropChances"));
            List<Float> $$2 = DropChancesFormatFix.parseDropChances(p_394520_.get("HandDropChances"));
            float $$3 = p_394520_.get("body_armor_drop_chance").asNumber().result().map(Number::floatValue).orElse(Float.valueOf(0.085f)).floatValue();
            p_394520_ = p_394520_.remove("ArmorDropChances").remove("HandDropChances").remove("body_armor_drop_chance");
            Dynamic $$4 = p_394520_.emptyMap();
            $$4 = DropChancesFormatFix.addSlotChances($$4, $$1, ARMOR_SLOT_NAMES);
            $$4 = DropChancesFormatFix.addSlotChances($$4, $$2, HAND_SLOT_NAMES);
            if ($$3 != 0.085f) {
                $$4 = $$4.set("body", p_394520_.createFloat($$3));
            }
            if (!$$4.equals((Object)p_394520_.emptyMap())) {
                return p_394520_.set("drop_chances", $$4);
            }
            return p_394520_;
        }));
    }

    private static Dynamic<?> addSlotChances(Dynamic<?> p_394421_, List<Float> p_393513_, List<String> p_393814_) {
        for (int $$3 = 0; $$3 < p_393814_.size() && $$3 < p_393513_.size(); ++$$3) {
            String $$4 = p_393814_.get($$3);
            float $$5 = p_393513_.get($$3).floatValue();
            if ($$5 == 0.085f) continue;
            p_394421_ = p_394421_.set($$4, p_394421_.createFloat($$5));
        }
        return p_394421_;
    }

    private static List<Float> parseDropChances(OptionalDynamic<?> p_394100_) {
        return p_394100_.asStream().map(p_393989_ -> Float.valueOf(p_393989_.asFloat(0.085f))).toList();
    }
}

