/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.Streams;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.util.datafix.LegacyComponentDataFixUtils;
import net.minecraft.util.datafix.fixes.BlockEntitySignDoubleSidedEditableTextFix;
import net.minecraft.util.datafix.fixes.References;

public class DropInvalidSignDataFix
extends DataFix {
    private final String entityName;

    public DropInvalidSignDataFix(Schema p_296288_, String p_294804_) {
        super(p_296288_, false);
        this.entityName = p_294804_;
    }

    private <T> Dynamic<T> fix(Dynamic<T> p_295232_) {
        p_295232_ = p_295232_.update("front_text", DropInvalidSignDataFix::fixText);
        p_295232_ = p_295232_.update("back_text", DropInvalidSignDataFix::fixText);
        for (String $$1 : BlockEntitySignDoubleSidedEditableTextFix.FIELDS_TO_DROP) {
            p_295232_ = p_295232_.remove($$1);
        }
        return p_295232_;
    }

    private static <T> Dynamic<T> fixText(Dynamic<T> p_296074_) {
        Optional $$1 = p_296074_.get("filtered_messages").asStreamOpt().result();
        if ($$1.isEmpty()) {
            return p_296074_;
        }
        Dynamic $$2 = LegacyComponentDataFixUtils.createEmptyComponent(p_296074_.getOps());
        List<Dynamic> $$3 = p_296074_.get("messages").asStreamOpt().result().orElse(Stream.of(new Dynamic[0])).toList();
        List $$4 = Streams.mapWithIndex((Stream)((Stream)$$1.get()), (p_294909_, p_296017_) -> {
            Dynamic $$4 = p_296017_ < (long)$$3.size() ? (Dynamic)$$3.get((int)p_296017_) : $$2;
            return p_294909_.equals((Object)$$2) ? $$4 : p_294909_;
        }).toList();
        if ($$4.equals($$3)) {
            return p_296074_.remove("filtered_messages");
        }
        return p_296074_.set("filtered_messages", p_296074_.createList($$4.stream()));
    }

    public TypeRewriteRule makeRule() {
        Type $$0 = this.getInputSchema().getType(References.BLOCK_ENTITY);
        Type $$1 = this.getInputSchema().getChoiceType(References.BLOCK_ENTITY, this.entityName);
        OpticFinder $$2 = DSL.namedChoice((String)this.entityName, (Type)$$1);
        return this.fixTypeEverywhereTyped("DropInvalidSignDataFix for " + this.entityName, $$0, p_392821_ -> p_392821_.updateTyped($$2, $$1, p_392818_ -> {
            boolean $$2 = ((Dynamic)p_392818_.get(DSL.remainderFinder())).get("_filtered_correct").asBoolean(false);
            if ($$2) {
                return p_392818_.update(DSL.remainderFinder(), p_392816_ -> p_392816_.remove("_filtered_correct"));
            }
            return Util.writeAndReadTypedOrThrow(p_392818_, $$1, this::fix);
        }));
    }
}

