/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.util.datafix.ExtraDataFixUtils;
import net.minecraft.util.datafix.fixes.References;

public class InlineBlockPosFormatFix
extends DataFix {
    public InlineBlockPosFormatFix(Schema p_404647_) {
        super(p_404647_, false);
    }

    public TypeRewriteRule makeRule() {
        OpticFinder<?> $$0 = this.entityFinder("minecraft:vex");
        OpticFinder<?> $$1 = this.entityFinder("minecraft:phantom");
        OpticFinder<?> $$2 = this.entityFinder("minecraft:turtle");
        List<OpticFinder<?>> $$3 = List.of(this.entityFinder("minecraft:item_frame"), this.entityFinder("minecraft:glow_item_frame"), this.entityFinder("minecraft:painting"), this.entityFinder("minecraft:leash_knot"));
        return TypeRewriteRule.seq((TypeRewriteRule)this.fixTypeEverywhereTyped("InlineBlockPosFormatFix - player", this.getInputSchema().getType(References.PLAYER), p_404865_ -> p_404865_.update(DSL.remainderFinder(), this::fixPlayer)), (TypeRewriteRule)this.fixTypeEverywhereTyped("InlineBlockPosFormatFix - entity", this.getInputSchema().getType(References.ENTITY), p_404996_ -> {
            p_404996_ = p_404996_.update(DSL.remainderFinder(), this::fixLivingEntity).updateTyped($$0, p_405778_ -> p_405778_.update(DSL.remainderFinder(), this::fixVex)).updateTyped($$1, p_405644_ -> p_405644_.update(DSL.remainderFinder(), this::fixPhantom)).updateTyped($$2, p_405664_ -> p_405664_.update(DSL.remainderFinder(), this::fixTurtle));
            for (OpticFinder $$5 : $$3) {
                p_404996_ = p_404996_.updateTyped($$5, p_404887_ -> p_404887_.update(DSL.remainderFinder(), this::fixBlockAttached));
            }
            return p_404996_;
        }));
    }

    private OpticFinder<?> entityFinder(String p_404811_) {
        return DSL.namedChoice((String)p_404811_, (Type)this.getInputSchema().getChoiceType(References.ENTITY, p_404811_));
    }

    private Dynamic<?> fixPlayer(Dynamic<?> p_405309_) {
        Optional $$5;
        p_405309_ = this.fixLivingEntity(p_405309_);
        Optional $$1 = p_405309_.get("SpawnX").asNumber().result();
        Optional $$2 = p_405309_.get("SpawnY").asNumber().result();
        Optional $$3 = p_405309_.get("SpawnZ").asNumber().result();
        if ($$1.isPresent() && $$2.isPresent() && $$3.isPresent()) {
            Dynamic $$4 = p_405309_.createMap(Map.of(p_405309_.createString("pos"), ExtraDataFixUtils.createBlockPos(p_405309_, ((Number)$$1.get()).intValue(), ((Number)$$2.get()).intValue(), ((Number)$$3.get()).intValue())));
            $$4 = Dynamic.copyField(p_405309_, (String)"SpawnAngle", (Dynamic)$$4, (String)"angle");
            $$4 = Dynamic.copyField(p_405309_, (String)"SpawnDimension", (Dynamic)$$4, (String)"dimension");
            $$4 = Dynamic.copyField(p_405309_, (String)"SpawnForced", (Dynamic)$$4, (String)"forced");
            p_405309_ = p_405309_.remove("SpawnX").remove("SpawnY").remove("SpawnZ").remove("SpawnAngle").remove("SpawnDimension").remove("SpawnForced");
            p_405309_ = p_405309_.set("respawn", $$4);
        }
        if (($$5 = p_405309_.get("enteredNetherPosition").result()).isPresent()) {
            p_405309_ = p_405309_.remove("enteredNetherPosition").set("entered_nether_pos", p_405309_.createList(Stream.of(p_405309_.createDouble(((Dynamic)$$5.get()).get("x").asDouble(0.0)), p_405309_.createDouble(((Dynamic)$$5.get()).get("y").asDouble(0.0)), p_405309_.createDouble(((Dynamic)$$5.get()).get("z").asDouble(0.0)))));
        }
        return p_405309_;
    }

    private Dynamic<?> fixLivingEntity(Dynamic<?> p_405023_) {
        return ExtraDataFixUtils.fixInlineBlockPos(p_405023_, "SleepingX", "SleepingY", "SleepingZ", "sleeping_pos");
    }

    private Dynamic<?> fixVex(Dynamic<?> p_404948_) {
        return ExtraDataFixUtils.fixInlineBlockPos(p_404948_.renameField("LifeTicks", "life_ticks"), "BoundX", "BoundY", "BoundZ", "bound_pos");
    }

    private Dynamic<?> fixPhantom(Dynamic<?> p_404710_) {
        return ExtraDataFixUtils.fixInlineBlockPos(p_404710_.renameField("Size", "size"), "AX", "AY", "AZ", "anchor_pos");
    }

    private Dynamic<?> fixTurtle(Dynamic<?> p_404724_) {
        p_404724_ = p_404724_.remove("TravelPosX").remove("TravelPosY").remove("TravelPosZ");
        p_404724_ = ExtraDataFixUtils.fixInlineBlockPos(p_404724_, "HomePosX", "HomePosY", "HomePosZ", "home_pos");
        return p_404724_.renameField("HasEgg", "has_egg");
    }

    private Dynamic<?> fixBlockAttached(Dynamic<?> p_404684_) {
        return ExtraDataFixUtils.fixInlineBlockPos(p_404684_, "TileX", "TileY", "TileZ", "block_pos");
    }
}

