/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.gson.JsonElement;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JavaOps;
import com.mojang.serialization.JsonOps;
import java.util.Map;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.datafix.fixes.References;

public class LegacyHoverEventFix
extends DataFix {
    public LegacyHoverEventFix(Schema p_394437_) {
        super(p_394437_, false);
    }

    protected TypeRewriteRule makeRule() {
        Type $$0 = this.getInputSchema().getType(References.TEXT_COMPONENT).findFieldType("hoverEvent");
        return this.createFixer(this.getInputSchema().getTypeRaw(References.TEXT_COMPONENT), $$0);
    }

    private <C, H extends Pair<String, ?>> TypeRewriteRule createFixer(Type<C> p_393921_, Type<H> p_393491_) {
        Type $$2 = DSL.named((String)References.TEXT_COMPONENT.typeName(), (Type)DSL.or((Type)DSL.or((Type)DSL.string(), (Type)DSL.list(p_393921_)), (Type)DSL.and((Type)DSL.optional((Type)DSL.field((String)"extra", (Type)DSL.list(p_393921_))), (Type)DSL.optional((Type)DSL.field((String)"separator", p_393921_)), (Type)DSL.optional((Type)DSL.field((String)"hoverEvent", p_393491_)), (Type)DSL.remainderType())));
        if (!$$2.equals((Object)this.getInputSchema().getType(References.TEXT_COMPONENT))) {
            throw new IllegalStateException("Text component type did not match, expected " + String.valueOf($$2) + " but got " + String.valueOf(this.getInputSchema().getType(References.TEXT_COMPONENT)));
        }
        return this.fixTypeEverywhere("LegacyHoverEventFix", $$2, p_394584_ -> p_394164_ -> p_394164_.mapSecond(p_393535_ -> p_393535_.mapRight(p_394347_ -> p_394347_.mapSecond(p_393557_ -> p_393557_.mapSecond(p_394017_ -> {
            Dynamic $$2 = (Dynamic)p_394017_.getSecond();
            Optional $$3 = $$2.get("hoverEvent").result();
            if ($$3.isEmpty()) {
                return p_394017_;
            }
            Optional $$4 = ((Dynamic)$$3.get()).get("value").result();
            if ($$4.isEmpty()) {
                return p_394017_;
            }
            String $$5 = ((Either)p_394017_.getFirst()).left().map(Pair::getFirst).orElse("");
            Pair $$6 = (Pair)this.fixHoverEvent(p_393491_, $$5, (Dynamic)$$3.get());
            return p_394017_.mapFirst(p_393590_ -> Either.left((Object)$$6));
        })))));
    }

    private <H> H fixHoverEvent(Type<H> p_394028_, String p_394084_, Dynamic<?> p_394517_) {
        if ("show_text".equals(p_394084_)) {
            return LegacyHoverEventFix.fixShowTextHover(p_394028_, p_394517_);
        }
        return LegacyHoverEventFix.createPlaceholderHover(p_394028_, p_394517_);
    }

    private static <H> H fixShowTextHover(Type<H> p_393521_, Dynamic<?> p_394195_) {
        Dynamic $$2 = p_394195_.renameField("value", "contents");
        return (H)Util.readTypedOrThrow(p_393521_, $$2).getValue();
    }

    private static <H> H createPlaceholderHover(Type<H> p_393539_, Dynamic<?> p_394275_) {
        JsonElement $$2 = (JsonElement)p_394275_.convert((DynamicOps)JsonOps.INSTANCE).getValue();
        Dynamic $$3 = new Dynamic((DynamicOps)JavaOps.INSTANCE, Map.of("action", "show_text", "contents", Map.of("text", "Legacy hoverEvent: " + GsonHelper.toStableString($$2))));
        return (H)Util.readTypedOrThrow(p_393539_, $$3).getValue();
    }
}

