/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import net.minecraft.Util;
import net.minecraft.util.datafix.ExtraDataFixUtils;

public abstract class NamedEntityWriteReadFix
extends DataFix {
    private final String name;
    private final String entityName;
    private final DSL.TypeReference type;

    public NamedEntityWriteReadFix(Schema p_307236_, boolean p_307467_, String p_307246_, DSL.TypeReference p_307497_, String p_307636_) {
        super(p_307236_, p_307467_);
        this.name = p_307246_;
        this.type = p_307497_;
        this.entityName = p_307636_;
    }

    public TypeRewriteRule makeRule() {
        Type $$0 = this.getInputSchema().getType(this.type);
        Type $$1 = this.getInputSchema().getChoiceType(this.type, this.entityName);
        Type $$2 = this.getOutputSchema().getType(this.type);
        OpticFinder $$3 = DSL.namedChoice((String)this.entityName, (Type)$$1);
        Type<?> $$4 = ExtraDataFixUtils.patchSubType($$0, $$0, $$2);
        return this.fix($$0, $$2, $$4, $$3);
    }

    private <S, T, A> TypeRewriteRule fix(Type<S> p_324369_, Type<T> p_323537_, Type<?> p_324518_, OpticFinder<A> p_324194_) {
        return this.fixTypeEverywhereTyped(this.name, p_324369_, p_323537_, p_396589_ -> {
            if (p_396589_.getOptional(p_324194_).isEmpty()) {
                return ExtraDataFixUtils.cast(p_323537_, p_396589_);
            }
            Typed $$4 = ExtraDataFixUtils.cast(p_324518_, p_396589_);
            return Util.writeAndReadTypedOrThrow($$4, p_323537_, this::fix);
        });
    }

    protected abstract <T> Dynamic<T> fix(Dynamic<T> var1);
}

