/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.util.datafix.ExtraDataFixUtils;
import net.minecraft.util.datafix.fixes.References;

public class TextComponentHoverAndClickEventFix
extends DataFix {
    public TextComponentHoverAndClickEventFix(Schema p_393653_) {
        super(p_393653_, true);
    }

    protected TypeRewriteRule makeRule() {
        Type $$0 = this.getInputSchema().getType(References.TEXT_COMPONENT).findFieldType("hoverEvent");
        return this.createFixer(this.getInputSchema().getTypeRaw(References.TEXT_COMPONENT), this.getOutputSchema().getType(References.TEXT_COMPONENT), $$0);
    }

    private <C1, C2, H extends Pair<String, ?>> TypeRewriteRule createFixer(Type<C1> p_394638_, Type<C2> p_393676_, Type<H> p_393897_) {
        Type $$3 = DSL.named((String)References.TEXT_COMPONENT.typeName(), (Type)DSL.or((Type)DSL.or((Type)DSL.string(), (Type)DSL.list(p_394638_)), (Type)DSL.and((Type)DSL.optional((Type)DSL.field((String)"extra", (Type)DSL.list(p_394638_))), (Type)DSL.optional((Type)DSL.field((String)"separator", p_394638_)), (Type)DSL.optional((Type)DSL.field((String)"hoverEvent", p_393897_)), (Type)DSL.remainderType())));
        if (!$$3.equals((Object)this.getInputSchema().getType(References.TEXT_COMPONENT))) {
            throw new IllegalStateException("Text component type did not match, expected " + String.valueOf($$3) + " but got " + String.valueOf(this.getInputSchema().getType(References.TEXT_COMPONENT)));
        }
        Type<?> $$4 = ExtraDataFixUtils.patchSubType($$3, $$3, p_393676_);
        return this.fixTypeEverywhere("TextComponentHoverAndClickEventFix", $$3, p_393676_, p_394396_ -> p_394417_ -> {
            boolean $$4 = (Boolean)((Either)p_394417_.getSecond()).map(p_394057_ -> false, p_394065_ -> {
                Pair $$1 = (Pair)((Pair)p_394065_.getSecond()).getSecond();
                boolean $$2 = ((Either)$$1.getFirst()).left().isPresent();
                boolean $$3 = ((Dynamic)$$1.getSecond()).get("clickEvent").result().isPresent();
                return $$2 || $$3;
            });
            if (!$$4) {
                return p_394417_;
            }
            return Util.writeAndReadTypedOrThrow(ExtraDataFixUtils.cast($$4, p_394417_, p_394396_), p_393676_, TextComponentHoverAndClickEventFix::fixTextComponent).getValue();
        });
    }

    private static Dynamic<?> fixTextComponent(Dynamic<?> p_394354_) {
        return p_394354_.renameAndFixField("hoverEvent", "hover_event", TextComponentHoverAndClickEventFix::fixHoverEvent).renameAndFixField("clickEvent", "click_event", TextComponentHoverAndClickEventFix::fixClickEvent);
    }

    private static Dynamic<?> copyFields(Dynamic<?> p_393943_, Dynamic<?> p_394371_, String ... p_394668_) {
        for (String $$3 : p_394668_) {
            p_393943_ = Dynamic.copyField(p_394371_, (String)$$3, p_393943_, (String)$$3);
        }
        return p_393943_;
    }

    private static Dynamic<?> fixHoverEvent(Dynamic<?> p_394485_) {
        String $$1;
        return switch ($$1 = p_394485_.get("action").asString("")) {
            case "show_text" -> p_394485_.renameField("contents", "value");
            case "show_item" -> {
                Dynamic $$2 = p_394485_.get("contents").orElseEmptyMap();
                Optional $$3 = $$2.asString().result();
                if ($$3.isPresent()) {
                    yield p_394485_.renameField("contents", "id");
                }
                yield TextComponentHoverAndClickEventFix.copyFields(p_394485_.remove("contents"), $$2, "id", "count", "components");
            }
            case "show_entity" -> {
                Dynamic $$4 = p_394485_.get("contents").orElseEmptyMap();
                yield TextComponentHoverAndClickEventFix.copyFields(p_394485_.remove("contents"), $$4, "id", "type", "name").renameField("id", "uuid").renameField("type", "id");
            }
            default -> p_394485_;
        };
    }

    @Nullable
    private static <T> Dynamic<T> fixClickEvent(Dynamic<T> p_394405_) {
        String $$1 = p_394405_.get("action").asString("");
        String $$2 = p_394405_.get("value").asString("");
        return switch ($$1) {
            case "open_url" -> {
                if (!TextComponentHoverAndClickEventFix.validateUri($$2)) {
                    yield null;
                }
                yield p_394405_.renameField("value", "url");
            }
            case "open_file" -> p_394405_.renameField("value", "path");
            case "run_command", "suggest_command" -> {
                if (!TextComponentHoverAndClickEventFix.validateChat($$2)) {
                    yield null;
                }
                yield p_394405_.renameField("value", "command");
            }
            case "change_page" -> {
                Integer $$3 = p_394405_.get("value").result().map(TextComponentHoverAndClickEventFix::parseOldPage).orElse(null);
                if ($$3 == null) {
                    yield null;
                }
                int $$4 = Math.max($$3, 1);
                yield p_394405_.remove("value").set("page", p_394405_.createInt($$4));
            }
            default -> p_394405_;
        };
    }

    @Nullable
    private static Integer parseOldPage(Dynamic<?> p_394445_) {
        Optional $$1 = p_394445_.asNumber().result();
        if ($$1.isPresent()) {
            return ((Number)$$1.get()).intValue();
        }
        try {
            return Integer.parseInt(p_394445_.asString(""));
        }
        catch (Exception $$2) {
            return null;
        }
    }

    private static boolean validateUri(String p_393641_) {
        try {
            URI $$1 = new URI(p_393641_);
            String $$2 = $$1.getScheme();
            if ($$2 == null) {
                return false;
            }
            String $$3 = $$2.toLowerCase(Locale.ROOT);
            return "http".equals($$3) || "https".equals($$3);
        }
        catch (URISyntaxException $$4) {
            return false;
        }
    }

    private static boolean validateChat(String p_394051_) {
        for (int $$1 = 0; $$1 < p_394051_.length(); ++$$1) {
            char $$2 = p_394051_.charAt($$1);
            if ($$2 != '\u00a7' && $$2 >= ' ' && $$2 != '\u007f') continue;
            return false;
        }
        return true;
    }
}

